/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions;

import java.math.BigDecimal;
import javax.xml.datatype.DatatypeConstants;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.DecimalValue;
import org.exist.xquery.value.DurationValue;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class FunGetDurationComponent
extends BasicFunction {
    public static final FunctionSignature fnDaysFromDuration = new FunctionSignature(new QName("days-from-duration", "http://www.w3.org/2005/xpath-functions"), "Returns an xs:integer representing the days component in the canonical lexical representation of the value of $a. The result may be negative.", new SequenceType[]{new SequenceType(55, 3)}, new SequenceType(31, 3));
    public static final FunctionSignature fnHoursFromDuration = new FunctionSignature(new QName("hours-from-duration", "http://www.w3.org/2005/xpath-functions"), "Returns an xs:integer representing the hours component in the canonical lexical representation of the value of $a. The result may be negative.", new SequenceType[]{new SequenceType(55, 3)}, new SequenceType(31, 3));
    public static final FunctionSignature fnMinutesFromDuration = new FunctionSignature(new QName("minutes-from-duration", "http://www.w3.org/2005/xpath-functions"), "Returns an xs:integer representing the minutes component in the canonical lexical representation of the value of $a. The result may be negative.", new SequenceType[]{new SequenceType(55, 3)}, new SequenceType(31, 3));
    public static final FunctionSignature fnSecondsFromDuration = new FunctionSignature(new QName("seconds-from-duration", "http://www.w3.org/2005/xpath-functions"), "Returns an xs:decimal representing the seconds component in the canonical lexical representation of the value of $a. The result may be negative", new SequenceType[]{new SequenceType(55, 3)}, new SequenceType(32, 3));
    public static final FunctionSignature fnMonthsFromDuration = new FunctionSignature(new QName("months-from-duration", "http://www.w3.org/2005/xpath-functions"), "Returns an xs:integer representing the months component in the canonical lexical representation of the value of $a. The result may be negative.", new SequenceType[]{new SequenceType(54, 3)}, new SequenceType(31, 3));
    public static final FunctionSignature fnYearsFromDuration = new FunctionSignature(new QName("years-from-duration", "http://www.w3.org/2005/xpath-functions"), "Returns an xs:integer representing the years component in the canonical lexical representation of the value of $a. The result may be negative.", new SequenceType[]{new SequenceType(54, 3)}, new SequenceType(31, 3));

    public FunGetDurationComponent(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        Sequence result;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
        }
        if (args.length == 0 || args[0].isEmpty()) {
            result = Sequence.EMPTY_SEQUENCE;
        } else {
            Sequence arg = args[0];
            DurationValue duration = new DurationValue(((DurationValue)arg.itemAt(0)).getCanonicalDuration());
            if (this.isCalledAs("days-from-duration")) {
                result = new IntegerValue(duration.getPart(2));
            } else if (this.isCalledAs("hours-from-duration")) {
                result = new IntegerValue(duration.getPart(3));
            } else if (this.isCalledAs("minutes-from-duration")) {
                result = new IntegerValue(duration.getPart(4));
            } else if (this.isCalledAs("seconds-from-duration")) {
                result = duration.getCanonicalDuration().getField(DatatypeConstants.SECONDS) == null ? new DecimalValue(0.0) : new DecimalValue((BigDecimal)duration.getCanonicalDuration().getField(DatatypeConstants.SECONDS));
                if (duration.getCanonicalDuration().getSign() < 0) {
                    result = ((DecimalValue)result).negate();
                }
            } else if (this.isCalledAs("months-from-duration")) {
                result = new IntegerValue(duration.getPart(1));
            } else if (this.isCalledAs("years-from-duration")) {
                result = new IntegerValue(duration.getPart(0));
            } else {
                throw new Error("can't handle function " + this.mySignature.getName().getLocalName());
            }
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

