/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.dom.DocumentSet;
import org.exist.xquery.AbstractExpression;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.Profiler;
import org.exist.xquery.Variable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;

public class VariableReference
extends AbstractExpression {
    private final String qname;

    public VariableReference(XQueryContext context, String qname) {
        super(context);
        this.qname = qname;
    }

    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        Variable var = this.getVariable();
        if (var == null) {
            throw new XPathException(this.getASTNode(), "XPDY0002 : variable '$" + this.qname + "' is not set.");
        }
        if (!var.isInitialized()) {
            throw new XPathException(this.getASTNode(), "XQST0054: variable declaration of '$" + this.qname + "' cannot " + "be executed because of a circularity.");
        }
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Variable var;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if ((var = this.getVariable()) == null) {
            throw new XPathException(this.getASTNode(), "XPDY0002 : variable '$" + this.qname + "' is not set.");
        }
        Sequence seq = var.getValue();
        if (seq == null) {
            throw new XPathException(this.getASTNode(), "XPDY0002 : undefined value for variable '$" + this.qname + "'");
        }
        Sequence result = seq;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }

    protected Variable getVariable() throws XPathException {
        try {
            return this.context.resolveVariable(this.qname);
        }
        catch (XPathException e) {
            e.setASTNode(this.getASTNode());
            throw e;
        }
    }

    public DocumentSet preselect(DocumentSet in_docs) throws XPathException {
        return in_docs;
    }

    public void dump(ExpressionDumper dumper) {
        dumper.display('$').display(this.qname);
    }

    public String toString() {
        return "$" + this.qname;
    }

    public int returnsType() {
        try {
            Variable var = this.context.resolveVariable(this.qname);
            if (var != null) {
                if (var.getValue() != null) {
                    int type = var.getValue().getItemType();
                    return type;
                }
                return var.getType();
            }
        }
        catch (XPathException xPathException) {
            // empty catch block
        }
        return 11;
    }

    public int getDependencies() {
        try {
            Variable var = this.context.resolveVariable(this.qname);
            if (var != null) {
                int deps = var.getDependencies(this.context);
                return deps;
            }
        }
        catch (XPathException xPathException) {
            // empty catch block
        }
        return 3;
    }

    public int getCardinality() {
        try {
            Variable var = this.context.resolveVariable(this.qname);
            if (var != null && var.getValue() != null) {
                int card = var.getValue().getCardinality();
                return card;
            }
        }
        catch (XPathException xPathException) {
            // empty catch block
        }
        return 7;
    }

    public void resetState(boolean postOptimization) {
    }
}

