/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exist.dom.QName;
import org.exist.xquery.XPathException;

public class Option {
    public static final QName TIMEOUT_QNAME = new QName("timeout", "http://exist.sourceforge.net/NS/exist");
    public static final QName OUTPUT_SIZE_QNAME = new QName("output-size-limit", "http://exist.sourceforge.net/NS/exist");
    public static final QName SERIALIZE_QNAME = new QName("serialize", "http://exist.sourceforge.net/NS/exist");
    public static final QName PROFILE_QNAME = new QName("profiling", "http://exist.sourceforge.net/NS/exist");
    public static final QName OPTIMIZE_QNAME = new QName("optimize", "http://exist.sourceforge.net/NS/exist");
    public static final QName OPTIMIZE_IMPLICIT_TIMEZONE = new QName("implicit-timezone", "http://exist.sourceforge.net/NS/exist");
    public static final QName CURRENT_DATETIME = new QName("current-dateTime", "http://exist.sourceforge.net/NS/exist");
    private static final String paramPattern = "\\s*([\\w\\.-]+)\\s*=\\s*('[^']*'|\"[^\"]*\"|[^\\s]+)";
    private static final Pattern pattern = Pattern.compile("\\s*([\\w\\.-]+)\\s*=\\s*('[^']*'|\"[^\"]*\"|[^\\s]+)");
    private static final Matcher matcher = pattern.matcher("");
    private final QName qname;
    private final String contents;

    public Option(QName qname, String contents) throws XPathException {
        if (qname.getPrefix() == null || "".equals(qname.getPrefix())) {
            throw new XPathException("XPST0081: options must have a prefix");
        }
        this.qname = qname;
        this.contents = contents;
    }

    public QName getQName() {
        return this.qname;
    }

    public String getContents() {
        return this.contents;
    }

    public String[] tokenizeContents() {
        return Option.tokenize(this.contents);
    }

    public static String[] tokenize(String contents) {
        if (contents == null) {
            return new String[0];
        }
        StringTokenizer tok = new StringTokenizer(contents, " \r\t\n");
        String[] items = new String[tok.countTokens()];
        int i = 0;
        while (tok.hasMoreTokens()) {
            items[i] = tok.nextToken();
            ++i;
        }
        return items;
    }

    public static synchronized String[] parseKeyValuePair(String s) {
        matcher.reset(s);
        if (matcher.matches()) {
            String value = matcher.group(2);
            if (value.charAt(0) == '\'' || value.charAt(0) == '\"') {
                value = value.substring(1, value.length() - 1);
            }
            return new String[]{matcher.group(1), value};
        }
        return null;
    }

    public boolean equals(Object other) {
        if (other instanceof Option) {
            return this.qname.equalsSimple(((Option)other).qname);
        }
        return false;
    }
}

