/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb;

import java.io.IOException;
import java.io.StringReader;
import java.net.URISyntaxException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.exist.EXistException;
import org.exist.cluster.ClusterComunication;
import org.exist.collections.Collection;
import org.exist.dom.DocumentImpl;
import org.exist.dom.DocumentSet;
import org.exist.security.PermissionDeniedException;
import org.exist.security.User;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.txn.TransactionManager;
import org.exist.storage.txn.Txn;
import org.exist.xmldb.LocalCollection;
import org.exist.xmldb.XmldbURI;
import org.exist.xupdate.Modification;
import org.exist.xupdate.XUpdateProcessor;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.XUpdateQueryService;

public class LocalXUpdateQueryService
implements XUpdateQueryService {
    private static final Logger LOG = Logger.getLogger((Class)LocalXUpdateQueryService.class);
    private BrokerPool pool;
    private User user;
    private LocalCollection parent;
    private XUpdateProcessor processor = null;

    public LocalXUpdateQueryService(User user, BrokerPool pool, LocalCollection parent) {
        this.pool = pool;
        this.user = user;
        this.parent = parent;
    }

    public long updateResource(String resource, String xupdate) throws XMLDBException {
        long start = System.currentTimeMillis();
        DocumentSet docs = new DocumentSet();
        TransactionManager transact = this.pool.getTransactionManager();
        Txn transaction = transact.beginTransaction();
        DBBroker broker = null;
        Collection c = this.parent.getCollection();
        try {
            broker = this.pool.get(this.user);
            if (resource == null) {
                docs = c.allDocs(broker, docs, true, true);
            } else {
                XmldbURI resourceURI = XmldbURI.xmldbUriFor(resource);
                DocumentImpl doc = c.getDocument(broker, resourceURI);
                if (doc == null) {
                    transact.abort(transaction);
                    throw new XMLDBException(301, "Resource not found: " + resource);
                }
                docs.add(doc);
            }
            if (this.processor == null) {
                this.processor = new XUpdateProcessor(broker, docs, this.parent.getAccessContext());
            } else {
                this.processor.setBroker(broker);
                this.processor.setDocumentSet(docs);
            }
            Modification[] modifications = this.processor.parse(new InputSource(new StringReader(xupdate)));
            long mods = 0L;
            for (int i = 0; i < modifications.length; ++i) {
                mods += modifications[i].process(transaction);
                broker.flush();
            }
            transact.commit(transaction);
            ClusterComunication clCommunication = ClusterComunication.getInstance();
            if (clCommunication != null) {
                clCommunication.update(resource, c.getURI().toString(), xupdate);
            }
            LOG.debug((Object)("xupdate took " + (System.currentTimeMillis() - start) + "ms."));
            long l = mods;
            return l;
        }
        catch (ParserConfigurationException e) {
            transact.abort(transaction);
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            transact.abort(transaction);
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
        catch (SAXException e) {
            transact.abort(transaction);
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
        catch (URISyntaxException e) {
            transact.abort(transaction);
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
        catch (PermissionDeniedException e) {
            transact.abort(transaction);
            throw new XMLDBException(4, e.getMessage());
        }
        catch (EXistException e) {
            transact.abort(transaction);
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            transact.abort(transaction);
            e.printStackTrace();
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
        finally {
            if (this.processor != null) {
                this.processor.reset();
            }
            this.pool.release(broker);
        }
    }

    public long update(String arg1) throws XMLDBException {
        return this.updateResource(null, arg1);
    }

    public String getName() throws XMLDBException {
        return "XUpdateQueryService";
    }

    public String getVersion() throws XMLDBException {
        return "1.0";
    }

    public void setCollection(org.xmldb.api.base.Collection arg0) throws XMLDBException {
    }

    public String getProperty(String arg0) throws XMLDBException {
        return null;
    }

    public void setProperty(String arg0, String arg1) throws XMLDBException {
    }
}

