/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.dom.DocumentSet;
import org.exist.dom.ExtArrayNodeSet;
import org.exist.dom.NodeProxy;
import org.exist.dom.NodeSet;
import org.exist.security.User;
import org.exist.security.xacml.AccessContext;
import org.exist.security.xacml.NullAccessContextException;
import org.exist.source.Source;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.XQueryPool;
import org.exist.storage.lock.LockedDocumentMap;
import org.exist.util.LockException;
import org.exist.xmldb.LocalCollection;
import org.exist.xmldb.LocalResourceSet;
import org.exist.xmldb.LocalXMLResource;
import org.exist.xmldb.XPathQueryServiceImpl;
import org.exist.xmldb.XQueryService;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.CompiledXQuery;
import org.exist.xquery.Option;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQuery;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.AnyURIValue;
import org.exist.xquery.value.Sequence;
import org.xmldb.api.base.CompiledExpression;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.XMLResource;

public class LocalXPathQueryService
implements XPathQueryServiceImpl,
XQueryService {
    private static final Logger LOG = Logger.getLogger((Class)LocalXPathQueryService.class);
    protected BrokerPool brokerPool;
    protected LocalCollection collection;
    protected User user;
    protected TreeMap namespaceDecls = new TreeMap();
    protected TreeMap variableDecls = new TreeMap();
    protected boolean xpathCompatible = true;
    protected String moduleLoadPath = null;
    protected Properties properties = null;
    protected boolean lockDocuments = false;
    protected LockedDocumentMap lockedDocuments = null;
    protected DBBroker reservedBroker = null;
    protected AccessContext accessCtx;

    private LocalXPathQueryService() {
    }

    public LocalXPathQueryService(User user, BrokerPool pool, LocalCollection collection, AccessContext accessCtx) {
        if (accessCtx == null) {
            throw new NullAccessContextException();
        }
        this.accessCtx = accessCtx;
        this.user = user;
        this.collection = collection;
        this.brokerPool = pool;
        this.properties = new Properties(collection.properties);
    }

    public void clearNamespaces() throws XMLDBException {
        this.namespaceDecls.clear();
    }

    public String getName() throws XMLDBException {
        return "XPathQueryService";
    }

    public String getNamespace(String prefix) throws XMLDBException {
        return (String)this.namespaceDecls.get(prefix);
    }

    public String getProperty(String property) throws XMLDBException {
        return this.properties.getProperty(property);
    }

    public String getVersion() throws XMLDBException {
        return "1.0";
    }

    public ResourceSet query(String query) throws XMLDBException {
        return this.query(query, null);
    }

    public ResourceSet query(XMLResource res, String query) throws XMLDBException {
        return this.query(res, query, null);
    }

    public ResourceSet query(String query, String sortBy) throws XMLDBException {
        XmldbURI[] docs = new XmldbURI[]{XmldbURI.create(this.collection.getName())};
        return this.doQuery(query, docs, null, sortBy);
    }

    public ResourceSet query(XMLResource res, String query, String sortBy) throws XMLDBException {
        NodeProxy node = ((LocalXMLResource)res).getNode();
        if (node == null) {
            XmldbURI[] docs = new XmldbURI[]{XmldbURI.create(res.getParentCollection().getName()).append(res.getDocumentId())};
            return this.doQuery(query, docs, null, sortBy);
        }
        ExtArrayNodeSet set = new ExtArrayNodeSet(1);
        set.add(node);
        XmldbURI[] docs = new XmldbURI[]{node.getDocument().getURI()};
        return this.doQuery(query, docs, set, sortBy);
    }

    public ResourceSet execute(CompiledExpression expression) throws XMLDBException {
        return this.execute(null, null, expression, null);
    }

    public ResourceSet execute(XMLResource res, CompiledExpression expression) throws XMLDBException {
        NodeProxy node = ((LocalXMLResource)res).getNode();
        if (node == null) {
            XmldbURI[] docs = new XmldbURI[]{XmldbURI.create(res.getParentCollection().getName()).append(res.getDocumentId())};
            return this.execute(docs, null, expression, null);
        }
        ExtArrayNodeSet set = new ExtArrayNodeSet(1);
        set.add(node);
        XmldbURI[] docs = new XmldbURI[]{node.getDocument().getURI()};
        return this.execute(docs, set, expression, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceSet execute(Source source) throws XMLDBException {
        Sequence result;
        long start = System.currentTimeMillis();
        DBBroker broker = null;
        try {
            broker = this.brokerPool.get(this.user);
            XmldbURI[] docs = new XmldbURI[]{XmldbURI.create(this.collection.getName())};
            XQuery xquery = broker.getXQueryService();
            XQueryPool pool = xquery.getXQueryPool();
            CompiledXQuery compiled = pool.borrowCompiledXQuery(broker, source);
            XQueryContext context = compiled == null ? xquery.newContext(this.accessCtx) : compiled.getContext();
            context.setStaticallyKnownDocuments(docs);
            this.setupContext(context);
            if (compiled == null) {
                compiled = xquery.compile(context, source);
            }
            try {
                result = xquery.execute(compiled, null);
                this.checkPragmas(context);
            }
            finally {
                pool.returnCompiledXQuery(source, compiled);
            }
        }
        catch (EXistException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
        catch (XPathException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
        finally {
            this.brokerPool.release(broker);
        }
        LOG.debug((Object)("query took " + (System.currentTimeMillis() - start) + " ms."));
        if (result != null) {
            return new LocalResourceSet(this.user, this.brokerPool, this.collection, this.properties, result, null);
        }
        return null;
    }

    public CompiledExpression compile(String query) throws XMLDBException {
        try {
            return this.compileAndCheck(query);
        }
        catch (XPathException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CompiledExpression compileAndCheck(String query) throws XMLDBException, XPathException {
        CompiledXQuery compiledXQuery;
        DBBroker broker = null;
        try {
            long start = System.currentTimeMillis();
            broker = this.brokerPool.get(this.user);
            XQuery xquery = broker.getXQueryService();
            XQueryContext context = xquery.newContext(this.accessCtx);
            this.setupContext(context);
            CompiledXQuery expr = xquery.compile(context, query);
            this.checkPragmas(context);
            LOG.debug((Object)("compilation took " + (System.currentTimeMillis() - start)));
            compiledXQuery = expr;
        }
        catch (EXistException e) {
            try {
                throw new XMLDBException(1, e.getMessage(), (Throwable)e);
                catch (IllegalArgumentException e2) {
                    throw new XMLDBException(1, e2.getMessage(), (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                this.brokerPool.release(broker);
                throw throwable;
            }
        }
        this.brokerPool.release(broker);
        return compiledXQuery;
    }

    public ResourceSet queryResource(String resource, String query) throws XMLDBException {
        LocalXMLResource res = (LocalXMLResource)this.collection.getResource(resource);
        if (res == null) {
            throw new XMLDBException(301, "resource '" + resource + "' not found");
        }
        XmldbURI[] docs = new XmldbURI[]{XmldbURI.create(res.getParentCollection().getName()).append(res.getDocumentId())};
        return this.doQuery(query, docs, null, null);
    }

    protected void setupContext(XQueryContext context) throws XMLDBException, XPathException {
        Map.Entry entry;
        try {
            context.setBaseURI(new AnyURIValue(this.properties.getProperty("base-uri", this.collection.getPath())));
        }
        catch (XPathException e) {
            throw new XMLDBException(5, "Invalid base uri", (Throwable)e);
        }
        if (this.moduleLoadPath != null) {
            context.setModuleLoadPath(this.moduleLoadPath);
        }
        Iterator i = this.namespaceDecls.entrySet().iterator();
        while (i.hasNext()) {
            entry = i.next();
            context.declareNamespace((String)entry.getKey(), (String)entry.getValue());
        }
        i = this.variableDecls.entrySet().iterator();
        while (i.hasNext()) {
            entry = i.next();
            context.declareVariable((String)entry.getKey(), entry.getValue());
        }
    }

    private void checkPragmas(XQueryContext context) throws XPathException {
        Option pragma = context.getOption(Option.SERIALIZE_QNAME);
        if (pragma == null) {
            return;
        }
        String[] contents = pragma.tokenizeContents();
        for (int i = 0; i < contents.length; ++i) {
            String[] pair = Option.parseKeyValuePair(contents[i]);
            if (pair == null) {
                throw new XPathException("Unknown parameter found in " + pragma.getQName().getStringValue() + ": '" + contents[i] + "'");
            }
            LOG.debug((Object)("Setting serialization property from pragma: " + pair[0] + " = " + pair[1]));
            this.properties.setProperty(pair[0], pair[1]);
        }
    }

    private ResourceSet doQuery(String query, XmldbURI[] docs, NodeSet contextSet, String sortExpr) throws XMLDBException {
        CompiledExpression expr = this.compile(query);
        return this.execute(docs, contextSet, expr, sortExpr);
    }

    public void beginProtected() throws XMLDBException {
        try {
            boolean deadlockCaught;
            do {
                this.reservedBroker = this.brokerPool.get(this.user);
                deadlockCaught = false;
                DocumentSet docs = null;
                try {
                    Collection coll = this.collection.getCollection();
                    this.lockedDocuments = new LockedDocumentMap();
                    docs = new DocumentSet();
                    coll.allDocs(this.reservedBroker, docs, true, this.lockedDocuments, 1);
                }
                catch (LockException e) {
                    LOG.debug((Object)("Deadlock detected. Starting over again. Docs: " + docs.getLength() + "; locked: " + this.lockedDocuments.size()));
                    this.lockedDocuments.unlock();
                    this.brokerPool.release(this.reservedBroker);
                    deadlockCaught = true;
                }
            } while (deadlockCaught);
        }
        catch (EXistException e) {
            this.brokerPool.release(this.reservedBroker);
            throw new XMLDBException(1, e.getMessage());
        }
    }

    public void endProtected() {
        this.lockDocuments = false;
        if (this.lockedDocuments != null) {
            this.lockedDocuments.unlock();
        }
        this.lockedDocuments = null;
        if (this.reservedBroker != null) {
            this.brokerPool.release(this.reservedBroker);
        }
        this.reservedBroker = null;
    }

    public void removeNamespace(String ns) throws XMLDBException {
        Iterator i = this.namespaceDecls.values().iterator();
        while (i.hasNext()) {
            if (!((String)i.next()).equals(ns)) continue;
            i.remove();
        }
    }

    private ResourceSet execute(XmldbURI[] docs, NodeSet contextSet, CompiledExpression expression, String sortExpr) throws XMLDBException {
        Sequence result;
        long start = System.currentTimeMillis();
        CompiledXQuery expr = (CompiledXQuery)expression;
        DBBroker broker = null;
        XQueryContext context = expr.getContext();
        try {
            broker = this.brokerPool.get(this.user);
            context.setStaticallyKnownDocuments(docs);
            if (this.lockedDocuments != null) {
                context.setProtectedDocs(this.lockedDocuments);
            }
            this.setupContext(context);
            this.checkPragmas(context);
            XQuery xquery = broker.getXQueryService();
            result = xquery.execute(expr, contextSet);
        }
        catch (EXistException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
        catch (XPathException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
        finally {
            this.brokerPool.release(broker);
        }
        LOG.debug((Object)("query took " + (System.currentTimeMillis() - start) + " ms."));
        if (result != null) {
            return new LocalResourceSet(this.user, this.brokerPool, this.collection, this.properties, result, sortExpr);
        }
        return null;
    }

    public void setCollection(org.xmldb.api.base.Collection col) throws XMLDBException {
    }

    public void setNamespace(String prefix, String namespace) throws XMLDBException {
        this.namespaceDecls.put(prefix, namespace);
    }

    public void setProperty(String property, String value) throws XMLDBException {
        this.properties.setProperty(property, value);
    }

    public void declareVariable(String qname, Object initialValue) throws XMLDBException {
        this.variableDecls.put(qname, initialValue);
    }

    public void setXPathCompatibility(boolean backwardsCompatible) {
        this.xpathCompatible = backwardsCompatible;
    }

    public void setModuleLoadPath(String path) {
        this.moduleLoadPath = path;
    }

    public void dump(CompiledExpression expression, Writer writer) throws XMLDBException {
        CompiledXQuery expr = (CompiledXQuery)expression;
        expr.dump(writer);
    }
}

