/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util.serializer;

import java.io.Writer;
import java.util.Properties;
import javax.xml.transform.TransformerException;
import org.exist.memtree.ReferenceNode;
import org.exist.storage.DBBroker;
import org.exist.storage.serializers.Serializer;
import org.exist.util.serializer.DOMSerializer;
import org.exist.util.serializer.SAXSerializer;
import org.exist.util.serializer.SerializerPool;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class ExtendedDOMSerializer
extends DOMSerializer {
    private DBBroker broker;

    public ExtendedDOMSerializer(DBBroker broker) {
        this.broker = broker;
    }

    public ExtendedDOMSerializer(DBBroker broker, Writer writer, Properties outputProperties) {
        super(writer, outputProperties);
        this.broker = broker;
    }

    protected void startNode(Node node) throws TransformerException {
        if (node.getNodeType() == 100) {
            SAXSerializer handler = (SAXSerializer)SerializerPool.getInstance().borrowObject(SAXSerializer.class);
            handler.setReceiver(this.receiver);
            Serializer serializer = this.broker.getSerializer();
            serializer.setSAXHandlers(handler, handler);
            try {
                serializer.setProperties(this.outputProperties);
                serializer.setProperty("sax-document-events", "false");
            }
            catch (SAXNotRecognizedException e) {
            }
            catch (SAXNotSupportedException e) {
                // empty catch block
            }
            try {
                serializer.toSAX(((ReferenceNode)node).getReference());
            }
            catch (SAXException e) {
                throw new TransformerException(e.getMessage(), e);
            }
            finally {
                SerializerPool.getInstance().returnObject(handler);
            }
        }
        super.startNode(node);
    }
}

