/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.text.CollationElementIterator;
import java.text.Collator;
import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;

public class Collations {
    private static final Logger LOG = Logger.getLogger((Class)Collations.class);
    public static final String CODEPOINT = "http://www.w3.org/2005/xpath-functions/collation/codepoint";
    public static final String CODEPOINT_SHORT = "codepoint";
    public static final String EXIST_COLLATION_URI = "http://exist-db.org/collation";

    public static final Collator getCollationFromURI(XQueryContext context, String uri) throws XPathException {
        if (uri.startsWith(EXIST_COLLATION_URI) || uri.startsWith("?")) {
            URI u = null;
            try {
                u = new URI(uri);
            }
            catch (URISyntaxException e) {
                return null;
            }
            String query = u.getQuery();
            String strength = null;
            if (query == null) {
                return Collations.getCollationFromParams(null, strength, null);
            }
            LOG.debug((Object)("Loading collation: " + query));
            String lang = null;
            String decomposition = null;
            StringTokenizer queryTokenizer = new StringTokenizer(query, ";&");
            while (queryTokenizer.hasMoreElements()) {
                String param = queryTokenizer.nextToken();
                int eq = param.indexOf(61);
                if (eq <= 0) continue;
                String kw = param.substring(0, eq);
                String val = param.substring(eq + 1);
                if (kw.equals("lang")) {
                    lang = val;
                    continue;
                }
                if (kw.equals("strength")) {
                    strength = val;
                    continue;
                }
                if (!kw.equals("decomposition")) continue;
                decomposition = val;
            }
            return Collations.getCollationFromParams(lang, strength, decomposition);
        }
        if (uri.startsWith("java:")) {
            uri = uri.substring("java:".length());
            try {
                Class<?> collatorClass = Class.forName(uri);
                if (!Collator.class.isAssignableFrom(collatorClass)) {
                    throw new XPathException("The specified collator class is not a subclass of java.text.Collator");
                }
                return (Collator)collatorClass.newInstance();
            }
            catch (Exception e) {
                throw new XPathException("err:XQST0038: The specified collator class " + uri + " could not be found", e);
            }
        }
        if (CODEPOINT.equals(uri)) {
            return null;
        }
        throw new XPathException("err:XQST0038: Unknown collation : '" + uri + "'");
    }

    public static final boolean equals(Collator collator, String s1, String s2) {
        if (collator == null) {
            return s1.equals(s2);
        }
        return collator.equals(s1, s2);
    }

    public static final int compare(Collator collator, String s1, String s2) {
        if (collator == null) {
            return s1 == null ? (s2 == null ? 0 : -1) : s1.compareTo(s2);
        }
        return collator.compare(s1, s2);
    }

    public static final boolean startsWith(Collator collator, String s1, String s2) {
        if (collator == null) {
            return s1.startsWith(s2);
        }
        RuleBasedCollator rbc = (RuleBasedCollator)collator;
        CollationElementIterator i1 = rbc.getCollationElementIterator(s1);
        CollationElementIterator i2 = rbc.getCollationElementIterator(s2);
        return Collations.collationStartsWith(i1, i2);
    }

    public static final boolean endsWith(Collator collator, String s1, String s2) {
        if (collator == null) {
            return s1.endsWith(s2);
        }
        RuleBasedCollator rbc = (RuleBasedCollator)collator;
        CollationElementIterator i1 = rbc.getCollationElementIterator(s1);
        CollationElementIterator i2 = rbc.getCollationElementIterator(s2);
        return Collations.collationContains(i1, i2, null, true);
    }

    public static final boolean contains(Collator collator, String s1, String s2) {
        if (collator == null) {
            return s1.indexOf(s2) != -1;
        }
        RuleBasedCollator rbc = (RuleBasedCollator)collator;
        CollationElementIterator i1 = rbc.getCollationElementIterator(s1);
        CollationElementIterator i2 = rbc.getCollationElementIterator(s2);
        return Collations.collationContains(i1, i2, null, false);
    }

    public static final int indexOf(Collator collator, String s1, String s2) {
        CollationElementIterator i2;
        if (collator == null) {
            return s1.indexOf(s2);
        }
        int[] offsets = new int[2];
        RuleBasedCollator rbc = (RuleBasedCollator)collator;
        CollationElementIterator i1 = rbc.getCollationElementIterator(s1);
        if (Collations.collationContains(i1, i2 = rbc.getCollationElementIterator(s2), offsets, false)) {
            return offsets[0];
        }
        return -1;
    }

    private static final boolean collationStartsWith(CollationElementIterator s0, CollationElementIterator s1) {
        while (true) {
            int e0;
            int e1;
            if ((e1 = s1.next()) == 0) {
                continue;
            }
            if (e1 == -1) {
                return true;
            }
            while ((e0 = s0.next()) == 0) {
            }
            if (e0 != e1) break;
        }
        return false;
    }

    private static final boolean collationContains(CollationElementIterator s0, CollationElementIterator s1, int[] offsets, boolean matchAtEnd) {
        int e1;
        while ((e1 = s1.next()) == 0) {
        }
        if (e1 == -1) {
            return true;
        }
        int e0 = -1;
        while (true) {
            if (e0 != e1) {
                while ((e0 = s0.next()) == 0) {
                }
                if (e0 != -1) continue;
                return false;
            }
            int start = s0.getOffset();
            if (Collations.collationStartsWith(s0, s1)) {
                if (matchAtEnd) {
                    while ((e0 = s0.next()) == 0) {
                    }
                    if (e0 == -1) {
                        return true;
                    }
                } else {
                    if (offsets != null) {
                        offsets[0] = start - 1;
                        offsets[1] = s0.getOffset();
                    }
                    return true;
                }
            }
            s0.setOffset(start);
            if (s0.getOffset() != start) {
                s0.next();
            }
            s1.reset();
            e0 = -1;
            while ((e1 = s1.next()) == 0) {
            }
        }
    }

    private static Collator getCollationFromParams(String lang, String strength, String decomposition) throws XPathException {
        Collator collator = null;
        if (lang == null) {
            collator = Collator.getInstance();
        } else if (lang.equals("sme-SE")) {
            String Samisk = "< a,A< \u00e1,\u00c1< b,B< c,C< \u010d,\u010c< d,D< \u0111,\u0110< e,E< f,F< g,G< h,H< i,I< j,J< k,K< l,L< m,M< n,N< \u014b,\u014a< o,O< p,P< r,R< s,S< \u0161,\u0160< t,T< \u0167,\u0166< u,U< v,V< z,Z< \u017e,\u017d";
            try {
                collator = new RuleBasedCollator(Samisk);
            }
            catch (ParseException pe) {
                return null;
            }
        } else {
            Locale locale = Collations.getLocale(lang);
            LOG.debug((Object)("Using locale: " + locale.toString()));
            collator = Collator.getInstance(locale);
        }
        if (strength != null) {
            if ("primary".equals(strength)) {
                collator.setStrength(0);
            } else if ("secondary".equals(strength)) {
                collator.setStrength(1);
            } else if ("tertiary".equals(strength)) {
                collator.setStrength(2);
            } else if (strength.length() == 0 || "identical".equals(strength)) {
                collator.setStrength(3);
            } else {
                throw new XPathException("Collation strength should be either 'primary', 'secondary', 'tertiary' or 'identical");
            }
        }
        if (decomposition != null) {
            if ("none".equals(decomposition)) {
                collator.setDecomposition(0);
            } else if ("full".equals(decomposition)) {
                collator.setDecomposition(2);
            } else if (decomposition.length() == 0 || "standard".equals(decomposition)) {
                collator.setDecomposition(1);
            } else {
                throw new XPathException("Collation decomposition should be either 'none', 'full' or 'standard");
            }
        }
        return collator;
    }

    private static Locale getLocale(String lang) {
        int dashPos = lang.indexOf(45);
        if (dashPos == -1) {
            return new Locale(lang);
        }
        return new Locale(lang.substring(0, dashPos), lang.substring(dashPos + 1));
    }
}

