/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.dom.AttrImpl;
import org.exist.dom.DocumentImpl;
import org.exist.dom.DocumentSet;
import org.exist.dom.ElementImpl;
import org.exist.dom.ExtArrayNodeSet;
import org.exist.dom.NodeProxy;
import org.exist.dom.NodeSet;
import org.exist.dom.QName;
import org.exist.dom.StoredNode;
import org.exist.dom.SymbolTable;
import org.exist.dom.TextImpl;
import org.exist.indexing.AbstractStreamListener;
import org.exist.indexing.IndexUtils;
import org.exist.indexing.IndexWorker;
import org.exist.numbering.NodeId;
import org.exist.storage.ContentLoadingObserver;
import org.exist.storage.DBBroker;
import org.exist.storage.GeneralRangeIndexSpec;
import org.exist.storage.IndexSpec;
import org.exist.storage.Indexable;
import org.exist.storage.NodePath;
import org.exist.storage.QNameRangeIndexSpec;
import org.exist.storage.RangeIndexSpec;
import org.exist.storage.RegexMatcher;
import org.exist.storage.TermMatcher;
import org.exist.storage.ValueIndexFactory;
import org.exist.storage.btree.BTreeCallback;
import org.exist.storage.btree.BTreeException;
import org.exist.storage.btree.DBException;
import org.exist.storage.btree.IndexQuery;
import org.exist.storage.btree.Value;
import org.exist.storage.index.BFile;
import org.exist.storage.io.VariableByteArrayInput;
import org.exist.storage.io.VariableByteInput;
import org.exist.storage.io.VariableByteOutputStream;
import org.exist.storage.lock.Lock;
import org.exist.storage.txn.Txn;
import org.exist.util.ByteConversion;
import org.exist.util.Configuration;
import org.exist.util.FastQSort;
import org.exist.util.LockException;
import org.exist.util.ReadOnlyException;
import org.exist.util.UTF8;
import org.exist.util.ValueOccurrences;
import org.exist.util.XMLString;
import org.exist.xquery.TerminatedException;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.Type;
import org.w3c.dom.Node;

public class NativeValueIndex
implements ContentLoadingObserver {
    private static final Logger LOG = Logger.getLogger((Class)NativeValueIndex.class);
    public static final String FILE_NAME = "values.dbx";
    public static final String FILE_KEY_IN_CONFIG = "db-connection.values";
    public static final int WITH_PATH = 1;
    public static final int WITHOUT_PATH = 2;
    public static final double DEFAULT_VALUE_CACHE_GROWTH = 1.25;
    public static final double DEFAULT_VALUE_KEY_THRESHOLD = 0.01;
    public static final double DEFAULT_VALUE_VALUE_THRESHOLD = 0.04;
    public static final int LENGTH_VALUE_TYPE = 1;
    public static final int LENGTH_NODE_IDS = 4;
    public static final int OFFSET_COLLECTION_ID = 0;
    public static final int OFFSET_VALUE_TYPE = 0 + Collection.LENGTH_COLLECTION_ID;
    public static final int OFFSET_DATA = OFFSET_VALUE_TYPE + 1;
    public static final byte IDX_GENERIC = 0;
    public static final byte IDX_QNAME = 1;
    DBBroker broker;
    protected BFile dbValues;
    protected Configuration config;
    protected Map[] pending = new Map[2];
    private DocumentImpl doc;
    private VariableByteOutputStream os = new VariableByteOutputStream();
    protected boolean caseSensitive = true;
    public static final String INDEX_CASE_SENSITIVE_ATTRIBUTE = "caseSensitive";
    public static final String PROPERTY_INDEX_CASE_SENSITIVE = "indexer.case-sensitive";

    public NativeValueIndex(DBBroker broker, byte id, String dataDir, Configuration config) throws DBException {
        this.broker = broker;
        this.config = config;
        this.pending[0] = new TreeMap();
        this.pending[1] = new TreeMap();
        double cacheGrowth = 1.25;
        double cacheKeyThresdhold = 0.01;
        double cacheValueThresHold = 0.04;
        BFile nativeFile = (BFile)config.getProperty(this.getConfigKeyForFile());
        if (nativeFile == null) {
            File file = new File(dataDir + File.separatorChar + this.getFileName());
            LOG.debug((Object)("Creating '" + file.getName() + "'..."));
            nativeFile = new BFile(broker.getBrokerPool(), id, false, file, broker.getBrokerPool().getCacheManager(), cacheGrowth, cacheKeyThresdhold, cacheValueThresHold);
            config.setProperty(this.getConfigKeyForFile(), nativeFile);
        }
        this.dbValues = nativeFile;
        Boolean caseOpt = (Boolean)config.getProperty(PROPERTY_INDEX_CASE_SENSITIVE);
        if (caseOpt != null) {
            this.caseSensitive = caseOpt;
        }
        broker.addContentLoadingObserver(this.getInstance());
    }

    public String getFileName() {
        return FILE_NAME;
    }

    public String getConfigKeyForFile() {
        return FILE_KEY_IN_CONFIG;
    }

    public NativeValueIndex getInstance() {
        return this;
    }

    public void setDocument(DocumentImpl document) {
        this.doc = document;
    }

    public void storeElement(ElementImpl node, String content, int xpathType, byte indexType, boolean remove) {
        if (this.doc.getDocId() != node.getDocId()) {
            throw new IllegalArgumentException("Document id ('" + this.doc.getDocId() + "') and proxy id ('" + node.getDocId() + "') differ !");
        }
        AtomicValue atomic = this.convertToAtomic(xpathType, content);
        if (atomic == null) {
            return;
        }
        Comparable key = indexType == 1 ? new QNameKey(node.getQName(), atomic) : atomic;
        if (!remove) {
            ArrayList buf;
            if (this.pending[indexType].containsKey(key)) {
                buf = (ArrayList)this.pending[indexType].get(key);
            } else {
                buf = new ArrayList(8);
                this.pending[indexType].put(key, buf);
            }
            buf.add(node.getNodeId());
        } else if (!this.pending[indexType].containsKey(key)) {
            this.pending[indexType].put(key, null);
        }
    }

    public void storeAttribute(AttrImpl node, NodePath currentPath, int indexingHint, RangeIndexSpec spec, boolean remove) {
        if (indexingHint != 2) {
            return;
        }
        if (this.doc != null && this.doc.getDocId() != node.getDocId()) {
            throw new IllegalArgumentException("Document id ('" + this.doc.getDocId() + "') and proxy id ('" + node.getDocId() + "') differ !");
        }
        AtomicValue atomic = this.convertToAtomic(spec.getType(), node.getValue());
        if (atomic == null) {
            return;
        }
        int indexType = spec.getQName() == null ? 0 : 1;
        Comparable key = indexType == 1 ? new QNameKey(node.getQName(), atomic) : atomic;
        if (!remove) {
            ArrayList buf;
            if (this.pending[indexType].containsKey(key)) {
                buf = (ArrayList)this.pending[indexType].get(key);
            } else {
                buf = new ArrayList(8);
                this.pending[indexType].put(key, buf);
            }
            buf.add(node.getNodeId());
        } else if (!this.pending[indexType].containsKey(key)) {
            this.pending[indexType].put(key, null);
        }
    }

    public StoredNode getReindexRoot(StoredNode node, NodePath nodePath) {
        StoredNode currentNode;
        this.doc = node.getDocument();
        NodePath path = new NodePath(nodePath);
        StoredNode root = null;
        Node node2 = currentNode = node.getNodeType() == 1 || node.getNodeType() == 2 ? node : node.getParentNode();
        while (currentNode != null) {
            GeneralRangeIndexSpec rSpec = this.doc.getCollection().getIndexByPathConfiguration(this.broker, path);
            QNameRangeIndexSpec qSpec = this.doc.getCollection().getIndexByQNameConfiguration(this.broker, currentNode.getQName());
            if (rSpec != null || qSpec != null) {
                root = currentNode;
            }
            if (this.doc.getCollection().isTempCollection() && currentNode.getNodeId().getTreeLevel() == 2) break;
            currentNode = (StoredNode)currentNode.getParentNode();
            path.removeLastComponent();
        }
        return root;
    }

    public void reindex(StoredNode node) {
        if (node == null) {
            return;
        }
        ValueIndexStreamListener listener = new ValueIndexStreamListener();
        IndexUtils.scanNode(null, node, listener);
    }

    public void storeText(TextImpl node, NodePath currentPath, int indexingHint) {
    }

    public void removeNode(StoredNode node, NodePath currentPath, String content) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync() {
        Lock lock = this.dbValues.getLock();
        try {
            lock.acquire(1);
            this.dbValues.flush();
        }
        catch (LockException e) {
            LOG.warn((Object)("Failed to acquire lock for '" + this.dbValues.getFile().getName() + "'"), (Throwable)e);
        }
        catch (DBException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            lock.release(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        int keyCount = this.pending[0].size() + this.pending[1].size();
        if (keyCount == 0) {
            return;
        }
        int collectionId = this.doc.getCollection().getId();
        Lock lock = this.dbValues.getLock();
        for (int section = 0; section <= 1; section = (int)((byte)(section + 1))) {
            Iterator i = this.pending[section].entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                Object key = entry.getKey();
                ArrayList gids = (ArrayList)entry.getValue();
                int gidsCount = gids.size();
                FastQSort.sort(gids, 0, gidsCount - 1);
                this.os.clear();
                this.os.writeInt(this.doc.getDocId());
                this.os.writeInt(gidsCount);
                int nodeIDsLength = this.os.position();
                this.os.writeFixedInt(0);
                NodeId previous = null;
                for (int j = 0; j < gidsCount; ++j) {
                    NodeId nodeId = (NodeId)gids.get(j);
                    try {
                        previous = nodeId.write(previous, this.os);
                        continue;
                    }
                    catch (IOException e) {
                        LOG.warn((Object)("IO error while writing range index: " + e.getMessage()), (Throwable)e);
                    }
                }
                this.os.writeFixedInt(nodeIDsLength, this.os.position() - nodeIDsLength - 4);
                try {
                    Value v;
                    lock.acquire(1);
                    if (section == 0) {
                        v = new SimpleValue(collectionId, (Indexable)key);
                    } else {
                        QNameKey qnk = (QNameKey)key;
                        v = new QNameValue(collectionId, qnk.qname, qnk.value, this.broker.getSymbols());
                    }
                    if (this.dbValues.append(v, this.os.data()) != -1L) continue;
                    LOG.error((Object)("Could not append index data for key '" + key + "'"));
                }
                catch (EXistException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
                catch (LockException e) {
                    LOG.warn((Object)("Failed to acquire lock for '" + this.dbValues.getFile().getName() + "'"), (Throwable)e);
                }
                catch (IOException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
                catch (ReadOnlyException e) {
                    LOG.warn((Object)e.getMessage(), (Throwable)e);
                    return;
                }
                finally {
                    lock.release(1);
                    this.os.clear();
                }
            }
            this.pending[section].clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove() {
        int keyCount = this.pending[0].size() + this.pending[1].size();
        if (keyCount == 0) {
            return;
        }
        int collectionId = this.doc.getCollection().getId();
        Lock lock = this.dbValues.getLock();
        for (int section = 0; section <= 1; section = (int)((byte)(section + 1))) {
            Iterator i = this.pending[section].entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                Object key = entry.getKey();
                ArrayList storedGIDList = (ArrayList)entry.getValue();
                ArrayList<NodeId> newGIDList = new ArrayList<NodeId>();
                this.os.clear();
                try {
                    Value searchKey;
                    lock.acquire(1);
                    if (section == 0) {
                        searchKey = new SimpleValue(collectionId, (Indexable)key);
                    } else {
                        QNameKey qnk = (QNameKey)key;
                        searchKey = new QNameValue(collectionId, qnk.qname, qnk.value, this.broker.getSymbols());
                    }
                    Value value = this.dbValues.get(searchKey);
                    if (value != null) {
                        VariableByteArrayInput is = new VariableByteArrayInput(value.getData());
                        while (is.available() > 0) {
                            int storedDocId = is.readInt();
                            int gidsCount = is.readInt();
                            int size = is.readFixedInt();
                            if (storedDocId != this.doc.getDocId()) {
                                this.os.writeInt(storedDocId);
                                this.os.writeInt(gidsCount);
                                this.os.writeFixedInt(size);
                                is.copyRaw(this.os, size);
                                continue;
                            }
                            NodeId previous = null;
                            for (int j = 0; j < gidsCount; ++j) {
                                NodeId nodeId;
                                previous = nodeId = this.broker.getBrokerPool().getNodeFactory().createFromStream(previous, is);
                                if (NativeValueIndex.containsNode(storedGIDList, nodeId)) continue;
                                newGIDList.add(nodeId);
                            }
                        }
                        if (newGIDList.size() > 0) {
                            int gidsCount = newGIDList.size();
                            FastQSort.sort(newGIDList, 0, gidsCount - 1);
                            this.os.writeInt(this.doc.getDocId());
                            this.os.writeInt(gidsCount);
                            int nodeIDsLength = this.os.position();
                            this.os.writeFixedInt(0);
                            NodeId previous = null;
                            for (int j = 0; j < gidsCount; ++j) {
                                NodeId nodeId = (NodeId)newGIDList.get(j);
                                try {
                                    previous = nodeId.write(previous, this.os);
                                    continue;
                                }
                                catch (IOException e) {
                                    LOG.warn((Object)("IO error while writing range index: " + e.getMessage()), (Throwable)e);
                                }
                            }
                            this.os.writeFixedInt(nodeIDsLength, this.os.position() - nodeIDsLength - 4);
                        }
                        if (this.dbValues.update(value.getAddress(), searchKey, this.os.data()) != -1L) continue;
                        LOG.error((Object)("Could not update index data for value '" + searchKey + "'"));
                        continue;
                    }
                    if (this.dbValues.put(searchKey, this.os.data()) != -1L) continue;
                    LOG.error((Object)("Could not put index data for value '" + searchKey + "'"));
                }
                catch (EXistException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
                catch (LockException e) {
                    LOG.warn((Object)("Failed to acquire lock for '" + this.dbValues.getFile().getName() + "'"), (Throwable)e);
                }
                catch (ReadOnlyException e) {
                    LOG.warn((Object)("Read-only error on '" + this.dbValues.getFile().getName() + "'"), (Throwable)e);
                }
                catch (IOException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
                finally {
                    lock.release(1);
                    this.os.clear();
                }
            }
            this.pending[section].clear();
        }
    }

    private static boolean containsNode(List list, NodeId nodeId) {
        for (int i = 0; i < list.size(); ++i) {
            if (!((NodeId)list.get(i)).equals(nodeId)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropIndex(Collection collection) {
        Lock lock = this.dbValues.getLock();
        try {
            lock.acquire(1);
            Value ref = new SimpleValue(collection.getId());
            this.dbValues.removeAll(null, new IndexQuery(7, ref));
            ref = new QNameValue(collection.getId());
            this.dbValues.removeAll(null, new IndexQuery(7, ref));
        }
        catch (LockException e) {
            LOG.warn((Object)("Failed to acquire lock for '" + this.dbValues.getFile().getName() + "'"), (Throwable)e);
        }
        catch (BTreeException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            lock.release(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropIndex(DocumentImpl document) throws ReadOnlyException {
        int collectionId = document.getCollection().getId();
        Lock lock = this.dbValues.getLock();
        try {
            lock.acquire(1);
            for (int section = 0; section <= 1; ++section) {
                Iterator i = this.pending[section].entrySet().iterator();
                while (i.hasNext()) {
                    Value v;
                    Map.Entry entry = i.next();
                    Object key = entry.getKey();
                    if (section == 0) {
                        v = new SimpleValue(collectionId, (Indexable)key);
                    } else {
                        QNameKey qnk = (QNameKey)key;
                        v = new QNameValue(collectionId, qnk.qname, qnk.value, this.broker.getSymbols());
                    }
                    Value value = this.dbValues.get(v);
                    if (value == null) continue;
                    VariableByteArrayInput is = new VariableByteArrayInput(value.getData());
                    boolean changed = false;
                    this.os.clear();
                    while (is.available() > 0) {
                        int storedDocId = is.readInt();
                        int gidsCount = is.readInt();
                        int size = is.readFixedInt();
                        if (storedDocId != document.getDocId()) {
                            this.os.writeInt(storedDocId);
                            this.os.writeInt(gidsCount);
                            this.os.writeFixedInt(size);
                            is.copyRaw(this.os, size);
                            continue;
                        }
                        is.skipBytes(size);
                        changed = true;
                    }
                    if (!changed) continue;
                    if (this.os.data().size() == 0) {
                        this.dbValues.remove(v);
                        continue;
                    }
                    if (this.dbValues.put(v, this.os.data()) != -1L) continue;
                    LOG.error((Object)("Could not put index data for key '" + v + "'"));
                }
                this.pending[section].clear();
            }
        }
        catch (LockException e) {
            LOG.warn((Object)("Failed to acquire lock for '" + this.dbValues.getFile().getName() + "'"), (Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (EXistException e) {
            LOG.warn((Object)("Exception while removing range index: " + e.getMessage()), (Throwable)e);
        }
        finally {
            this.os.clear();
            lock.release(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeSet find(int relation, DocumentSet docs, NodeSet contextSet, int axis, QName qname, Indexable value) throws TerminatedException {
        ExtArrayNodeSet result = new ExtArrayNodeSet();
        SearchCallback cb = new SearchCallback(docs, contextSet, result, axis == 0);
        Lock lock = this.dbValues.getLock();
        Iterator iter = docs.getCollectionIterator();
        while (iter.hasNext()) {
            try {
                Value prefixKey;
                Value searchKey;
                lock.acquire(0);
                int collectionId = ((Collection)iter.next()).getId();
                if (qname == null) {
                    searchKey = new SimpleValue(collectionId, value);
                    prefixKey = new SimplePrefixValue(collectionId, value.getType());
                } else {
                    searchKey = new QNameValue(collectionId, qname, value, this.broker.getSymbols());
                    prefixKey = new QNamePrefixValue(collectionId, qname, value.getType(), this.broker.getSymbols());
                }
                int idxOp = this.checkRelationOp(relation);
                IndexQuery query = new IndexQuery(idxOp, searchKey);
                if (idxOp == 1) {
                    this.dbValues.query(query, cb);
                    continue;
                }
                this.dbValues.query(query, prefixKey, cb);
            }
            catch (EXistException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (LockException e) {
                LOG.warn((Object)("Failed to acquire lock for '" + this.dbValues.getFile().getName() + "'"), (Throwable)e);
            }
            catch (IOException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (BTreeException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                lock.release(0);
            }
        }
        return result;
    }

    public NodeSet match(DocumentSet docs, NodeSet contextSet, int axis, String expr, QName qname, int type) throws TerminatedException, EXistException {
        return this.match(docs, contextSet, axis, expr, qname, type, 0, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeSet match(DocumentSet docs, NodeSet contextSet, int axis, String expr, QName qname, int type, int flags, boolean caseSensitiveQuery) throws TerminatedException, EXistException {
        StringValue startTerm = null;
        if (expr.startsWith("^") && caseSensitiveQuery == this.caseSensitive) {
            StringBuffer term = new StringBuffer();
            for (int j = 1; j < expr.length() && Character.isLetterOrDigit(expr.charAt(j)); ++j) {
                term.append(expr.charAt(j));
            }
            if (term.length() > 0) {
                startTerm = new StringValue(term.toString());
                LOG.debug((Object)("Match will begin index scan at '" + startTerm + "'"));
            }
        }
        RegexMatcher comparator = new RegexMatcher(expr, type, flags);
        ExtArrayNodeSet result = new ExtArrayNodeSet();
        RegexCallback cb = new RegexCallback(docs, contextSet, result, comparator, axis == 0);
        Lock lock = this.dbValues.getLock();
        Iterator iter = docs.getCollectionIterator();
        while (iter.hasNext()) {
            try {
                Value searchKey;
                lock.acquire(0);
                int collectionId = ((Collection)iter.next()).getId();
                if (qname == null) {
                    searchKey = startTerm != null ? new SimpleValue(collectionId, startTerm) : new SimplePrefixValue(collectionId, 22);
                } else if (startTerm != null) {
                    searchKey = new QNameValue(collectionId, qname, startTerm, this.broker.getSymbols());
                } else {
                    LOG.debug((Object)"Searching with QName prefix");
                    searchKey = new QNamePrefixValue(collectionId, qname, 22, this.broker.getSymbols());
                }
                IndexQuery query = new IndexQuery(7, searchKey);
                this.dbValues.query(query, cb);
            }
            catch (LockException e) {
                LOG.warn((Object)("Failed to acquire lock for '" + this.dbValues.getFile().getName() + "'"), (Throwable)e);
            }
            catch (IOException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (BTreeException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                lock.release(0);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValueOccurrences[] scanIndexKeys(DocumentSet docs, NodeSet contextSet, Indexable start) {
        int type = start.getType();
        boolean stringType = Type.subTypeOf(type, 22);
        IndexScanCallback cb = new IndexScanCallback(docs, contextSet, type, false);
        Lock lock = this.dbValues.getLock();
        Iterator i = docs.getCollectionIterator();
        while (i.hasNext()) {
            try {
                SimpleValue startKey;
                lock.acquire(0);
                Collection c = (Collection)i.next();
                int collectionId = c.getId();
                if (stringType) {
                    startKey = new SimpleValue(collectionId, start);
                    IndexQuery query = new IndexQuery(7, (Value)startKey);
                    this.dbValues.query(query, cb);
                    continue;
                }
                startKey = new SimpleValue(collectionId, start);
                SimplePrefixValue prefixKey = new SimplePrefixValue(collectionId, start.getType());
                IndexQuery query = new IndexQuery(-3, (Value)startKey);
                this.dbValues.query(query, prefixKey, cb);
            }
            catch (EXistException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (LockException e) {
                LOG.warn((Object)("Failed to acquire lock for '" + this.dbValues.getFile().getName() + "'"), (Throwable)e);
            }
            catch (IOException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (BTreeException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (TerminatedException e) {
                LOG.warn((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                lock.release(0);
            }
        }
        Map map = cb.map;
        ValueOccurrences[] result = new ValueOccurrences[map.size()];
        return map.values().toArray(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValueOccurrences[] scanIndexKeys(DocumentSet docs, NodeSet contextSet, QName[] qnames, Indexable start) {
        if (qnames == null) {
            qnames = this.getDefinedIndexes(docs);
        }
        int type = start.getType();
        boolean stringType = Type.subTypeOf(type, 22);
        IndexScanCallback cb = new IndexScanCallback(docs, contextSet, type, true);
        Lock lock = this.dbValues.getLock();
        for (int j = 0; j < qnames.length; ++j) {
            Iterator i = docs.getCollectionIterator();
            while (i.hasNext()) {
                try {
                    QNameValue startKey;
                    lock.acquire(0);
                    int collectionId = ((Collection)i.next()).getId();
                    if (stringType) {
                        startKey = new QNameValue(collectionId, qnames[j], start, this.broker.getSymbols());
                        IndexQuery query = new IndexQuery(7, (Value)startKey);
                        this.dbValues.query(query, cb);
                        continue;
                    }
                    startKey = new QNameValue(collectionId, qnames[j], start, this.broker.getSymbols());
                    QNamePrefixValue prefixKey = new QNamePrefixValue(collectionId, qnames[j], start.getType(), this.broker.getSymbols());
                    IndexQuery query = new IndexQuery(-3, (Value)startKey);
                    this.dbValues.query(query, prefixKey, cb);
                }
                catch (EXistException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
                catch (LockException e) {
                    LOG.warn((Object)("Failed to acquire lock for '" + this.dbValues.getFile().getName() + "'"), (Throwable)e);
                }
                catch (IOException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
                catch (BTreeException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
                catch (TerminatedException e) {
                    LOG.warn((Object)e.getMessage(), (Throwable)e);
                }
                finally {
                    lock.release(0);
                }
            }
        }
        Map map = cb.map;
        ValueOccurrences[] result = new ValueOccurrences[map.size()];
        return map.values().toArray(result);
    }

    protected QName[] getDefinedIndexes(DocumentSet docs) {
        ArrayList qnames = new ArrayList();
        Iterator i = docs.getCollectionIterator();
        while (i.hasNext()) {
            Collection collection = (Collection)i.next();
            IndexSpec idxConf = collection.getIndexConfiguration(this.broker);
            if (idxConf == null) continue;
            qnames.addAll(idxConf.getIndexedQNames());
        }
        QName[] result = new QName[qnames.size()];
        return qnames.toArray(result);
    }

    protected int checkRelationOp(int relation) {
        int indexOp;
        switch (relation) {
            case 0: {
                indexOp = 3;
                break;
            }
            case 3: {
                indexOp = -2;
                break;
            }
            case 1: {
                indexOp = 2;
                break;
            }
            case 2: {
                indexOp = -3;
                break;
            }
            case 5: {
                indexOp = -1;
                break;
            }
            default: {
                indexOp = 1;
            }
        }
        return indexOp;
    }

    private AtomicValue convertToAtomic(int xpathType, String value) {
        AtomicValue atomic;
        if (Type.subTypeOf(xpathType, 22)) {
            atomic = new StringValue(value);
        } else {
            try {
                atomic = new StringValue(value).convertTo(xpathType);
            }
            catch (XPathException e) {
                LOG.warn((Object)("Node value '" + value + "' cannot be converted to " + Type.getTypeName(xpathType)));
                return null;
            }
        }
        if (atomic == null) {
            LOG.warn((Object)("Node value '" + Type.getTypeName(xpathType) + "(" + value + ")'" + " cannot be used as index key. It is null."));
            return null;
        }
        if (!(atomic instanceof Indexable)) {
            LOG.warn((Object)("Node value '" + Type.getTypeName(xpathType) + "(" + value + ")'" + " cannot be used as index key. It does not implement " + Indexable.class.getName()));
            return null;
        }
        return atomic;
    }

    public void closeAndRemove() {
        this.config.setProperty(this.getConfigKeyForFile(), null);
        this.dbValues.closeAndRemove();
    }

    public boolean close() throws DBException {
        this.config.setProperty(this.getConfigKeyForFile(), null);
        return this.dbValues.close();
    }

    public void printStatistics() {
        this.dbValues.printStatistics();
    }

    public String toString() {
        return this.getClass().getName() + " at " + this.dbValues.getFile().getName() + " owned by " + this.broker.toString() + " (case sensitive = " + this.caseSensitive + ")";
    }

    private class ValueIndexStreamListener
    extends AbstractStreamListener {
        private Stack contentStack = null;

        public void startElement(Txn transaction, ElementImpl element, NodePath path) {
            GeneralRangeIndexSpec rSpec = NativeValueIndex.this.doc.getCollection().getIndexByPathConfiguration(NativeValueIndex.this.broker, path);
            QNameRangeIndexSpec qSpec = NativeValueIndex.this.doc.getCollection().getIndexByQNameConfiguration(NativeValueIndex.this.broker, element.getQName());
            if (rSpec != null || qSpec != null) {
                if (this.contentStack == null) {
                    this.contentStack = new Stack();
                }
                XMLString contentBuf = new XMLString();
                this.contentStack.push(contentBuf);
            }
            super.startElement(transaction, element, path);
        }

        public void attribute(Txn transaction, AttrImpl attrib, NodePath path) {
            GeneralRangeIndexSpec rSpec = NativeValueIndex.this.doc.getCollection().getIndexByPathConfiguration(NativeValueIndex.this.broker, path);
            QNameRangeIndexSpec qSpec = NativeValueIndex.this.doc.getCollection().getIndexByQNameConfiguration(NativeValueIndex.this.broker, attrib.getQName());
            if (rSpec != null) {
                NativeValueIndex.this.storeAttribute(attrib, path, 2, rSpec, false);
            }
            if (qSpec != null) {
                NativeValueIndex.this.storeAttribute(attrib, path, 2, qSpec, false);
            }
            super.attribute(transaction, attrib, path);
        }

        public void endElement(Txn transaction, ElementImpl element, NodePath path) {
            GeneralRangeIndexSpec rSpec = NativeValueIndex.this.doc.getCollection().getIndexByPathConfiguration(NativeValueIndex.this.broker, path);
            QNameRangeIndexSpec qSpec = NativeValueIndex.this.doc.getCollection().getIndexByQNameConfiguration(NativeValueIndex.this.broker, element.getQName());
            if (rSpec != null || qSpec != null) {
                XMLString content = (XMLString)this.contentStack.pop();
                if (rSpec != null) {
                    NativeValueIndex.this.storeElement(element, content.toString(), RangeIndexSpec.indexTypeToXPath(rSpec.getIndexType()), (byte)0, false);
                }
                if (qSpec != null) {
                    NativeValueIndex.this.storeElement(element, content.toString(), RangeIndexSpec.indexTypeToXPath(qSpec.getIndexType()), (byte)1, false);
                }
            }
            super.endElement(transaction, element, path);
        }

        public void characters(Txn transaction, TextImpl text, NodePath path) {
            if (this.contentStack != null && !this.contentStack.isEmpty()) {
                for (int i = 0; i < this.contentStack.size(); ++i) {
                    XMLString next = (XMLString)this.contentStack.get(i);
                    next.append(text.getXMLString());
                }
            }
            super.characters(transaction, text, path);
        }

        public IndexWorker getWorker() {
            return null;
        }
    }

    private static class QNamePrefixValue
    extends Value {
        public static int LENGTH_VALUE_TYPE = 1;

        public QNamePrefixValue(int collectionId, QName qname, int type, SymbolTable symbols) {
            this.len = QNameValue.OFFSET_VALUE + LENGTH_VALUE_TYPE;
            this.data = new byte[this.len];
            this.data[QNameValue.OFFSET_IDX_TYPE] = 1;
            ByteConversion.intToByte(collectionId, this.data, QNameValue.OFFSET_COLLECTION_ID);
            short namespaceId = symbols.getNSSymbol(qname.getNamespaceURI());
            short localNameId = symbols.getSymbol(qname.getLocalName());
            this.data[QNameValue.OFFSET_QNAME_TYPE] = qname.getNameType();
            ByteConversion.shortToByte(namespaceId, this.data, QNameValue.OFFSET_NS_URI);
            ByteConversion.shortToByte(localNameId, this.data, QNameValue.OFFSET_LOCAL_NAME);
            this.data[QNameValue.OFFSET_VALUE] = (byte)type;
            this.pos = QNameValue.OFFSET_IDX_TYPE;
        }
    }

    private static class QNameValue
    extends Value {
        public static int LENGTH_IDX_TYPE = 1;
        public static int LENGTH_QNAME_TYPE = 1;
        public static int OFFSET_IDX_TYPE = 0;
        public static int OFFSET_COLLECTION_ID = OFFSET_IDX_TYPE + LENGTH_IDX_TYPE;
        public static int OFFSET_QNAME_TYPE = OFFSET_COLLECTION_ID + Collection.LENGTH_COLLECTION_ID;
        public static int OFFSET_NS_URI = OFFSET_QNAME_TYPE + LENGTH_QNAME_TYPE;
        public static int OFFSET_LOCAL_NAME = OFFSET_NS_URI + SymbolTable.LENGTH_NS_URI;
        public static int OFFSET_VALUE = OFFSET_LOCAL_NAME + SymbolTable.LENGTH_LOCAL_NAME;

        public QNameValue(int collectionId) {
            this.len = LENGTH_IDX_TYPE + Collection.LENGTH_COLLECTION_ID;
            this.data = new byte[this.len];
            this.data[QNameValue.OFFSET_IDX_TYPE] = 1;
            ByteConversion.intToByte(collectionId, this.data, OFFSET_COLLECTION_ID);
            this.pos = OFFSET_IDX_TYPE;
        }

        public QNameValue(int collectionId, QName qname, Indexable atomic, SymbolTable symbols) throws EXistException {
            this.data = atomic.serializeValue(OFFSET_VALUE);
            this.len = this.data.length;
            this.pos = OFFSET_IDX_TYPE;
            short namespaceId = symbols.getNSSymbol(qname.getNamespaceURI());
            short localNameId = symbols.getSymbol(qname.getLocalName());
            this.data[QNameValue.OFFSET_IDX_TYPE] = 1;
            ByteConversion.intToByte(collectionId, this.data, OFFSET_COLLECTION_ID);
            this.data[QNameValue.OFFSET_QNAME_TYPE] = qname.getNameType();
            ByteConversion.shortToByte(namespaceId, this.data, OFFSET_NS_URI);
            ByteConversion.shortToByte(localNameId, this.data, OFFSET_LOCAL_NAME);
        }

        public static Indexable deserialize(byte[] data, int start, int len) throws EXistException {
            return ValueIndexFactory.deserialize(data, start + OFFSET_VALUE, len - OFFSET_VALUE);
        }
    }

    private static class SimplePrefixValue
    extends Value {
        public static int LENGTH_VALUE_TYPE = 1;

        public SimplePrefixValue(int collectionId, int type) {
            this.len = SimpleValue.LENGTH_IDX_TYPE + Collection.LENGTH_COLLECTION_ID + LENGTH_VALUE_TYPE;
            this.data = new byte[this.len];
            this.data[SimpleValue.OFFSET_IDX_TYPE] = 0;
            ByteConversion.intToByte(collectionId, this.data, SimpleValue.OFFSET_COLLECTION_ID);
            this.data[SimpleValue.OFFSET_VALUE] = (byte)type;
            this.pos = SimpleValue.OFFSET_IDX_TYPE;
        }
    }

    private static class SimpleValue
    extends Value {
        public static int OFFSET_IDX_TYPE = 0;
        public static int LENGTH_IDX_TYPE = 1;
        public static int OFFSET_COLLECTION_ID = OFFSET_IDX_TYPE + LENGTH_IDX_TYPE;
        public static int OFFSET_VALUE = OFFSET_COLLECTION_ID + Collection.LENGTH_COLLECTION_ID;

        public SimpleValue(int collectionId) {
            this.len = LENGTH_IDX_TYPE + Collection.LENGTH_COLLECTION_ID;
            this.data = new byte[this.len];
            this.data[SimpleValue.OFFSET_IDX_TYPE] = 0;
            ByteConversion.intToByte(collectionId, this.data, OFFSET_COLLECTION_ID);
            this.pos = OFFSET_IDX_TYPE;
        }

        public SimpleValue(int collectionId, Indexable atomic) throws EXistException {
            this.data = atomic.serializeValue(OFFSET_VALUE);
            this.len = this.data.length;
            this.pos = OFFSET_IDX_TYPE;
            this.data[SimpleValue.OFFSET_IDX_TYPE] = 0;
            ByteConversion.intToByte(collectionId, this.data, OFFSET_COLLECTION_ID);
        }

        public static Indexable deserialize(byte[] data, int start, int len) throws EXistException {
            return ValueIndexFactory.deserialize(data, start + OFFSET_VALUE, len - OFFSET_VALUE);
        }
    }

    private static class QNameKey
    implements Comparable {
        private QName qname;
        private AtomicValue value;

        public QNameKey(QName qname, AtomicValue atomic) {
            this.qname = qname;
            this.value = atomic;
        }

        public int compareTo(Object o) {
            QNameKey other = (QNameKey)o;
            int cmp = this.qname.compareTo(other.qname);
            if (cmp == 0) {
                return this.value.compareTo(other.value);
            }
            return cmp;
        }
    }

    private final class IndexScanCallback
    implements BTreeCallback {
        private DocumentSet docs;
        private NodeSet contextSet;
        private Map map = new TreeMap();
        private int type;
        private boolean byQName;

        IndexScanCallback(DocumentSet docs, NodeSet contextSet, int type, boolean byQName) {
            this.docs = docs;
            this.contextSet = contextSet;
            this.type = type;
            this.byQName = byQName;
        }

        public boolean indexInfo(Value key, long pointer) throws TerminatedException {
            VariableByteInput is;
            AtomicValue atomic;
            try {
                atomic = this.byQName ? (AtomicValue)QNameValue.deserialize(key.data(), key.start(), key.getLength()) : (AtomicValue)SimpleValue.deserialize(key.data(), key.start(), key.getLength());
                if (atomic.getType() != this.type) {
                    return false;
                }
            }
            catch (EXistException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                return true;
            }
            try {
                is = NativeValueIndex.this.dbValues.getAsStream(pointer);
            }
            catch (IOException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                return true;
            }
            ValueOccurrences oc = (ValueOccurrences)this.map.get(atomic);
            try {
                while (is.available() > 0) {
                    boolean docAdded = false;
                    int storedDocId = is.readInt();
                    int gidsCount = is.readInt();
                    int size = is.readFixedInt();
                    DocumentImpl storedDocument = this.docs.getDoc(storedDocId);
                    if (storedDocument == null) {
                        is.skipBytes(size);
                        continue;
                    }
                    NodeId lastParentId = null;
                    NodeId previous = null;
                    for (int j = 0; j < gidsCount; ++j) {
                        NodeId nodeId;
                        previous = nodeId = NativeValueIndex.this.broker.getBrokerPool().getNodeFactory().createFromStream(previous, is);
                        NodeProxy parentNode = this.contextSet != null ? this.contextSet.parentWithChild(storedDocument, nodeId, false, true) : new NodeProxy(storedDocument, nodeId);
                        if (parentNode == null) continue;
                        if (oc == null) {
                            oc = new ValueOccurrences(atomic);
                            this.map.put(atomic, oc);
                        }
                        if (lastParentId == null || !lastParentId.equals(parentNode.getNodeId())) {
                            oc.addOccurrences(1);
                        }
                        if (!docAdded) {
                            oc.addDocument(storedDocument);
                            docAdded = true;
                        }
                        lastParentId = parentNode.getNodeId();
                    }
                }
            }
            catch (IOException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            return true;
        }
    }

    private class RegexCallback
    extends SearchCallback {
        private TermMatcher matcher;
        private XMLString key;

        public RegexCallback(DocumentSet docs, NodeSet contextSet, NodeSet result, TermMatcher matcher, boolean returnAncestor) {
            super(docs, contextSet, result, returnAncestor);
            this.key = new XMLString(128);
            this.matcher = matcher;
        }

        public boolean indexInfo(Value value, long pointer) throws TerminatedException {
            int offset = value.data()[value.start()] == 0 ? SimpleValue.OFFSET_VALUE + 1 : QNameValue.OFFSET_VALUE + 1;
            this.key.reuse();
            UTF8.decode(value.data(), value.start() + offset, value.getLength() - offset, this.key);
            if (this.matcher.matches(this.key)) {
                super.indexInfo(value, pointer);
            }
            return true;
        }
    }

    class SearchCallback
    implements BTreeCallback {
        DocumentSet docs;
        NodeSet contextSet;
        NodeSet result;
        boolean returnAncestor;

        public SearchCallback(DocumentSet docs, NodeSet contextSet, NodeSet result, boolean returnAncestor) {
            this.docs = docs;
            this.contextSet = contextSet;
            this.result = result;
            this.returnAncestor = returnAncestor;
        }

        public boolean indexInfo(Value value, long pointer) throws TerminatedException {
            VariableByteInput is;
            try {
                is = NativeValueIndex.this.dbValues.getAsStream(pointer);
            }
            catch (IOException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                return true;
            }
            try {
                while (is.available() > 0) {
                    int storedDocId = is.readInt();
                    int gidsCount = is.readInt();
                    int size = is.readFixedInt();
                    DocumentImpl storedDocument = this.docs.getDoc(storedDocId);
                    if (storedDocument == null) {
                        is.skipBytes(size);
                        continue;
                    }
                    NodeId previous = null;
                    for (int j = 0; j < gidsCount; ++j) {
                        NodeId nodeId;
                        previous = nodeId = NativeValueIndex.this.broker.getBrokerPool().getNodeFactory().createFromStream(previous, is);
                        NodeProxy storedNode = new NodeProxy(storedDocument, nodeId);
                        if (this.contextSet != null) {
                            int sizeHint = this.contextSet.getSizeHint(storedDocument);
                            if (this.returnAncestor) {
                                NodeProxy parentNode = this.contextSet.parentWithChild(storedNode, false, true, -1);
                                if (parentNode == null) continue;
                                this.result.add(parentNode, sizeHint);
                                continue;
                            }
                            this.result.add(storedNode, sizeHint);
                            continue;
                        }
                        this.result.add(storedNode, -1);
                    }
                }
            }
            catch (IOException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            return false;
        }
    }
}

