/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textIndexer;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.tree.TreeBuilder;
import org.apache.lucene.util.StringUtil;
import org.cdlib.xtf.cache.Dependency;
import org.cdlib.xtf.cache.FileDependency;
import org.cdlib.xtf.servletBase.StylesheetCache;
import org.cdlib.xtf.textEngine.IndexUtil;
import org.cdlib.xtf.textIndexer.DocSelCache;
import org.cdlib.xtf.textIndexer.HTMLIndexSource;
import org.cdlib.xtf.textIndexer.IndexerConfig;
import org.cdlib.xtf.textIndexer.MARCIndexSource;
import org.cdlib.xtf.textIndexer.MSWordIndexSource;
import org.cdlib.xtf.textIndexer.PDFIndexSource;
import org.cdlib.xtf.textIndexer.StructuredFileProxy;
import org.cdlib.xtf.textIndexer.TextIndexSource;
import org.cdlib.xtf.textIndexer.XMLIndexSource;
import org.cdlib.xtf.textIndexer.XMLTextProcessor;
import org.cdlib.xtf.util.EasyNode;
import org.cdlib.xtf.util.Path;
import org.cdlib.xtf.util.SubDirFilter;
import org.cdlib.xtf.util.Trace;
import org.cdlib.xtf.util.XMLWriter;
import org.xml.sax.InputSource;

public class SrcTreeProcessor {
    private IndexerConfig cfgInfo;
    private XMLTextProcessor textProcessor;
    private StylesheetCache stylesheetCache = new StylesheetCache(100, 0, true);
    private Templates docSelector;
    private int nScanned = 0;
    private StringBuffer docBuf = new StringBuffer(1024);
    private StringBuffer dirBuf = new StringBuffer(1024);
    private String docSelPath;
    private File docSelCacheFile;
    private DocSelCache docSelCache = new DocSelCache();

    public SrcTreeProcessor() {
        this.textProcessor = new XMLTextProcessor();
    }

    public void open(IndexerConfig cfgInfo) throws Exception {
        this.cfgInfo = cfgInfo;
        if (cfgInfo.xtfHomePath == null) {
            cfgInfo.xtfHomePath = new File(cfgInfo.cfgFilePath).getParentFile().toString();
        }
        this.docSelPath = Path.resolveRelOrAbs(cfgInfo.xtfHomePath, cfgInfo.indexInfo.docSelectorPath);
        this.docSelector = this.stylesheetCache.find(this.docSelPath);
        this.loadCache(cfgInfo);
        this.textProcessor.open(cfgInfo.xtfHomePath, cfgInfo.indexInfo, cfgInfo.clean, cfgInfo.force);
        cfgInfo.clean = false;
    }

    public void close() throws IOException {
        this.textProcessor.processQueuedTexts();
        this.saveCache();
        this.cfgInfo = null;
        this.textProcessor.close();
    }

    String calcIndexPath() {
        String indexPath = Path.resolveRelOrAbs(this.cfgInfo.xtfHomePath, this.cfgInfo.indexInfo.indexPath);
        return Path.normalizePath(indexPath);
    }

    public void loadCache(IndexerConfig cfgInfo) {
        this.docSelCache.clear();
        this.docSelCacheFile = new File(String.valueOf(this.calcIndexPath()) + "docSelect.cache");
        Iterator iter = this.stylesheetCache.getDependencies(this.docSelPath);
        StringBuffer depBuf = new StringBuffer();
        while (iter.hasNext()) {
            Dependency d = (Dependency)iter.next();
            if (!(d instanceof FileDependency)) continue;
            depBuf.append(d.toString());
            depBuf.append("\n");
        }
        this.docSelCache.dependencies = depBuf.toString();
        if (cfgInfo.clean) {
            this.docSelCacheFile.delete();
            return;
        }
        if (!this.docSelCacheFile.canRead()) {
            return;
        }
        String thisDep = this.docSelCache.dependencies;
        try {
            this.docSelCache.load(this.docSelCacheFile);
        }
        catch (IOException e) {
            Trace.warning("Warning: Error loading docSelector cache \"" + this.docSelCacheFile + "\": " + e);
            this.docSelCache.clear();
            return;
        }
        if (!this.docSelCache.dependencies.equals(thisDep)) {
            Trace.debug("Note: docSelector stylesheet or sub-sheet  has changed... throwing away old docSelector cache.");
            this.docSelCacheFile.delete();
            this.docSelCache.clear();
            this.docSelCache.dependencies = thisDep;
            return;
        }
    }

    public void saveCache() {
        try {
            this.docSelCache.save(this.docSelCacheFile);
        }
        catch (IOException e) {
            Trace.warning("Warning: Error writing docSelector cache \"" + this.docSelCacheFile + "\": " + e);
        }
    }

    public void processDir(File curDir, SubDirFilter subDirFilter, boolean topLevel) throws Exception {
        boolean runStylesheet;
        if (subDirFilter != null && !subDirFilter.approve(curDir)) {
            return;
        }
        String[] fileStrs = curDir.getAbsoluteFile().list();
        if (fileStrs == null) {
            Trace.warning("Warning: error retrieving file list for directory: " + curDir);
            return;
        }
        ArrayList<String> list = new ArrayList<String>(fileStrs.length);
        int i = 0;
        while (i < fileStrs.length) {
            list.add(fileStrs[i]);
            ++i;
        }
        Collections.sort(list);
        this.docBuf.setLength(0);
        this.dirBuf.setLength(0);
        String dirPath = Path.normalizePath(curDir.toString());
        this.docBuf.append("<directory dirPath=\"" + StringUtil.escapeHTMLChars(dirPath) + "\">\n");
        int nFiles = 0;
        Iterator i2 = list.iterator();
        while (i2.hasNext()) {
            File subFile = new File(curDir, (String)i2.next());
            if (subFile.getAbsoluteFile().isDirectory()) continue;
            this.docBuf.append("  <file fileName=\"");
            this.docBuf.append(StringUtil.escapeHTMLChars(subFile.getName()));
            this.docBuf.append("\"/>\n");
            this.dirBuf.append(StringUtil.escapeHTMLChars(subFile.getName()));
            this.dirBuf.append(':');
            this.dirBuf.append(subFile.lastModified());
            this.dirBuf.append("\n");
            ++nFiles;
            if (this.nScanned++ % 200 != 0) continue;
            Trace.more(4, ".");
        }
        this.docBuf.append("</directory>\n");
        boolean anyProcessed = false;
        String inStr = this.docBuf.toString();
        String filesAndTimes = this.dirBuf.toString();
        String dirKey = topLevel ? String.valueOf(this.cfgInfo.indexInfo.indexName) + ":/" : IndexUtil.calcDocKey(new File(this.cfgInfo.xtfHomePath), this.cfgInfo.indexInfo, curDir);
        if (nFiles == 0) {
            runStylesheet = false;
        } else {
            DocSelCache.Entry ent = this.docSelCache.get(dirKey);
            if (ent == null) {
                runStylesheet = true;
            } else if (this.cfgInfo.force || !ent.filesAndTimes.equals(filesAndTimes)) {
                this.docSelCache.remove(dirKey);
                runStylesheet = true;
            } else {
                anyProcessed = ent.anyProcessed;
                runStylesheet = false;
            }
        }
        if (runStylesheet) {
            InputSource docSelectorInput = new InputSource(new StringReader(inStr));
            if (Trace.getOutputLevel() >= 8) {
                Trace.debug("*** docSelector input ***\n" + inStr);
                Trace.debug("");
            }
            TreeBuilder tree = new TreeBuilder();
            Transformer docSelectorTrans = this.docSelector.newTransformer();
            docSelectorTrans.transform(new SAXSource(docSelectorInput), tree);
            NodeInfo result = tree.getCurrentRoot();
            if (Trace.getOutputLevel() >= 8) {
                Trace.debug("*** docSelector output ***\n" + XMLWriter.toString(result));
                Trace.debug("");
            }
            EasyNode root = new EasyNode(result);
            int i3 = 0;
            while (i3 < root.nChildren()) {
                EasyNode node = root.child(i3);
                if (node.isElement()) {
                    String tagName = node.name();
                    if (tagName.equalsIgnoreCase("indexFiles")) {
                        root = node;
                        i3 = -1;
                    } else if (tagName.equalsIgnoreCase("indexFile")) {
                        if (this.processFile(dirPath, node)) {
                            anyProcessed = true;
                        }
                    } else {
                        Trace.error("Error: docSelector returned unknown element '" + tagName + "'");
                        return;
                    }
                }
                ++i3;
            }
            this.docSelCache.put(dirKey, new DocSelCache.Entry(filesAndTimes, anyProcessed));
        }
        if (anyProcessed && !this.cfgInfo.indexInfo.scanAllDirs) {
            return;
        }
        Iterator i4 = list.iterator();
        while (i4.hasNext()) {
            File subFile = new File(curDir, (String)i4.next());
            if (!subFile.getAbsoluteFile().isDirectory()) continue;
            this.processDir(subFile, subDirFilter, false);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public boolean processFile(String dir, EasyNode parentEl) throws Exception {
        srcPath = null;
        preFilterVec = new Vector<Templates>();
        displayStyle = null;
        fileName = null;
        format = null;
        removeDoctypeDecl = false;
        i = 0;
        while (i < parentEl.nAttrs()) {
            block37: {
                block40: {
                    block46: {
                        block45: {
                            block44: {
                                block43: {
                                    block42: {
                                        block41: {
                                            block39: {
                                                block38: {
                                                    block36: {
                                                        attrName = parentEl.attrName(i);
                                                        attrVal = parentEl.attrValue(i);
                                                        if (!attrName.equalsIgnoreCase("fileName")) break block36;
                                                        fileName = attrVal;
                                                        srcPath = new File(Path.normalizeFileName(String.valueOf(dir) + attrVal));
                                                        if (!srcPath.canRead()) {
                                                            Trace.error("Error: cannot read input document '" + srcPath + "'");
                                                            return false;
                                                        }
                                                        break block37;
                                                    }
                                                    if (!attrName.equalsIgnoreCase("preFilter")) break block38;
                                                    st = new StringTokenizer(attrVal, ";,");
                                                    while (st.hasMoreTokens()) {
                                                        partialPath = st.nextToken();
                                                        preFilterPath = Path.resolveRelOrAbs(this.cfgInfo.xtfHomePath, partialPath);
                                                        preFilterVec.add(this.stylesheetCache.find(preFilterPath));
                                                    }
                                                    break block37;
                                                }
                                                if (!attrName.equalsIgnoreCase("displayStyle")) break block39;
                                                displayPath = Path.resolveRelOrAbs(this.cfgInfo.xtfHomePath, attrVal);
                                                displayStyle = this.stylesheetCache.find(displayPath);
                                                break block37;
                                            }
                                            if (!attrName.equalsIgnoreCase("type")) break block40;
                                            format = attrVal;
                                            if (!format.equalsIgnoreCase("XML")) break block41;
                                            format = "XML";
                                            break block37;
                                        }
                                        if (!format.equalsIgnoreCase("PDF")) break block42;
                                        format = "PDF";
                                        break block37;
                                    }
                                    if (!format.equalsIgnoreCase("HTML")) break block43;
                                    format = "HTML";
                                    break block37;
                                }
                                if (!format.equalsIgnoreCase("DOC") && !format.equalsIgnoreCase("MSWord")) break block44;
                                format = "MSWord";
                                break block37;
                            }
                            if (!format.equalsIgnoreCase("Text")) break block45;
                            format = "Text";
                            break block37;
                        }
                        if (!format.equalsIgnoreCase("MARC")) break block46;
                        format = "MARC";
                        break block37;
                    }
                    Trace.error("Error: docSelector returned unknown type: '" + format + "'");
                    return false;
                }
                if (!attrName.equalsIgnoreCase("removeDoctypeDecl")) ** GOTO lbl72
                if (attrVal.matches("^yes$|^true$")) {
                    removeDoctypeDecl = true;
                } else if (attrVal.matches("^no$|^false$")) {
                    removeDoctypeDecl = false;
                } else {
                    Trace.error("Error: docSelector returned invalid value for " + attrName + " attribute: " + "expected 'true', 'yes', 'false', or 'no', but found '" + attrVal + "'");
                    return false;
lbl72:
                    // 1 sources

                    Trace.error("Error: docSelector returned unknown attribute: '" + attrName + "'");
                    return false;
                }
            }
            ++i;
        }
        if (srcPath == null) {
            Trace.error("Error: docSelector must return 'fileName' attribute");
            return false;
        }
        if (format == null && fileName != null) {
            lcFileName = fileName.toLowerCase();
            if (lcFileName.endsWith(".xml")) {
                format = "XML";
            } else if (lcFileName.endsWith(".pdf")) {
                format = "PDF";
            } else if (lcFileName.endsWith(".htm") || lcFileName.endsWith(".html")) {
                format = "HTML";
            } else if (lcFileName.endsWith(".doc")) {
                format = "MSWord";
            } else if (lcFileName.endsWith(".txt")) {
                format = "Text";
            } else if (lcFileName.endsWith(".marc") || lcFileName.endsWith(".mrc")) {
                format = "MARC";
            } else {
                Trace.warning("Warning: cannot deduce file type from extension on file '" + srcPath);
                return false;
            }
        }
        key = IndexUtil.calcDocKey(new File(this.cfgInfo.xtfHomePath), this.cfgInfo.indexInfo, srcPath);
        systemId = srcPath.toURL().toString();
        lazyStore = null;
        if (this.cfgInfo.buildLazyFiles) {
            lazyFile = IndexUtil.calcLazyPath(new File(this.cfgInfo.xtfHomePath), this.cfgInfo.indexInfo, srcPath, false);
            lazyStore = new StructuredFileProxy(lazyFile);
        }
        preFilters = null;
        if (!preFilterVec.isEmpty()) {
            preFilters = preFilterVec.toArray(new Templates[preFilterVec.size()]);
        }
        srcFile /* !! */  = null;
        if (format.equalsIgnoreCase("XML")) {
            finalSrc = new InputSource(systemId);
            srcFile /* !! */  = new XMLIndexSource(finalSrc, srcPath, key, preFilters, displayStyle, lazyStore);
            if (removeDoctypeDecl) {
                ((XMLIndexSource)srcFile /* !! */ ).removeDoctypeDecl(true);
            }
        } else if (format.equalsIgnoreCase("PDF")) {
            srcFile /* !! */  = new PDFIndexSource(srcPath, key, preFilters, displayStyle, null);
        } else if (format.equalsIgnoreCase("HTML")) {
            srcFile /* !! */  = new HTMLIndexSource(srcPath, key, preFilters, displayStyle, null);
        } else if (format.equalsIgnoreCase("MSWord")) {
            srcFile /* !! */  = new MSWordIndexSource(srcPath, key, preFilters, displayStyle, null);
        } else if (format.equalsIgnoreCase("Text")) {
            srcFile /* !! */  = new TextIndexSource(srcPath, key, preFilters, displayStyle, null);
        } else if (format.equalsIgnoreCase("MARC")) {
            srcFile /* !! */  = new MARCIndexSource(srcPath, key, preFilters, displayStyle);
        } else {
            throw new RuntimeException("Internal error: code missing support for type");
        }
        this.textProcessor.checkAndQueueText(srcFile /* !! */ );
        return true;
    }
}

