/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textEngine;

import java.util.Stack;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.spans.SpanOrQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.cdlib.xtf.textEngine.XtfQueryRewriter;

public class UnspanningQueryRewriter
extends XtfQueryRewriter {
    private Stack parentStack = new Stack();

    public Query rewriteQuery(Query q) {
        try {
            this.parentStack.push(q);
            Query query = super.rewriteQuery(q);
            return query;
        }
        finally {
            this.parentStack.pop();
        }
    }

    private boolean suppressRewrite() {
        int i = 0;
        while (i < this.parentStack.size() - 1) {
            if (this.parentStack.get(i) instanceof SpanQuery) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected Query rewrite(SpanTermQuery q) {
        if (this.suppressRewrite()) {
            return q;
        }
        return new TermQuery(q.getTerm());
    }

    protected Query rewrite(SpanOrQuery oq) {
        if (this.suppressRewrite()) {
            return oq;
        }
        BooleanQuery newQuery = new BooleanQuery();
        SpanQuery[] clauses = oq.getClauses();
        int i = 0;
        while (i < clauses.length) {
            newQuery.add(this.rewriteQuery(clauses[i]), BooleanClause.Occur.SHOULD);
            ++i;
        }
        return this.copyBoost(oq, newQuery);
    }
}

