/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textEngine;

import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.spans.SpanRangeQuery;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.apache.lucene.search.spans.SpanWildcardQuery;
import org.cdlib.xtf.textEngine.NumericRangeQuery;
import org.cdlib.xtf.textEngine.XtfQueryRewriter;
import org.cdlib.xtf.textEngine.XtfSpanRangeQuery;
import org.cdlib.xtf.textEngine.XtfSpanWildcardQuery;

public class RefieldingQueryRewriter
extends XtfQueryRewriter {
    private String newField;

    public synchronized Query refield(Query q, String field) {
        this.newField = field;
        return this.rewriteQuery(q);
    }

    private Term rewriteTerm(Term t) {
        if (t == null) {
            return t;
        }
        return new Term(this.newField, t.text());
    }

    protected Query rewrite(TermQuery q) {
        return new TermQuery(this.rewriteTerm(q.getTerm()));
    }

    protected Query rewrite(SpanTermQuery q) {
        return new SpanTermQuery(this.rewriteTerm(q.getTerm()));
    }

    protected Query rewrite(SpanWildcardQuery q) {
        assert (q instanceof XtfSpanWildcardQuery);
        return new XtfSpanWildcardQuery(this.rewriteTerm(q.getTerm()), q.getTermLimit());
    }

    protected Query rewrite(SpanRangeQuery q) {
        assert (q instanceof XtfSpanRangeQuery);
        return new XtfSpanRangeQuery(this.rewriteTerm(q.getLowerTerm()), this.rewriteTerm(q.getUpperTerm()), q.isInclusive(), q.getTermLimit());
    }

    protected Query rewrite(NumericRangeQuery nrq) {
        return new NumericRangeQuery(this.newField, nrq.getLowerVal(), nrq.getUpperVal(), nrq.includesLower(), nrq.includesUpper());
    }
}

