/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.saxonExt.image;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.style.ExtensionInstruction;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import org.cdlib.xtf.saxonExt.InstructionWithContent;
import org.cdlib.xtf.saxonExt.image.ImageCache;
import org.cdlib.xtf.servletBase.TextServlet;

public class OutputElement
extends ExtensionInstruction {
    HashMap<String, Expression> attribs = new HashMap();
    boolean flipY = false;
    private static final int outColorBase = 32;
    private static final ImageCache imageCache = new ImageCache(32);

    public void prepareAttributes() throws XPathException {
        AttributeCollection inAtts = this.getAttributeList();
        int i = 0;
        while (i < inAtts.getLength()) {
            String attName = inAtts.getLocalName(i);
            String attVal = inAtts.getValue(i);
            if (attName.matches("^(src|xBias|xScale|yBias|yScale)$")) {
                this.attribs.put(attName, this.makeAttributeValueTemplate(attVal));
            } else if (attName.equals("flipY")) {
                if (attVal.matches("^(1|true|yes)$")) {
                    this.flipY = true;
                } else if (attVal.matches("^(0|false|no)$")) {
                    this.flipY = false;
                } else {
                    this.compileError("'flipy' attribute must be 'yes' or 'no'");
                }
            } else {
                this.compileError("Unrecogized attribute '" + attName + "'for image:output element");
            }
            ++i;
        }
    }

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    public Expression compile(Executable exec) throws XPathException {
        Expression content = this.compileSequenceConstructor(exec, this.iterateAxis((byte)3), true);
        return new OutputInstruction(this.attribs, this.flipY, content);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OutputInstruction
    extends InstructionWithContent {
        private boolean flipY;
        private float xBias;
        private float xScale;
        private float yBias;
        private float yScale;
        private int origHeight;
        private int cropOffX;
        private int cropOffY;

        public OutputInstruction(HashMap<String, Expression> attribs, boolean flipY, Expression content) {
            super("image:output", attribs, content);
            this.flipY = flipY;
        }

        @Override
        public TailCall processLeavingTail(XPathContext context) throws XPathException {
            this.cropOffY = 0;
            this.cropOffX = 0;
            try {
                BufferedImage bi;
                System.setProperty("java.awt.headless", "true");
                this.xBias = this.getFloatAttrib(context, "xBias", 0.0f);
                this.xScale = this.getFloatAttrib(context, "xScale", 1.0f);
                this.yBias = this.getFloatAttrib(context, "yBias", 0.0f);
                this.yScale = this.getFloatAttrib(context, "yScale", 1.0f);
                String src = ((Expression)this.attribs.get("src")).evaluateAsString(context);
                String srcPath = TextServlet.getCurServlet().getRealPath(src);
                try {
                    bi = (BufferedImage)imageCache.find(srcPath);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                bi = new BufferedImage(bi.getColorModel(), (WritableRaster)bi.getData(), false, null);
                this.origHeight = bi.getHeight();
                if (this.content != null) {
                    Item item;
                    SequenceIterator iter = this.content.iterate(context);
                    while ((item = iter.next()) != null) {
                        NodeInfo node;
                        Rect rect;
                        if (!(item instanceof NodeInfo) || ((NodeInfo)item).getNodeKind() != 1 || !((NodeInfo)item).getLocalPart().matches("^(yellowBackground|redForeground|crop)$")) {
                            this.dynamicError("image:output element may only contain 'yellowBackground', 'redForeground', or 'crop' sub-elements", "XTFimgH", context);
                        }
                        if ((rect = this.parseRect(context, node = (NodeInfo)item, bi.getWidth(), bi.getHeight())).isEmpty()) continue;
                        if (node.getLocalPart().equals("yellowBackground")) {
                            this.makeBackgroundYellow(bi, rect);
                            continue;
                        }
                        if (node.getLocalPart().equals("redForeground")) {
                            this.makeForegroundRed(bi, rect);
                            continue;
                        }
                        bi = bi.getSubimage(rect.left, rect.top, rect.width(), rect.height());
                        this.cropOffX += rect.left;
                        this.cropOffY += rect.top;
                    }
                }
                HttpServletResponse res = TextServlet.getCurResponse();
                res.setContentType("image/png");
                ServletOutputStream out = res.getOutputStream();
                ImageIO.write((RenderedImage)bi, "PNG", (OutputStream)out);
            }
            catch (IOException e) {
                throw new DynamicError(e);
            }
            return null;
        }

        private float getFloatAttrib(XPathContext context, String attName, float defaultVal) throws XPathException {
            String strVal = ((Expression)this.attribs.get(attName)).evaluateAsString(context);
            if (strVal == null) {
                return defaultVal;
            }
            try {
                return Float.parseFloat(strVal);
            }
            catch (NumberFormatException e) {
                return defaultVal;
            }
        }

        private Rect parseRect(XPathContext context, NodeInfo node, int imgWidth, int imgHeight) throws DynamicError {
            Item att;
            AxisIterator atts = node.iterateAxis((byte)2);
            int left = 0;
            int top = 0;
            int right = 0;
            int bottom = 0;
            boolean leftFound = false;
            boolean rightFound = false;
            boolean topFound = false;
            boolean bottomFound = false;
            while ((att = atts.next()) != null) {
                String name = ((NodeInfo)att).getLocalPart();
                String value = ((NodeInfo)att).getStringValue();
                if ("left".equals(name)) {
                    left = Integer.parseInt(value);
                    leftFound = true;
                    continue;
                }
                if ("top".equals(name)) {
                    top = Integer.parseInt(value);
                    topFound = true;
                    continue;
                }
                if ("right".equals(name)) {
                    right = Integer.parseInt(value);
                    rightFound = true;
                    continue;
                }
                if ("bottom".equals(name)) {
                    bottom = Integer.parseInt(value);
                    bottomFound = true;
                    continue;
                }
                this.dynamicError("Unknown attribute '" + name + "' to '" + node.getLocalPart() + "' element", "XTFimgHAU", context);
            }
            if (!(leftFound && rightFound && topFound && bottomFound)) {
                this.dynamicError("'" + node.getLocalPart() + "' element must specify 'left', 'top', 'right', and 'bottom' attributes", "XTFimgHAltrb", context);
            }
            left = (int)(((float)left + this.xBias) * this.xScale);
            top = (int)(((float)top + this.yBias) * this.yScale);
            right = (int)(((float)right + this.xBias) * this.xScale);
            bottom = (int)(((float)bottom + this.yBias) * this.yScale);
            if (this.flipY) {
                top = this.origHeight - top;
                bottom = this.origHeight - bottom;
            }
            left -= this.cropOffX;
            top -= this.cropOffY;
            right -= this.cropOffX;
            bottom -= this.cropOffY;
            left = Math.max(Math.min(left, imgWidth), 0);
            top = Math.max(Math.min(top, imgHeight), 0);
            right = Math.max(Math.min(right, imgWidth), 0);
            bottom = Math.max(Math.min(bottom, imgHeight), 0);
            if (left > right) {
                int tmp = left;
                left = right;
                right = tmp;
            }
            if (top > bottom) {
                int tmp = top;
                top = bottom;
                bottom = tmp;
            }
            return new Rect(left, top, right, bottom);
        }

        private void makeBackgroundYellow(BufferedImage bi, Rect rect) {
            int w = rect.width();
            int h = rect.height();
            byte[] data = new byte[w * h];
            bi.getRaster().getDataElements(rect.left, rect.top, rect.width(), rect.height(), data);
            int i = 0;
            while (i < w * h) {
                int n = i++;
                data[n] = (byte)(data[n] | 0x20);
            }
            bi.getRaster().setDataElements(rect.left, rect.top, rect.width(), rect.height(), data);
        }

        private void makeForegroundRed(BufferedImage bi, Rect rect) {
            int w = rect.width();
            int h = rect.height();
            byte[] data = new byte[w * h];
            bi.getRaster().getDataElements(rect.left, rect.top, rect.width(), rect.height(), data);
            int i = 0;
            while (i < w * h) {
                int n = i++;
                data[n] = (byte)(data[n] | 0x40);
            }
            bi.getRaster().setDataElements(rect.left, rect.top, rect.width(), rect.height(), data);
        }
    }

    private static class Rect {
        public int left;
        public int top;
        public int right;
        public int bottom;

        public Rect(int l, int t, int r, int b) {
            this.left = l;
            this.top = t;
            this.right = r;
            this.bottom = b;
        }

        public boolean isEmpty() {
            return this.width() <= 0 || this.height() <= 0;
        }

        public int width() {
            return this.right - this.left;
        }

        public int height() {
            return this.bottom - this.top;
        }
    }
}

