/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Random;
import junit.framework.TestCase;
import org.apache.lucene.util.IntList;

public class IntListTest
extends TestCase {
    public void testAdd() {
        IntList list = new IntList(2);
        IntListTest.assertTrue((boolean)list.isEmpty());
        list.add(1);
        IntListTest.assertFalse((boolean)list.isEmpty());
        list.add(2);
        IntListTest.assertEquals((int)2, (int)list.size());
        IntListTest.assertEquals((int)1, (int)list.get(0));
        IntListTest.assertEquals((int)2, (int)list.get(1));
        IntListTest.assertEquals((int)2, (int)list.getLast());
        list.add(3);
        IntListTest.assertEquals((int)3, (int)list.size());
        IntListTest.assertEquals((int)3, (int)list.get(2));
        IntListTest.assertEquals((int)3, (int)list.getLast());
        list.compact();
        IntListTest.assertEquals((int)3, (int)list.size());
        IntListTest.assertEquals((int)1, (int)list.get(0));
        IntListTest.assertEquals((int)2, (int)list.get(1));
        IntListTest.assertEquals((int)3, (int)list.get(2));
        list.set(1, 89);
        IntListTest.assertEquals((int)89, (int)list.get(1));
        int[] array = list.toArray();
        IntListTest.assertEquals((int)3, (int)array.length);
        IntListTest.assertEquals((int)1, (int)array[0]);
        IntListTest.assertEquals((int)89, (int)array[1]);
        IntListTest.assertEquals((int)3, (int)array[2]);
        list.fill(9);
        IntListTest.assertEquals((int)9, (int)list.get(0));
        IntListTest.assertEquals((int)9, (int)list.get(1));
        IntListTest.assertEquals((int)9, (int)list.get(2));
        list.clear();
        IntListTest.assertEquals((int)0, (int)list.size());
        IntListTest.assertTrue((boolean)list.isEmpty());
    }

    public void testSmall() {
        IntList list = new IntList(0);
        list.add(1);
        IntListTest.assertFalse((boolean)list.isEmpty());
        list.add(2);
        IntListTest.assertEquals((int)2, (int)list.size());
        IntListTest.assertEquals((int)1, (int)list.get(0));
        IntListTest.assertEquals((int)2, (int)list.get(1));
        IntListTest.assertEquals((int)2, (int)list.getLast());
        list = new IntList(1);
        list.add(1);
        IntListTest.assertFalse((boolean)list.isEmpty());
        list.add(2);
        IntListTest.assertEquals((int)2, (int)list.size());
        IntListTest.assertEquals((int)1, (int)list.get(0));
        IntListTest.assertEquals((int)2, (int)list.get(1));
        IntListTest.assertEquals((int)2, (int)list.getLast());
    }

    public void testSort() {
        IntList list = new IntList();
        int SIZE = 10000;
        Random rand = new Random(1L);
        int i = 0;
        while (i < 10000) {
            list.add(Math.abs(rand.nextInt()));
            ++i;
        }
        list.sort();
        i = 1;
        while (i < 10000) {
            IntListTest.assertTrue((list.get(i - 1) <= list.get(i) ? 1 : 0) != 0);
            ++i;
        }
        list.clear();
        i = 0;
        while (i < 10000) {
            list.add(Math.abs(rand.nextInt()));
            ++i;
        }
        int[] map = list.calcSortMap();
        int i2 = 1;
        while (i2 < 10000) {
            IntListTest.assertTrue((list.get(map[i2 - 1]) <= list.get(map[i2]) ? 1 : 0) != 0);
            ++i2;
        }
        list.remap(map);
        i2 = 1;
        while (i2 < 10000) {
            IntListTest.assertTrue((list.get(i2 - 1) <= list.get(i2) ? 1 : 0) != 0);
            ++i2;
        }
        IntListTest.assertEquals((int)list.get(0), (int)list.get(list.binarySearch(list.get(0))));
        IntListTest.assertEquals((int)list.get(3333), (int)list.get(list.binarySearch(list.get(3333))));
        IntListTest.assertEquals((int)list.get(6666), (int)list.get(list.binarySearch(list.get(6666))));
        IntListTest.assertEquals((int)list.get(9999), (int)list.get(list.binarySearch(list.get(9999))));
    }
}

