/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.spans.OrNearSpans;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.Spans;

public class SpanOrNearQuery
extends SpanQuery {
    private SpanQuery[] clauses;
    private int slop;
    private boolean penalizeOutOfOrder;
    private String field;

    public SpanOrNearQuery(SpanQuery[] clauses, int slop, boolean penalizeOutOfOrder) {
        this.clauses = clauses;
        int i = 0;
        while (i < clauses.length) {
            SpanQuery clause = clauses[i];
            if (i == 0) {
                this.field = clause.getField();
            } else if (!clause.getField().equals(this.field)) {
                throw new IllegalArgumentException("Clauses must have same field.");
            }
            ++i;
        }
        this.slop = slop;
        this.penalizeOutOfOrder = penalizeOutOfOrder;
    }

    public SpanQuery[] getClauses() {
        return this.clauses;
    }

    public int getSlop() {
        return this.slop;
    }

    public boolean penalizeOutOfOrder() {
        return this.penalizeOutOfOrder;
    }

    public void setSlop(int slop) {
        this.slop = slop;
    }

    public String getField() {
        return this.field;
    }

    public Collection getTerms() {
        ArrayList terms = new ArrayList();
        int i = 0;
        while (i < this.clauses.length) {
            terms.addAll(this.clauses[i].getTerms());
            ++i;
        }
        return terms;
    }

    public Query[] getSubQueries() {
        return this.clauses;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        ArrayList<SpanQuery> newClauses = new ArrayList<SpanQuery>(this.clauses.length);
        boolean anyChanged = false;
        int i = 0;
        while (i < this.clauses.length) {
            SpanQuery rewrittenClause = (SpanQuery)this.clauses[i].rewrite(reader);
            newClauses.add(rewrittenClause);
            if (this.clauses[i] != rewrittenClause) {
                anyChanged = true;
            }
            ++i;
        }
        if (!anyChanged) {
            return this;
        }
        SpanOrNearQuery clone = (SpanOrNearQuery)this.clone();
        clone.clauses = newClauses.toArray(new SpanQuery[newClauses.size()]);
        return clone;
    }

    public String toString(String field) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("spanOrNear([");
        int i = 0;
        while (i < this.clauses.length) {
            buffer.append(this.clauses[i].toString(field));
            if (i < this.clauses.length - 1) {
                buffer.append(", ");
            }
            ++i;
        }
        buffer.append("], ");
        buffer.append(this.slop);
        buffer.append(", ");
        buffer.append(this.penalizeOutOfOrder);
        buffer.append(")");
        if (this.getBoost() != 1.0f) {
            buffer.append("^" + this.getBoost());
        }
        return buffer.toString();
    }

    public Spans getSpans(IndexReader reader, Searcher searcher) throws IOException {
        if (this.clauses.length == 1) {
            return this.clauses[0].getSpans(reader, searcher);
        }
        return new OrNearSpans(this, reader, searcher);
    }
}

