/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.spans.SpanNearQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.Spans;

class NearSpans
implements Spans {
    private SpanNearQuery query;
    private Similarity similarity;
    private List ordered = new ArrayList();
    private int slop;
    private boolean inOrder;
    private SpansCell firstCell;
    private SpansCell lastCell;
    private int nCellsInList;
    private int totalLength;
    private float totalScore;
    private int totalSlop;
    private boolean more = true;
    private boolean firstTime = true;

    public NearSpans(SpanNearQuery query, IndexReader reader, Searcher searcher) throws IOException {
        this.query = query;
        this.slop = query.getSlop();
        this.inOrder = query.isInOrder();
        SpanQuery[] clauses = query.getClauses();
        int i = 0;
        while (i < clauses.length) {
            SpansCell cell = new SpansCell(clauses[i].getSpans(reader, searcher), i);
            this.ordered.add(cell);
            ++i;
        }
        this.similarity = searcher.getSimilarity();
    }

    public boolean next() throws IOException {
        if (this.firstTime) {
            this.initList(-1);
            this.firstTime = false;
        } else if (this.more) {
            this.more = this.advanceOneCell();
        }
        while (this.more) {
            this.totalSlop = -1;
            while (this.more && this.firstCell.doc() < this.lastCell.doc()) {
                this.more = this.firstCell.skipTo(this.lastCell.doc());
            }
            if (!this.more) {
                return false;
            }
            if (this.atMatch()) {
                return true;
            }
            this.more = this.advanceOneCell();
        }
        return false;
    }

    private boolean advanceOneCell() throws IOException {
        int matchLength = this.lastCell.end() - this.firstCell.start();
        if (matchLength - this.totalLength > this.slop) {
            return this.firstCell.next();
        }
        int index = 0;
        SpansCell cell = this.firstCell;
        while (cell != null) {
            if (cell.index != index++) {
                return cell.next();
            }
            cell = cell.nextCell;
        }
        return this.firstCell.next();
    }

    /*
     * Unable to fully structure code
     */
    public boolean skipTo(int target) throws IOException {
        block3: {
            if (!this.firstTime) ** GOTO lbl6
            this.initList(target);
            this.firstTime = false;
            break block3;
lbl-1000:
            // 1 sources

            {
                this.more = this.firstCell.skipTo(target);
lbl6:
                // 2 sources

                ** while (this.more && this.firstCell.doc() < target)
            }
        }
        this.totalSlop = -1;
        if (this.more) {
            if (this.atMatch()) {
                return true;
            }
            return this.next();
        }
        return false;
    }

    public int doc() {
        return this.firstCell.doc();
    }

    public int start() {
        return this.firstCell.start();
    }

    public int end() {
        return this.lastCell.end();
    }

    public float score() {
        return this.totalScore * this.query.getBoost() * this.similarity.sloppyFreq(this.totalSlop());
    }

    public String toString() {
        return "spans(" + this.query.toString() + ")@" + (this.firstTime ? "START" : (this.more ? String.valueOf(this.doc()) + ":" + this.start() + "-" + this.end() : "END"));
    }

    private void initList(int target) throws IOException {
        int i = 0;
        while (this.more && i < this.ordered.size()) {
            SpansCell cell = (SpansCell)this.ordered.get(i);
            cell.linkAfter(null);
            this.more = target < 0 ? cell.next() : cell.skipTo(target);
            ++i;
        }
    }

    private boolean atMatch() {
        return this.firstCell.doc() == this.lastCell.doc() && this.checkSlop() && (!this.inOrder || this.matchIsOrdered());
    }

    private boolean checkSlop() {
        int matchLength = this.lastCell.end() - this.firstCell.start();
        if (matchLength - this.totalLength > this.slop) {
            return false;
        }
        return this.totalSlop() <= this.slop;
    }

    private boolean matchIsOrdered() {
        int lastStart = -1;
        int i = 0;
        while (i < this.ordered.size()) {
            int start = ((SpansCell)this.ordered.get(i)).start();
            if (start <= lastStart) {
                return false;
            }
            lastStart = start;
            ++i;
        }
        return true;
    }

    private int totalSlop() {
        if (this.totalSlop >= 0) {
            return this.totalSlop;
        }
        int matchSlop = 0;
        int lastStart = -1;
        int lastEnd = -1;
        int i = 0;
        while (i < this.ordered.size()) {
            SpansCell cell = (SpansCell)this.ordered.get(i);
            int start = cell.start();
            int end = cell.end();
            if (i > 0) {
                if (end <= lastStart) {
                    matchSlop += lastStart - end + 1;
                } else if (start >= lastEnd) {
                    matchSlop += start - lastEnd;
                }
            }
            lastStart = start;
            lastEnd = end;
            ++i;
        }
        this.totalSlop = matchSlop;
        return this.totalSlop;
    }

    public Explanation explain() throws IOException {
        Explanation result = new Explanation(0.0f, "weight(" + this.toString() + "), product of:");
        Explanation sumExpl = new Explanation(0.0f, "totalMatchScore, sum of:");
        float totalScore = 0.0f;
        int i = 0;
        while (i < this.ordered.size()) {
            SpansCell cell = (SpansCell)this.ordered.get(i);
            totalScore += cell.score;
            sumExpl.addDetail(cell.spans.explain());
            ++i;
        }
        sumExpl.setValue(totalScore);
        result.addDetail(sumExpl);
        Explanation boostExpl = new Explanation(this.query.getBoost(), "boost");
        if (this.query.getBoost() != 1.0f) {
            result.addDetail(boostExpl);
        }
        int totalSlop = this.totalSlop();
        Explanation slopExpl = new Explanation(this.similarity.sloppyFreq(totalSlop), "sloppyFreq(slop=" + totalSlop + ")");
        result.addDetail(slopExpl);
        result.setValue(sumExpl.getValue() * boostExpl.getValue() * slopExpl.getValue());
        return result;
    }

    private class SpansCell
    implements Spans {
        private Spans spans;
        private SpansCell prevCell;
        private SpansCell nextCell;
        private int length = -1;
        private float score;
        private int index;

        public SpansCell(Spans spans, int index) {
            this.spans = spans;
            this.index = index;
        }

        public boolean next() throws IOException {
            this.preChange();
            boolean more = this.spans.next();
            if (more) {
                this.postChange();
            }
            return more;
        }

        public boolean skipTo(int target) throws IOException {
            this.preChange();
            boolean more = this.spans.skipTo(target);
            if (more) {
                this.postChange();
            }
            return more;
        }

        private void preChange() {
            if (this.length != -1) {
                NearSpans nearSpans = NearSpans.this;
                nearSpans.totalLength = nearSpans.totalLength - this.length;
                NearSpans nearSpans2 = NearSpans.this;
                nearSpans2.totalScore = nearSpans2.totalScore - this.score;
            }
        }

        private void postChange() {
            this.length = this.end() - this.start();
            NearSpans nearSpans = NearSpans.this;
            nearSpans.totalLength = nearSpans.totalLength + this.length;
            this.score = this.spans.score();
            NearSpans nearSpans2 = NearSpans.this;
            nearSpans2.totalScore = nearSpans2.totalScore + this.score;
            this.adjustPosition();
        }

        public void adjustPosition() {
            SpansCell putBefore;
            if (this == NearSpans.this.lastCell) {
                return;
            }
            if (!this.lessThan(NearSpans.this.lastCell)) {
                putBefore = null;
            } else {
                putBefore = this.nextCell;
                while (putBefore != null && !this.lessThan(putBefore)) {
                    putBefore = putBefore.nextCell;
                }
            }
            if (putBefore != this.nextCell) {
                this.unlink();
                this.linkBefore(putBefore);
            }
        }

        private void unlink() {
            if (this.prevCell == null) {
                NearSpans.this.firstCell = this.nextCell;
            } else {
                this.prevCell.nextCell = this.nextCell;
            }
            if (this.nextCell == null) {
                NearSpans.this.lastCell = this;
            } else {
                this.nextCell.prevCell = this.prevCell;
            }
            this.prevCell = null;
            this.nextCell = null;
            NearSpans nearSpans = NearSpans.this;
            nearSpans.nCellsInList = nearSpans.nCellsInList - 1;
        }

        private void linkBefore(SpansCell other) {
            this.nextCell = other;
            this.prevCell = other == null ? NearSpans.this.lastCell : other.prevCell;
            NearSpans nearSpans = NearSpans.this;
            nearSpans.nCellsInList = nearSpans.nCellsInList + 1;
            this.fixLinks();
        }

        private void linkAfter(SpansCell other) {
            this.prevCell = other;
            this.nextCell = other == null ? NearSpans.this.firstCell : other.nextCell;
            NearSpans nearSpans = NearSpans.this;
            nearSpans.nCellsInList = nearSpans.nCellsInList + 1;
            this.fixLinks();
        }

        private void fixLinks() {
            if (this.nextCell == null) {
                NearSpans.this.lastCell = this;
            } else {
                this.nextCell.prevCell = this;
            }
            if (this.prevCell == null) {
                NearSpans.this.firstCell = this;
            } else {
                this.prevCell.nextCell = this;
            }
        }

        private void checkList() {
            System.out.println("DEBUGGING ONLY");
            int nCells = 0;
            SpansCell cell = NearSpans.this.firstCell;
            while (cell != null) {
                if (cell == NearSpans.this.firstCell) assert (cell.prevCell == null);
                if (cell == NearSpans.this.lastCell) assert (cell.nextCell == null);
                if (cell.prevCell == null ? !$assertionsDisabled && NearSpans.this.firstCell != cell : !$assertionsDisabled && cell.prevCell.nextCell != cell) {
                    throw new AssertionError();
                }
                if (cell.nextCell == null ? !$assertionsDisabled && NearSpans.this.lastCell != cell : !$assertionsDisabled && cell.nextCell.prevCell != cell) {
                    throw new AssertionError();
                }
                assert (++nCells <= NearSpans.this.nCellsInList);
                cell = cell.nextCell;
            }
            assert (nCells == NearSpans.this.nCellsInList);
        }

        private final boolean lessThan(SpansCell otherCell) {
            if (this.doc() == otherCell.doc()) {
                if (this.start() == otherCell.start()) {
                    if (this.end() == otherCell.end()) {
                        return this.index > otherCell.index;
                    }
                    return this.end() < otherCell.end();
                }
                return this.start() < otherCell.start();
            }
            return this.doc() < otherCell.doc();
        }

        public int doc() {
            return this.spans.doc();
        }

        public int start() {
            return this.spans.start();
        }

        public int end() {
            return this.spans.end();
        }

        public float score() {
            throw new UnsupportedOperationException();
        }

        public Explanation explain() throws IOException {
            return this.spans.explain();
        }

        public void collectTerms(Set terms) {
        }

        public String toString() {
            return String.valueOf(this.spans.toString()) + "#" + this.index;
        }
    }
}

