/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx.xml;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class XMLIndenter
extends DefaultHandler
implements ContentHandler {
    private final PrintWriter writer;
    private transient int indentLevel = 0;
    private transient Stack states = new Stack();
    private static final Integer EMPTY = new Integer(0);
    private static final Integer HAS_TEXT = new Integer(1);
    private static final Integer HAS_CHILDREN = new Integer(2);

    private XMLIndenter(Writer writer) {
        this.writer = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        int n;
        if (!this.states.empty()) {
            if (this.states.pop().equals(EMPTY)) {
                this.writer.println('>');
            }
            this.states.push(HAS_CHILDREN);
        }
        for (n = 0; n < this.indentLevel; ++n) {
            this.writer.print("  ");
        }
        this.writer.print('<' + string3);
        for (n = 0; n < attributes.getLength(); ++n) {
            this.writer.print(' ' + attributes.getQName(n) + "=\"" + attributes.getValue(n) + '\"');
        }
        ++this.indentLevel;
        this.states.push(EMPTY);
    }

    public void endElement(String string, String string2, String string3) {
        --this.indentLevel;
        Object e = this.states.pop();
        if (EMPTY.equals(e)) {
            this.writer.println("/>");
        } else if (HAS_TEXT.equals(e)) {
            this.writer.println("</" + string3 + '>');
        } else if (HAS_CHILDREN.equals(e)) {
            for (int i = 0; i < this.indentLevel; ++i) {
                this.writer.print("  ");
            }
            this.writer.println("</" + string3 + '>');
        }
    }

    public void characters(char[] cArray, int n, int n2) {
        if (this.states.peek().equals(EMPTY)) {
            this.states.pop();
            this.writer.print('>');
            this.states.push(HAS_TEXT);
        }
        this.writer.print(new String(cArray, n, n2));
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) {
    }

    public static String indent(String string) throws SAXException, IOException, ParserConfigurationException {
        StringWriter stringWriter = new StringWriter();
        StringReader stringReader = new StringReader(string);
        XMLIndenter.indent(stringReader, stringWriter);
        return ((Object)stringWriter).toString();
    }

    public static void indent(Reader reader, Writer writer) throws SAXException, IOException, ParserConfigurationException {
        XMLIndenter xMLIndenter = new XMLIndenter(writer);
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setNamespaceAware(false);
        sAXParserFactory.setValidating(false);
        InputSource inputSource = new InputSource(reader);
        XMLReader xMLReader = sAXParserFactory.newSAXParser().getXMLReader();
        xMLReader.setContentHandler(xMLIndenter);
        xMLReader.parse(inputSource);
    }

    public static String indentSilent(String string) {
        try {
            return XMLIndenter.indent(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean indentSilent(Reader reader, Writer writer) {
        try {
            XMLIndenter.indent(reader, writer);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

