/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.marc4j.util.CodeTableHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class CodeTable {
    protected static Hashtable charsets = null;
    protected static Hashtable combining = null;

    public static boolean isCombining(int n, int n2, int n3) {
        if (n <= 126) {
            Vector vector = (Vector)combining.get(new Integer(n2));
            return vector.contains(new Integer(n));
        }
        Vector vector = (Vector)combining.get(new Integer(n3));
        return vector.contains(new Integer(n));
    }

    public static char getChar(int n, int n2) {
        if (n == 32) {
            return (char)n;
        }
        Hashtable hashtable = (Hashtable)charsets.get(new Integer(n2));
        if (hashtable == null) {
            System.err.println("Hashtable not found: " + Integer.toHexString(n2));
            return (char)n;
        }
        Character c = (Character)hashtable.get(new Integer(n));
        if (c == null) {
            int n3 = n < 128 ? n + 128 : n - 128;
            c = (Character)hashtable.get(new Integer(n3));
            if (c == null) {
                System.err.println("Character not found: " + Integer.toHexString(n) + " in Code Table: " + Integer.toHexString(n2));
                return (char)n;
            }
            return c.charValue();
        }
        return c.charValue();
    }

    public CodeTable(InputStream inputStream) {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            sAXParserFactory.setValidating(false);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            XMLReader xMLReader = sAXParser.getXMLReader();
            InputSource inputSource = new InputSource(inputStream);
            CodeTableHandler codeTableHandler = new CodeTableHandler();
            xMLReader.setContentHandler(codeTableHandler);
            xMLReader.parse(inputSource);
            charsets = codeTableHandler.getCharSets();
            combining = codeTableHandler.getCombiningChars();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            System.err.println("Exception: " + exception);
        }
    }

    public CodeTable(String string) {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            sAXParserFactory.setValidating(false);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            XMLReader xMLReader = sAXParser.getXMLReader();
            File file = new File(string);
            InputSource inputSource = new InputSource(new FileInputStream(file));
            CodeTableHandler codeTableHandler = new CodeTableHandler();
            xMLReader.setContentHandler(codeTableHandler);
            xMLReader.parse(inputSource);
            charsets = codeTableHandler.getCharSets();
            combining = codeTableHandler.getCombiningChars();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            System.err.println("Exception: " + exception);
        }
    }

    public CodeTable(URI uRI) {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            sAXParserFactory.setValidating(false);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            XMLReader xMLReader = sAXParser.getXMLReader();
            InputSource inputSource = new InputSource(uRI.toURL().openStream());
            CodeTableHandler codeTableHandler = new CodeTableHandler();
            xMLReader.setContentHandler(codeTableHandler);
            xMLReader.parse(inputSource);
            charsets = codeTableHandler.getCharSets();
            combining = codeTableHandler.getCombiningChars();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            System.err.println("Exception: " + exception);
        }
    }
}

