/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j.marcxml;

import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public class SaxErrorHandler
implements ErrorHandler {
    private int flags;
    public static final int ERR_PRINT = 1;
    public static final int ERR_IGNORE = 2;
    public static final int WARN_PRINT = 4;
    public static final int FATAL_PRINT = 8;
    public static final int FATAL_IGNORE = 16;

    public SaxErrorHandler() {
        this.flags = -1;
    }

    public SaxErrorHandler(int n) {
        this.flags = n;
    }

    public void error(SAXParseException sAXParseException) throws SAXParseException {
        if ((this.flags & 1) != 0) {
            System.err.print(SaxErrorHandler.printParseException("Error", sAXParseException));
        }
        if ((this.flags & 2) == 0) {
            throw sAXParseException;
        }
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXParseException {
        if ((this.flags & 8) != 0) {
            System.err.print(SaxErrorHandler.printParseException("FATAL", sAXParseException));
        }
        if ((this.flags & 0x10) == 0) {
            throw sAXParseException;
        }
    }

    public void warning(SAXParseException sAXParseException) throws SAXParseException {
        if ((this.flags & 4) != 0) {
            System.err.print(SaxErrorHandler.printParseException("Warning", sAXParseException));
        }
    }

    public static String printParseException(String string, SAXParseException sAXParseException) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("** ");
        stringBuffer.append(string);
        stringBuffer.append(": ");
        stringBuffer.append(sAXParseException.getMessage());
        stringBuffer.append('\n');
        if (sAXParseException.getSystemId() != null) {
            stringBuffer.append("   URI:  ");
            stringBuffer.append(sAXParseException.getSystemId());
            stringBuffer.append('\n');
        }
        if ((n = sAXParseException.getLineNumber()) != -1) {
            stringBuffer.append("   Line: ");
            stringBuffer.append(n);
            stringBuffer.append('\n');
        }
        if ((n = sAXParseException.getColumnNumber()) != -1) {
            stringBuffer.append("   Character: ");
            stringBuffer.append(n);
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }
}

