/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.marc4j.ErrorHandler;
import org.marc4j.MarcHandler;
import org.marc4j.MarcReaderException;
import org.marc4j.marc.Leader;
import org.marc4j.marc.MarcException;
import org.marc4j.marc.Tag;

public class MarcReader {
    private static final int RT = 29;
    private static final int FT = 30;
    private static final int US = 31;
    private static final int BLANK = 32;
    int fileCounter = 0;
    int recordCounter = 0;
    String controlNumber = null;
    String tag = null;
    String fileName = null;
    private MarcHandler mh;
    private ErrorHandler eh;

    public void setMarcHandler(MarcHandler marcHandler) {
        this.mh = marcHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.eh = errorHandler;
    }

    public void parse(String string) throws IOException {
        this.setFileName(string);
        this.parse(new FileInputStream(string));
    }

    public void parse(InputStream inputStream) throws IOException {
        this.parse(new BufferedReader(new InputStreamReader(inputStream, "ISO8859_1")));
    }

    public void parse(InputStreamReader inputStreamReader) throws IOException {
        if (!inputStreamReader.getEncoding().equals("ISO8859_1")) {
            throw new UnsupportedEncodingException("found " + inputStreamReader.getEncoding() + ", require ISO8859_1");
        }
        this.parse(new BufferedReader(inputStreamReader));
    }

    /*
     * Unable to fully structure code
     */
    public void parse(Reader var1_1) throws IOException {
        var2_2 = 24;
        if (this.mh != null) {
            this.mh.startCollection();
        }
        while (true) {
            var3_3 = null;
            var4_4 = new char[24];
            var5_5 = var1_1.read(var4_4);
            if (var5_5 != -1) ** GOTO lbl11
            break;
lbl-1000:
            // 1 sources

            {
                var5_5 += var1_1.read(var4_4, var5_5, var4_4.length - var5_5);
lbl11:
                // 2 sources

                ** while (var5_5 != -1 && var5_5 != var4_4.length)
            }
lbl12:
            // 1 sources

            try {
                var3_3 = new Leader(new String(var4_4));
            }
            catch (MarcException var6_7) {
                if (this.eh != null) {
                    this.reportFatalError("Unable to parse leader");
                }
                return;
            }
            var6_6 = var3_3.getBaseAddressOfData();
            this.recordCounter += 24;
            if (this.mh != null) {
                this.mh.startRecord(var3_3);
            }
            var7_8 = var3_3.getBaseAddressOfData() - 25;
            var8_9 = var7_8 / 12;
            var9_10 = new String[var8_9];
            var10_11 = new int[var8_9];
            if (var7_8 % 12 != 0 && this.eh != null) {
                this.reportError("Invalid directory length");
            }
            var11_12 = 0;
            while (var11_12 < var8_9) {
                block23: {
                    var12_14 = new char[3];
                    var5_5 = var1_1.read(var12_14);
                    while (var5_5 != -1 && var5_5 != var12_14.length) {
                        var5_5 += var1_1.read(var12_14, var5_5, var12_14.length - var5_5);
                    }
                    var13_15 = new char[4];
                    var5_5 = var1_1.read(var13_15);
                    while (var5_5 != -1 && var5_5 != var13_15.length) {
                        var5_5 += var1_1.read(var13_15, var5_5, var13_15.length - var5_5);
                    }
                    var14_16 = new char[5];
                    var5_5 = var1_1.read(var14_16);
                    while (var5_5 != -1 && var5_5 != var14_16.length) {
                        var5_5 += var1_1.read(var14_16, var5_5, var14_16.length - var5_5);
                    }
                    this.recordCounter += 12;
                    var9_10[var11_12] = new String(var12_14);
                    try {
                        var10_11[var11_12] = Integer.parseInt(new String(var13_15));
                    }
                    catch (NumberFormatException var15_17) {
                        if (this.eh == null) break block23;
                        this.reportError("Invalid directory entry");
                    }
                }
                ++var11_12;
            }
            if (var1_1.read() != 30 && this.eh != null) {
                this.reportError("Directory not terminated");
            }
            ++this.recordCounter;
            var12_13 = 0;
            while (var12_13 < var8_9) {
                var13_15 = new char[var10_11[var12_13]];
                var5_5 = var1_1.read(var13_15);
                while (var5_5 != -1 && var5_5 != var13_15.length) {
                    var5_5 += var1_1.read(var13_15, var5_5, var13_15.length - var5_5);
                }
                if (var13_15[var13_15.length - 1] != '\u001e' && this.eh != null) {
                    this.reportError("Field not terminated");
                }
                this.recordCounter += var10_11[var12_13];
                if (Tag.isControlField(var9_10[var12_13])) {
                    this.parseControlField(var9_10[var12_13], var13_15);
                } else {
                    this.parseDataField(var9_10[var12_13], var13_15);
                }
                ++var12_13;
            }
            if (var1_1.read() != 29 && this.eh != null) {
                this.reportError("Record not terminated");
            }
            ++this.recordCounter;
            if (this.recordCounter != var3_3.getRecordLength() && this.eh != null) {
                this.reportError("Record length not equal to characters read");
            }
            this.fileCounter += this.recordCounter;
            this.recordCounter = 0;
            if (this.mh == null) continue;
            this.mh.endRecord();
        }
        var1_1.close();
        if (this.mh != null) {
            this.mh.endCollection();
        }
    }

    private void parseControlField(String string, char[] cArray) {
        if (cArray.length < 2 && this.eh != null) {
            this.reportWarning("Control Field contains no data elements for tag " + string);
        }
        if (Tag.isControlNumberField(string)) {
            this.setControlNumber(this.trimFT(cArray));
        }
        if (this.mh != null) {
            this.mh.controlField(string, this.trimFT(cArray));
        }
    }

    private void parseDataField(String string, char[] cArray) throws IOException {
        char c = ' ';
        char c2 = ' ';
        char c3 = ' ';
        StringBuffer stringBuffer = null;
        if (cArray.length < 4 && this.eh != null) {
            this.reportWarning("Data field contains no data elements for tag " + string);
        } else {
            c = cArray[0];
            c2 = cArray[1];
        }
        if (this.mh != null) {
            this.mh.startDataField(string, c, c2);
        }
        if (cArray[2] != '\u001f' && cArray.length > 3 && this.eh != null) {
            this.reportWarning("Expected a data element identifier");
        }
        int n = 2;
        while (n < cArray.length) {
            char c4 = cArray[n];
            switch (c4) {
                case '\u001f': {
                    if (stringBuffer != null) {
                        this.reportSubfield(c3, stringBuffer);
                    }
                    c3 = cArray[n + 1];
                    ++n;
                    stringBuffer = new StringBuffer();
                    break;
                }
                case '\u001e': {
                    if (stringBuffer == null) break;
                    this.reportSubfield(c3, stringBuffer);
                    break;
                }
                default: {
                    if (stringBuffer == null) break;
                    stringBuffer.append(c4);
                }
            }
            ++n;
        }
        if (this.mh != null) {
            this.mh.endDataField(string);
        }
    }

    private void reportSubfield(char c, StringBuffer stringBuffer) {
        if (this.mh != null) {
            this.mh.subfield(c, new String(stringBuffer).toCharArray());
        }
    }

    private void reportWarning(String string) {
        if (this.eh != null) {
            this.eh.warning(new MarcReaderException(string, this.getFileName(), this.getPosition(), this.getControlNumber()));
        }
    }

    private void reportError(String string) {
        if (this.eh != null) {
            this.eh.error(new MarcReaderException(string, this.getFileName(), this.getPosition(), this.getControlNumber()));
        }
    }

    private void reportFatalError(String string) {
        if (this.eh != null) {
            this.eh.fatalError(new MarcReaderException(string, this.getFileName(), this.getPosition(), this.getControlNumber()));
        }
    }

    private void setControlNumber(String string) {
        this.controlNumber = string;
    }

    private void setControlNumber(char[] cArray) {
        this.controlNumber = new String(cArray);
    }

    private void setFileName(String string) {
        this.fileName = string;
    }

    private String getControlNumber() {
        return this.controlNumber;
    }

    private int getPosition() {
        return this.fileCounter + this.recordCounter;
    }

    private String getFileName() {
        return this.fileName;
    }

    private char[] trimFT(char[] cArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < cArray.length) {
            char c = cArray[n];
            switch (c) {
                case '\u001e': {
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n;
        }
        return stringBuffer.toString().toCharArray();
    }
}

