/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc.fesi;

import FESI.Data.BuiltinFunctionObject;
import FESI.Data.ESNull;
import FESI.Data.ESObject;
import FESI.Data.ESString;
import FESI.Data.ESUndefined;
import FESI.Data.ESValue;
import FESI.Data.FunctionPrototype;
import FESI.Data.GlobalObject;
import FESI.Data.ObjectObject;
import FESI.Data.ObjectPrototype;
import FESI.Exceptions.EcmaScriptException;
import FESI.Extensions.Extension;
import FESI.Interpreter.Evaluator;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.fesi.FesiRpcServer;
import org.apache.xmlrpc.fesi.FesiRpcUtil;

public class FesiRpcExtension
extends Extension {
    Evaluator evaluator;
    ESObject op;

    public void initializeExtension(Evaluator evaluator) throws EcmaScriptException {
        this.evaluator = evaluator;
        GlobalObject go = evaluator.getGlobalObject();
        FunctionPrototype fp = (FunctionPrototype)evaluator.getFunctionPrototype();
        this.op = evaluator.getObjectPrototype();
        go.putHiddenProperty("Remote", (ESValue)new GlobalObjectRemote("Remote", evaluator, fp));
        go.putHiddenProperty("RemoteServer", (ESValue)new GlobalObjectRemoteServer("RemoteServer", evaluator, fp));
    }

    class ESRemote
    extends ObjectPrototype {
        URL url;
        String remoteObject;

        public ESRemote(ESObject prototype, Evaluator evaluator, String urlstring, String robj) throws MalformedURLException {
            super(prototype, evaluator);
            this.url = new URL(urlstring);
            this.remoteObject = robj;
        }

        public ESRemote(ESObject prototype, Evaluator evaluator, URL url, String robj) {
            super(prototype, evaluator);
            this.url = url;
            this.remoteObject = robj;
        }

        public ESValue doIndirectCall(Evaluator evaluator, ESObject target, String functionName, ESValue[] arguments) throws EcmaScriptException, NoSuchMethodException {
            XmlRpcClient client = new XmlRpcClient(this.url);
            long now = System.currentTimeMillis();
            Object retval = null;
            int l = arguments.length;
            Vector<Object> v = new Vector<Object>();
            for (int i = 0; i < l; ++i) {
                Object arg = FesiRpcUtil.convertE2J(arguments[i]);
                v.addElement(arg);
            }
            ObjectPrototype esretval = ObjectObject.createObject((Evaluator)evaluator);
            try {
                String method = this.remoteObject == null ? functionName : this.remoteObject + "." + functionName;
                retval = client.execute(method, v);
                esretval.putProperty("error", (ESValue)ESNull.theNull, "error".hashCode());
                esretval.putProperty("result", FesiRpcUtil.convertJ2E(retval, ((ESObject)this).evaluator), "result".hashCode());
            }
            catch (Exception x) {
                String msg = x.getMessage();
                if (msg == null || msg.length() == 0) {
                    msg = x.toString();
                }
                esretval.putProperty("error", (ESValue)new ESString(msg), "error".hashCode());
                esretval.putProperty("result", (ESValue)ESNull.theNull, "result".hashCode());
            }
            return esretval;
        }

        public ESValue getProperty(String name, int hash) throws EcmaScriptException {
            ESValue sprop = super.getProperty(name, hash);
            if (sprop != ESUndefined.theUndefined && sprop != ESNull.theNull) {
                return sprop;
            }
            String newRemoteObject = this.remoteObject == null ? name : this.remoteObject + "." + name;
            return new ESRemote(FesiRpcExtension.this.op, ((ESObject)this).evaluator, this.url, newRemoteObject);
        }
    }

    class GlobalObjectRemoteServer
    extends BuiltinFunctionObject {
        GlobalObjectRemoteServer(String name, Evaluator evaluator, FunctionPrototype fp) {
            super((ESObject)fp, evaluator, name, 1);
        }

        public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            return this.doConstruct(thisObject, arguments);
        }

        public ESObject doConstruct(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            FesiRpcServer remotesrv = null;
            String globalname = null;
            if (arguments.length < 1 || arguments.length > 2) {
                throw new EcmaScriptException("Wrong number of arguments for constructor RemoteServer");
            }
            int port = arguments[0].toInt32();
            if (arguments.length == 2) {
                globalname = arguments[1].toString();
            }
            try {
                remotesrv = new FesiRpcServer(port, FesiRpcExtension.this.op, ((ESObject)this).evaluator);
                if (globalname != null) {
                    ((ESObject)this).evaluator.getGlobalObject().putProperty(globalname, (ESValue)remotesrv, globalname.hashCode());
                }
            }
            catch (IOException x) {
                throw new EcmaScriptException(x.toString());
            }
            return remotesrv;
        }
    }

    class GlobalObjectRemote
    extends BuiltinFunctionObject {
        GlobalObjectRemote(String name, Evaluator evaluator, FunctionPrototype fp) {
            super((ESObject)fp, evaluator, name, 1);
        }

        public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            return this.doConstruct(thisObject, arguments);
        }

        public ESObject doConstruct(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            ESRemote remote = null;
            String url = null;
            String robj = null;
            if (arguments.length >= 1) {
                url = arguments[0].toString();
            }
            if (arguments.length >= 2) {
                robj = arguments[1].toString();
            }
            try {
                remote = new ESRemote(FesiRpcExtension.this.op, ((ESObject)this).evaluator, url, robj);
            }
            catch (MalformedURLException x) {
                throw new EcmaScriptException(x.toString());
            }
            return remote;
        }
    }
}

