/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.EmptyStackException;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.apache.xmlrpc.AsyncCallback;
import org.apache.xmlrpc.Base64;
import org.apache.xmlrpc.XmlRpc;
import org.apache.xmlrpc.XmlRpcClientLite;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcHandler;
import org.apache.xmlrpc.XmlWriter;
import org.xml.sax.AttributeList;
import org.xml.sax.SAXException;

public class XmlRpcClient
implements XmlRpcHandler {
    protected URL url;
    private String auth;
    protected Stack pool = new Stack();
    protected int workers = 0;
    protected int asyncWorkers = 0;
    private CallData first;
    private CallData last;

    public XmlRpcClient(URL url) {
        this.url = url;
        if (XmlRpc.debug) {
            System.out.println("Created client to url space " + url);
        }
    }

    public XmlRpcClient(String url) throws MalformedURLException {
        this(new URL(url));
    }

    public XmlRpcClient(String hostname, int port) throws MalformedURLException {
        this(new URL("http://" + hostname + ':' + port + "/RPC2"));
    }

    public URL getURL() {
        return this.url;
    }

    public void setBasicAuthentication(String user, String password) {
        this.auth = user == null || password == null ? null : new String(Base64.encode((user + ':' + password).getBytes())).trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(String method, Vector params) throws XmlRpcException, IOException {
        Worker worker = this.getWorker(false);
        try {
            Object retval;
            Object object = retval = worker.execute(method, params);
            return object;
        }
        finally {
            this.releaseWorker(worker, false);
        }
    }

    public void executeAsync(String method, Vector params, AsyncCallback callback) {
        if (this.asyncWorkers >= 4) {
            this.enqueue(method, params, callback);
            return;
        }
        Worker worker = null;
        try {
            worker = this.getWorker(true);
            worker.start(method, params, callback);
        }
        catch (IOException iox) {
            this.enqueue(method, params, callback);
        }
    }

    synchronized Worker getWorker(boolean async) throws IOException {
        try {
            Worker w = (Worker)this.pool.pop();
            if (async) {
                ++this.asyncWorkers;
            } else {
                ++this.workers;
            }
            return w;
        }
        catch (EmptyStackException x) {
            if (this.workers < XmlRpc.getMaxThreads()) {
                if (async) {
                    ++this.asyncWorkers;
                } else {
                    ++this.workers;
                }
                return new Worker();
            }
            throw new IOException("XML-RPC System overload");
        }
    }

    synchronized void releaseWorker(Worker w, boolean async) {
        w.result = null;
        w.call = null;
        if (this.pool.size() < 20 && !w.fault) {
            this.pool.push(w);
        }
        if (async) {
            --this.asyncWorkers;
        } else {
            --this.workers;
        }
    }

    synchronized void enqueue(String method, Vector params, AsyncCallback callback) {
        CallData call = new CallData(method, params, callback);
        if (this.last == null) {
            this.first = this.last = call;
        } else {
            this.last.next = call;
            this.last = call;
        }
    }

    synchronized CallData dequeue() {
        if (this.first == null) {
            return null;
        }
        CallData call = this.first;
        if (this.first == this.last) {
            this.last = null;
            this.first = null;
        } else {
            this.first = this.first.next;
        }
        return call;
    }

    public static void main(String[] args) throws Exception {
        try {
            String url = args[0];
            String method = args[1];
            Vector<Object> v = new Vector<Object>();
            for (int i = 2; i < args.length; ++i) {
                try {
                    v.addElement(new Integer(Integer.parseInt(args[i])));
                    continue;
                }
                catch (NumberFormatException nfx) {
                    v.addElement(args[i]);
                }
            }
            XmlRpcClientLite client = new XmlRpcClientLite(url);
            try {
                System.out.println(client.execute(method, v));
            }
            catch (Exception ex) {
                System.err.println("Error: " + ex.getMessage());
            }
        }
        catch (Exception x) {
            System.err.println(x);
            System.err.println("Usage: java org.apache.xmlrpc.XmlRpcClient <url> <method> <arg> ....");
            System.err.println("Arguments are sent as integers or strings.");
        }
    }

    class CallData {
        String method;
        Vector params;
        AsyncCallback callback;
        CallData next;

        public CallData(String method, Vector params, AsyncCallback callback) {
            this.method = method;
            this.params = params;
            this.callback = callback;
            this.next = null;
        }
    }

    class Worker
    extends XmlRpc
    implements Runnable {
        boolean fault;
        Object result = null;
        ByteArrayOutputStream buffer;
        CallData call;

        public void start(String method, Vector params, AsyncCallback callback) {
            this.call = new CallData(method, params, callback);
            Thread t = new Thread(this);
            t.start();
        }

        public void run() {
            while (this.call != null) {
                this.executeAsync(this.call.method, this.call.params, this.call.callback);
                this.call = XmlRpcClient.this.dequeue();
            }
            XmlRpcClient.this.releaseWorker(this, true);
        }

        void executeAsync(String method, Vector params, AsyncCallback callback) {
            block5: {
                Object res = null;
                try {
                    res = this.execute(method, params);
                    if (callback != null) {
                        callback.handleResult(res, XmlRpcClient.this.url, method);
                    }
                }
                catch (Exception x) {
                    if (callback == null) break block5;
                    try {
                        callback.handleError(x, XmlRpcClient.this.url, method);
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                }
            }
        }

        Object execute(String method, Vector params) throws XmlRpcException, IOException {
            this.fault = false;
            long now = 0L;
            if (XmlRpc.debug) {
                System.out.println("Client calling procedure '" + method + "' with parameters " + params);
                now = System.currentTimeMillis();
            }
            try {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                if (this.buffer == null) {
                    this.buffer = new ByteArrayOutputStream();
                } else {
                    this.buffer.reset();
                }
                XmlWriter writer = new XmlWriter((OutputStream)this.buffer, XmlRpc.encoding);
                this.writeRequest(writer, method, params);
                writer.flush();
                byte[] request = this.buffer.toByteArray();
                URLConnection con = XmlRpcClient.this.url.openConnection();
                con.setDoInput(true);
                con.setDoOutput(true);
                con.setUseCaches(false);
                con.setAllowUserInteraction(false);
                con.setRequestProperty("Content-Length", Integer.toString(request.length));
                con.setRequestProperty("Content-Type", "text/xml");
                if (XmlRpcClient.this.auth != null) {
                    con.setRequestProperty("Authorization", "Basic " + XmlRpcClient.this.auth);
                }
                OutputStream out = con.getOutputStream();
                out.write(request);
                out.flush();
                out.close();
                InputStream in = con.getInputStream();
                this.parse(in);
            }
            catch (Exception x) {
                if (XmlRpc.debug) {
                    x.printStackTrace();
                }
                throw new IOException(x.getMessage());
            }
            if (this.fault) {
                XmlRpcException exception = null;
                try {
                    Hashtable f = (Hashtable)this.result;
                    String faultString = (String)f.get("faultString");
                    int faultCode = Integer.parseInt(f.get("faultCode").toString());
                    exception = new XmlRpcException(faultCode, faultString.trim());
                }
                catch (Exception x) {
                    throw new XmlRpcException(0, "Invalid fault response");
                }
                throw exception;
            }
            if (XmlRpc.debug) {
                System.out.println("Spent " + (System.currentTimeMillis() - now) + " in request");
            }
            return this.result;
        }

        protected void objectParsed(Object what) {
            this.result = what;
        }

        void writeRequest(XmlWriter writer, String method, Vector params) throws IOException, XmlRpcException {
            writer.startElement("methodCall");
            writer.startElement("methodName");
            writer.write(method);
            writer.endElement("methodName");
            writer.startElement("params");
            int l = params.size();
            for (int i = 0; i < l; ++i) {
                writer.startElement("param");
                writer.writeObject(params.elementAt(i));
                writer.endElement("param");
            }
            writer.endElement("params");
            writer.endElement("methodCall");
        }

        public void startElement(String name, AttributeList atts) throws SAXException {
            if ("fault".equals(name)) {
                this.fault = true;
            } else {
                super.startElement(name, atts);
            }
        }
    }
}

