/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.core.indexer;

import org.apache.xindice.core.data.Key;
import org.apache.xindice.core.indexer.IndexPattern;

public final class IndexMatch
implements Comparable {
    private Key key;
    private int pos;
    private int len;
    private short elem;
    private short attr;

    public IndexMatch() {
        this.key = null;
        this.pos = -1;
        this.len = -1;
        this.elem = (short)-1;
        this.attr = (short)-1;
    }

    public IndexMatch(Key key, int pos, int len, short elem, short attr) {
        this.key = key;
        this.pos = pos;
        this.len = len;
        this.elem = elem;
        this.attr = attr;
    }

    public IndexMatch(Key key, int pos, int len) {
        this.key = key;
        this.pos = pos;
        this.len = len;
        this.elem = (short)-1;
        this.attr = (short)-1;
    }

    public IndexMatch(Key key, IndexPattern pattern) {
        this.key = key;
        this.pos = -1;
        this.len = -1;
        this.elem = pattern.getElementID();
        this.attr = pattern.getAttributeID();
    }

    public final Key getKey() {
        return this.key;
    }

    public final int getPosition() {
        return this.pos;
    }

    public final int getLength() {
        return this.len;
    }

    public final short getElement() {
        return this.elem;
    }

    public final short getAttribute() {
        return this.attr;
    }

    public int compareTo(Object obj) {
        return this.key.compareTo(obj);
    }

    public String toString() {
        return this.key.toString();
    }
}

