/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

public abstract class TabState {
    public static int STATE_LAST = 8192;
    private int pressedIndex = -1;
    private int containsMouseIndex = -1;
    private int closeButtonContainsMouseIndex = -1;
    private int mousePressedInCloseButtonIndex = -1;
    private boolean mouseInTabsArea = false;
    private boolean active = false;
    private int selectedIndex = -1;
    private int prev = -1;
    private int curr = -1;
    private int lastChangeType = 0;
    private int lastAffected = 0;
    private int lastChange = 0;

    public int getState(int n) {
        int n2 = 0;
        if (n == this.pressedIndex) {
            n2 |= 8;
        }
        if (n == this.containsMouseIndex) {
            n2 |= 4;
        }
        if (n == this.closeButtonContainsMouseIndex) {
            n2 |= 0x200;
        }
        if (n == this.mousePressedInCloseButtonIndex) {
            n2 |= 0x2000;
        }
        if (this.mouseInTabsArea) {
            n2 |= 0x1000;
        }
        if (this.active) {
            n2 |= 0x20;
        }
        if (n == this.selectedIndex) {
            n2 |= 0x10;
        }
        if (n != 0 && n == this.selectedIndex + 1) {
            n2 |= 0x800;
        }
        if (n == this.selectedIndex - 1) {
            n2 |= 0x400;
        }
        return n2;
    }

    public void clearTransientStates() {
        this.pressedIndex = -1;
        this.containsMouseIndex = -1;
        this.closeButtonContainsMouseIndex = -1;
        this.mousePressedInCloseButtonIndex = -1;
        this.mouseInTabsArea = false;
        this.lastChangeType = 0;
        this.lastChange = 0;
        this.prev = -1;
        this.curr = -1;
    }

    public final int setPressed(int n) {
        this.prev = this.pressedIndex;
        this.pressedIndex = n;
        this.curr = n;
        this.possibleChange(this.prev, this.curr, 8);
        return this.prev;
    }

    public final int setContainsMouse(int n) {
        this.prev = this.containsMouseIndex;
        this.containsMouseIndex = n;
        this.curr = n;
        this.possibleChange(this.prev, this.curr, 4);
        return this.prev;
    }

    public final int setCloseButtonContainsMouse(int n) {
        this.prev = this.closeButtonContainsMouseIndex;
        this.closeButtonContainsMouseIndex = n;
        this.curr = n;
        this.possibleChange(this.prev, this.curr, 512);
        return this.prev;
    }

    public final int setMousePressedInCloseButton(int n) {
        this.prev = this.mousePressedInCloseButtonIndex;
        this.mousePressedInCloseButtonIndex = n;
        this.curr = n;
        this.possibleChange(this.prev, this.curr, 8192);
        return this.prev;
    }

    public final int setSelected(int n) {
        this.prev = this.selectedIndex;
        this.selectedIndex = n;
        this.curr = n;
        this.possibleChange(this.prev, this.curr, 16);
        return this.prev;
    }

    public final boolean setMouseInTabsArea(boolean bl) {
        boolean bl2 = this.mouseInTabsArea;
        this.mouseInTabsArea = bl;
        this.possibleChange(bl2, bl, 4096);
        return bl2;
    }

    public final boolean setActive(boolean bl) {
        boolean bl2 = this.active;
        this.active = bl;
        this.possibleChange(bl2, bl, 32);
        return bl2;
    }

    protected void possibleChange(boolean bl, boolean bl2, int n) {
        this.lastChangeType = bl == bl2 ? 0 : Integer.MAX_VALUE;
        if (this.lastChangeType != 0) {
            this.lastAffected = Integer.MAX_VALUE;
            this.change(Integer.MAX_VALUE, Integer.MAX_VALUE, n, this.lastChangeType);
        }
    }

    protected void possibleChange(int n, int n2, int n3) {
        this.lastChangeType = n == n2 ? 0 : (n2 == -1 ? 2 : (n == -1 ? 3 : 1));
        if (this.lastChangeType != 0) {
            this.lastAffected = n2;
            this.change(n, n2, n3, this.lastChangeType);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append("TabState [lastTab=");
        stringBuffer.append(TabState.tabToString(this.prev));
        stringBuffer.append(" currTab=");
        stringBuffer.append(TabState.tabToString(this.curr));
        stringBuffer.append(" lastAffected=");
        stringBuffer.append(TabState.tabToString(this.lastAffected));
        stringBuffer.append(" lastChangeType=");
        stringBuffer.append(TabState.changeToString(this.lastChangeType));
        stringBuffer.append(" lastChange=");
        stringBuffer.append(TabState.stateToString(this.lastChange));
        stringBuffer.append(" <active=");
        stringBuffer.append(this.active);
        stringBuffer.append(" sel=");
        stringBuffer.append(TabState.tabToString(this.selectedIndex));
        stringBuffer.append(" mouse=");
        stringBuffer.append(TabState.tabToString(this.containsMouseIndex));
        stringBuffer.append(" inTabs=");
        stringBuffer.append(this.mouseInTabsArea);
        stringBuffer.append(" pressed=");
        stringBuffer.append(TabState.tabToString(this.pressedIndex));
        stringBuffer.append(" inCloseButton=");
        stringBuffer.append(TabState.tabToString(this.closeButtonContainsMouseIndex));
        stringBuffer.append(" pressedCloseButton=");
        stringBuffer.append(TabState.tabToString(this.mousePressedInCloseButtonIndex));
        stringBuffer.append(">]");
        return stringBuffer.toString();
    }

    protected void change(int n, int n2, int n3, int n4) {
        this.lastChange = n3;
        if (n4 == 2 && n2 != -1) {
            Thread.dumpStack();
        }
        if (n4 == 1) {
            this.maybeRepaint(n, n3);
        } else {
            if (n4 == 2) {
                this.maybeRepaint(n, n3);
                return;
            }
            if (n4 == Integer.MAX_VALUE) {
                this.repaintAllTabs();
                return;
            }
        }
        this.maybeRepaint(n2, n3);
    }

    protected void maybeRepaint(int n, int n2) {
        int n3 = this.getRepaintPolicy(n);
        boolean bl = false;
        switch (n2) {
            case 32: {
                boolean bl2 = bl = (n3 & 0x10) != 0;
                if ((n3 & 0x20) == 0) break;
                n2 = Integer.MAX_VALUE;
                bl = true;
                break;
            }
            case 4: {
                bl = (n3 & 1) != 0;
                break;
            }
            case 512: {
                bl = (n3 & 4) != 0;
                break;
            }
            case 4096: {
                bl = (n3 & 3) != 0;
                break;
            }
            case 8192: {
                bl = (n3 & 0x100) != 0;
                break;
            }
            case 8: {
                bl = (n3 & 8) != 0;
                break;
            }
            case 16: {
                boolean bl3 = bl = (n3 & 0x40) != 0;
                if ((n3 & 0x80) == 0) break;
                n2 = Integer.MAX_VALUE;
                bl = true;
            }
        }
        if (bl) {
            if (n2 == Integer.MAX_VALUE) {
                this.repaintAllTabs();
            } else {
                this.repaintAllTabs();
            }
        }
    }

    protected abstract void repaintAllTabs();

    static final String changeToString(int n) {
        switch (n) {
            case 0: {
                return "no change";
            }
            case 1: {
                return "tab to tab";
            }
            case 2: {
                return "tab to none";
            }
            case 3: {
                return "none to tab";
            }
            case 4: {
                return "tab to self";
            }
            case 0x7FFFFFFF: {
                return "all tabs";
            }
        }
        return "??? " + n;
    }

    static final String tabToString(int n) {
        if (n == Integer.MAX_VALUE) {
            return "all tabs";
        }
        if (n == -1) {
            return "none";
        }
        return Integer.toString(n);
    }

    static final String stateToString(int n) {
        String[] stringArray = new String[]{"clip right", "clip left", "armed", "pressed", "selected", "active", "not onscreen", "leftmost", "rightmost", "in closebutton", "before selected", "after selected", "mouse in tabs area", "mouse pressed in close button"};
        int[] nArray = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192};
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            if ((n & nArray[i]) == 0) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(stringArray[i]);
        }
        if (stringBuffer.length() == 0) {
            stringBuffer.append("no flags set");
        }
        stringBuffer.append("=");
        stringBuffer.append(n);
        return stringBuffer.toString();
    }

    public abstract int getRepaintPolicy(int var1);
}

