/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.plaf.util;

import java.awt.Color;
import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.StringTokenizer;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.DimensionUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.metal.MetalTheme;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.XMLReaderAdapter;

public class NbTheme
extends MetalTheme
implements DocumentHandler {
    private HashSet activeThemes = null;
    private boolean inActiveTheme = false;
    private UIDefaults defaults;
    Locator locator = null;

    public String getName() {
        return "NetBeans XML Theme";
    }

    public NbTheme() {
        NbTheme.initThemeDefaults();
        this.defaults = UIManager.getDefaults();
        this.parseTheme();
    }

    static void initThemeDefaults() {
        UIManager.put("primary1", new ColorUIResource(102, 102, 153));
        UIManager.put("primary2", new ColorUIResource(153, 153, 204));
        UIManager.put("primary3", new ColorUIResource(204, 204, 255));
        UIManager.put("secondary1", new ColorUIResource(102, 102, 102));
        UIManager.put("secondary2", new ColorUIResource(153, 153, 153));
        UIManager.put("secondary3", new ColorUIResource(204, 204, 204));
        UIManager.put("white", new ColorUIResource(255, 255, 255));
        UIManager.put("black", new ColorUIResource(0, 0, 0));
    }

    private void parseTheme() {
        try {
            URL uRL = (URL)UIManager.get("themeURL");
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setValidating(false);
            sAXParserFactory.setNamespaceAware(false);
            XMLReaderAdapter xMLReaderAdapter = new XMLReaderAdapter(sAXParserFactory.newSAXParser().getXMLReader());
            xMLReaderAdapter.setDocumentHandler(this);
            String string = uRL.toExternalForm();
            InputSource inputSource = new InputSource(string);
            xMLReaderAdapter.parse(inputSource);
            this.activeThemes = null;
            this.locator = null;
        }
        catch (IOException iOException) {
            System.err.println("IO exception reading theme file");
        }
        catch (SAXException sAXException) {
            System.err.println("Error parsing theme file " + (this.locator != null ? "line " + this.locator.getLineNumber() : ""));
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.err.println("Couldn't create XML parser for theme file");
        }
    }

    public void endDocument() throws SAXException {
    }

    public void startDocument() throws SAXException {
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        if (string.equals("themeset")) {
            String string2 = attributeList.getValue("active");
            if (string2 != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                this.activeThemes = new HashSet(stringTokenizer.countTokens() + 1);
                while (stringTokenizer.hasMoreTokens()) {
                    this.activeThemes.add(stringTokenizer.nextToken().trim());
                }
            }
        } else if (string.equals("theme") && this.activeThemes != null) {
            String string3 = attributeList.getValue("name");
            this.inActiveTheme = this.activeThemes.contains(string3);
        } else if (this.inActiveTheme) {
            if (string.equals("color")) {
                this.handleColor(attributeList);
                return;
            }
            if (string.equals("font")) {
                this.handleFont(attributeList);
                return;
            }
            if (string.equals("emptyborder")) {
                this.handleEmptyBorder(attributeList);
                return;
            }
            if (string.equals("metric")) {
                this.handleMetric(attributeList);
                return;
            }
            if (string.equals("string")) {
                this.handleString(attributeList);
                return;
            }
            if (string.equals("insets")) {
                this.handleInsets(attributeList);
                return;
            }
            if (string.equals("boolean")) {
                this.handleBool(attributeList);
                return;
            }
            if (string.equals("dimension")) {
                this.handleDim(attributeList);
                return;
            }
            if (string.equals("etchedborder")) {
                this.handleEtchedBorder(attributeList);
                return;
            }
            if (string.equals("lineborder")) {
                this.handleLineBorder(attributeList);
                return;
            }
            if (string.equals("bevelborder")) {
                this.handleBevelBorder(attributeList);
                return;
            }
            System.err.println("UNRECOGNIZED THEME ENTRY " + string + "\" " + attributeList.toString());
        }
    }

    private final void handleFont(AttributeList attributeList) throws SAXException {
        String string = attributeList.getValue("key");
        String string2 = attributeList.getValue("name");
        String string3 = attributeList.getValue("style");
        int n = this.intFromAttr(attributeList, "size");
        int n2 = 0;
        if (string3.equals("bold")) {
            n2 = 1;
        } else if (string3.equals("italic")) {
            n2 = 2;
        }
        FontUIResource fontUIResource = new FontUIResource(string2, n2, n);
        UIManager.put(string, fontUIResource);
    }

    private final void handleColor(AttributeList attributeList) throws SAXException {
        int n = this.intFromAttr(attributeList, "r");
        int n2 = this.intFromAttr(attributeList, "g");
        int n3 = this.intFromAttr(attributeList, "b");
        String string = attributeList.getValue("key");
        ColorUIResource colorUIResource = new ColorUIResource(n, n2, n3);
        UIManager.put(string, colorUIResource);
    }

    private final void handleMetric(AttributeList attributeList) throws SAXException {
        String string = attributeList.getValue("key");
        Integer n = Integer.valueOf(attributeList.getValue("value"));
        UIManager.put(string, n);
    }

    private final void handleString(AttributeList attributeList) throws SAXException {
        String string = attributeList.getValue("key");
        String string2 = attributeList.getValue("value");
        UIManager.put(string, string2);
    }

    private final void handleBool(AttributeList attributeList) throws SAXException {
        String string = attributeList.getValue("key");
        Boolean bl = Boolean.valueOf(string);
        UIManager.put(string, bl);
    }

    private final void handleDim(AttributeList attributeList) throws SAXException {
        String string = attributeList.getValue("key");
        int n = this.intFromAttr(attributeList, "width");
        int n2 = this.intFromAttr(attributeList, "height");
        DimensionUIResource dimensionUIResource = new DimensionUIResource(n, n2);
        UIManager.put(string, dimensionUIResource);
    }

    private final void handleInsets(AttributeList attributeList) throws SAXException {
        String string = attributeList.getValue("key");
        int n = this.intFromAttr(attributeList, "top");
        int n2 = this.intFromAttr(attributeList, "left");
        int n3 = this.intFromAttr(attributeList, "bottom");
        int n4 = this.intFromAttr(attributeList, "right");
        InsetsUIResource insetsUIResource = new InsetsUIResource(n, n2, n3, n4);
        UIManager.put(string, insetsUIResource);
    }

    private final void handleEtchedBorder(AttributeList attributeList) {
        String string = attributeList.getValue("key");
        int n = 1;
        String string2 = attributeList.getValue("type");
        if (string2 != null) {
            n = string2.equals("lowered") ? 1 : 0;
        }
        BorderUIResource.EtchedBorderUIResource etchedBorderUIResource = new BorderUIResource.EtchedBorderUIResource(n);
        UIManager.put(string, etchedBorderUIResource);
    }

    private final void handleBevelBorder(AttributeList attributeList) {
        String string = attributeList.getValue("key");
        int n = 1;
        String string2 = attributeList.getValue("type");
        if (string2 != null) {
            n = string2.equals("lowered") ? 1 : 0;
        }
        BorderUIResource.BevelBorderUIResource bevelBorderUIResource = new BorderUIResource.BevelBorderUIResource(n);
        UIManager.put(string, bevelBorderUIResource);
    }

    private final void handleEmptyBorder(AttributeList attributeList) throws SAXException {
        String string = attributeList.getValue("key");
        int n = this.intFromAttr(attributeList, "top");
        int n2 = this.intFromAttr(attributeList, "left");
        int n3 = this.intFromAttr(attributeList, "bottom");
        int n4 = this.intFromAttr(attributeList, "right");
        BorderUIResource.EmptyBorderUIResource emptyBorderUIResource = new BorderUIResource.EmptyBorderUIResource(n, n2, n3, n4);
        UIManager.put(string, emptyBorderUIResource);
    }

    private final void handleLineBorder(AttributeList attributeList) throws SAXException {
        String string = attributeList.getValue("key");
        int n = this.intFromAttr(attributeList, "r");
        int n2 = this.intFromAttr(attributeList, "g");
        int n3 = this.intFromAttr(attributeList, "b");
        int n4 = 1;
        if (attributeList.getValue("width") != null) {
            n4 = this.intFromAttr(attributeList, "width");
        }
        Color color = new Color(n, n2, n3);
        BorderUIResource.LineBorderUIResource lineBorderUIResource = new BorderUIResource.LineBorderUIResource(color);
        UIManager.put(string, lineBorderUIResource);
    }

    private final int intFromAttr(AttributeList attributeList, String string) throws SAXException {
        try {
            return Integer.valueOf(attributeList.getValue(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new SAXException(attributeList.getValue(string) + " is not an integer");
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void endElement(String string) throws SAXException {
        if (string.equals("theme")) {
            this.inActiveTheme = false;
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    public void processingInstruction(String string, String string2) throws SAXException {
    }

    private final ColorUIResource getColor(String string) {
        return (ColorUIResource)this.defaults.get(string);
    }

    private final FontUIResource getFont(String string) {
        return (FontUIResource)this.defaults.get(string);
    }

    public FontUIResource getControlTextFont() {
        return this.getFont("controlFont");
    }

    public FontUIResource getSystemTextFont() {
        return this.getFont("systemFont");
    }

    public FontUIResource getUserTextFont() {
        return this.getFont("userFont");
    }

    public FontUIResource getMenuTextFont() {
        return this.getFont("menuFont");
    }

    public FontUIResource getWindowTitleFont() {
        return this.getFont("windowTitleFont");
    }

    public FontUIResource getSubTextFont() {
        return this.getFont("subFont");
    }

    protected ColorUIResource getPrimary1() {
        return this.getColor("primary1");
    }

    protected ColorUIResource getPrimary2() {
        return this.getColor("primary2");
    }

    protected ColorUIResource getPrimary3() {
        return this.getColor("primary3");
    }

    protected ColorUIResource getSecondary1() {
        return this.getColor("secondary1");
    }

    protected ColorUIResource getSecondary2() {
        return this.getColor("secondary2");
    }

    protected ColorUIResource getSecondary3() {
        return this.getColor("secondary3");
    }

    protected ColorUIResource getWhite() {
        return this.getColor("white");
    }

    protected ColorUIResource getBlack() {
        return this.getColor("black");
    }
}

