/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.local;

import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.provider.AbstractFileNameParser;
import org.apache.commons.vfs.provider.UriParser;
import org.apache.commons.vfs.provider.VfsComponentContext;

public abstract class LocalFileNameParser
extends AbstractFileNameParser {
    public boolean isAbsoluteName(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        try {
            UriParser.fixSeparators(stringBuffer);
            this.extractRootPrefix(string, stringBuffer);
            return true;
        }
        catch (FileSystemException fileSystemException) {
            return false;
        }
    }

    protected abstract String extractRootPrefix(String var1, StringBuffer var2) throws FileSystemException;

    public FileName parseUri(VfsComponentContext vfsComponentContext, FileName fileName, String string) throws FileSystemException {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = UriParser.extractScheme(string, stringBuffer);
        if (string2 == null) {
            string2 = "file";
        }
        UriParser.canonicalizePath(stringBuffer, 0, stringBuffer.length(), this);
        UriParser.fixSeparators(stringBuffer);
        String string3 = this.extractRootPrefix(string, stringBuffer);
        FileType fileType = UriParser.normalisePath(stringBuffer);
        String string4 = stringBuffer.toString();
        return this.createFileName(string2, string3, string4, fileType);
    }

    protected abstract FileName createFileName(String var1, String var2, String var3, FileType var4);
}

