/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;

public class VFS {
    private static Boolean URI_STYLE = null;
    private static FileSystemManager instance;

    public static synchronized FileSystemManager getManager() throws FileSystemException {
        if (instance == null) {
            instance = VFS.createManager("org.apache.commons.vfs.impl.StandardFileSystemManager");
        }
        return instance;
    }

    private static FileSystemManager createManager(String string) throws FileSystemException {
        try {
            Class<?> clazz = Class.forName(string);
            FileSystemManager fileSystemManager = (FileSystemManager)clazz.newInstance();
            try {
                Method method = clazz.getMethod("init", null);
                method.invoke((Object)fileSystemManager, null);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            return fileSystemManager;
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new FileSystemException("vfs/create-manager.error", string, invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            throw new FileSystemException("vfs/create-manager.error", string, (Throwable)exception);
        }
    }

    public static boolean isUriStyle() {
        if (URI_STYLE == null) {
            URI_STYLE = Boolean.FALSE;
        }
        return URI_STYLE;
    }

    public static void setUriStyle(boolean bl) {
        if (URI_STYLE != null && URI_STYLE != bl) {
            throw new IllegalStateException("URI STYLE ALREADY SET TO");
        }
        URI_STYLE = bl ? Boolean.TRUE : Boolean.FALSE;
    }
}

