/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xpath.node;

import com.japisoft.xpath.FastVector;
import com.japisoft.xpath.Navigator;
import com.japisoft.xpath.NodeSet;
import com.japisoft.xpath.XPathContext;
import com.japisoft.xpath.node.AbstractNode;
import com.japisoft.xpath.node.Expr;
import com.japisoft.xpath.node.Predicate;

public class Node
extends Expr {
    private boolean attributeMode;
    private String namespacePrefix;
    private String name;
    private String axis;
    private String nodeType;
    private boolean fromRoot;

    public void setName(String string, String string2) {
        this.name = string;
        this.namespacePrefix = string2;
    }

    public void setAttributeMode(boolean bl) {
        this.attributeMode = bl;
    }

    public boolean isAttributeMode() {
        return this.attributeMode;
    }

    public String getName() {
        if (this.name == null) {
            this.name = "*";
        }
        return this.name;
    }

    public void setAxis(String string) {
        this.axis = string;
    }

    public boolean hasAxis() {
        return this.axis != null;
    }

    public String getAxis() {
        if (this.axis == null) {
            this.axis = "child";
        }
        return this.axis;
    }

    public void setType(String string) {
        this.nodeType = string;
    }

    public String getType() {
        if (this.nodeType == null) {
            this.nodeType = "node";
        }
        return this.nodeType;
    }

    public void addNode(AbstractNode abstractNode) {
        if (abstractNode instanceof Node) {
            if (this.getNodeCount() > 0 && this.getNodeAt(0) instanceof Node) {
                this.getNodeAt(0).addNode(abstractNode);
            } else if (this.getNodeCount() > 1 && this.getNodeAt(1) instanceof Node) {
                this.getNodeAt(1).addNode(abstractNode);
            } else {
                super.addNode(abstractNode);
            }
        } else {
            super.addNode(abstractNode);
        }
    }

    public void setFromRoot(boolean bl) {
        this.fromRoot = bl;
    }

    public boolean isFromRoot() {
        return this.fromRoot;
    }

    public String toString() {
        return this.name;
    }

    public Node getNextNodeLocation() {
        for (int i = 0; i < this.getNodeCount(); ++i) {
            AbstractNode abstractNode = this.getNodeAt(i);
            if (!(abstractNode instanceof Node)) continue;
            return (Node)abstractNode;
        }
        return null;
    }

    public Predicate[] getPredicates() {
        FastVector fastVector = null;
        for (int i = 0; i < this.getNodeCount(); ++i) {
            AbstractNode abstractNode = this.getNodeAt(i);
            if (!(abstractNode instanceof Predicate)) continue;
            if (fastVector == null) {
                fastVector = new FastVector();
            }
            fastVector.addElement(abstractNode);
        }
        if (fastVector == null) {
            return null;
        }
        Predicate[] predicateArray = new Predicate[fastVector.size()];
        for (int i = 0; i < fastVector.size(); ++i) {
            predicateArray[i] = (Predicate)fastVector.elementAt(i);
        }
        return predicateArray;
    }

    public Object eval(XPathContext xPathContext) {
        Object object;
        if (this.namespacePrefix != null && !xPathContext.hasNamespaceDeclaration(this.namespacePrefix)) {
            throw new RuntimeException("No namespace declaration for the prefix " + this.namespacePrefix);
        }
        Navigator navigator = xPathContext.getNavigator();
        if (this.isFromRoot()) {
            xPathContext.setContextNode(xPathContext.getNavigator().getDocumentRoot(xPathContext.getFirstNodeFromContext()));
            if (xPathContext.getContextSize() == 0) {
                throw new RuntimeException("No root node");
            }
            if (this.name == null && this.nodeType == null) {
                return xPathContext.getContextNodeSet();
            }
        }
        Predicate[] predicateArray = this.getPredicates();
        NodeSet nodeSet = xPathContext.getContextNodeSet();
        NodeSet nodeSet2 = new NodeSet();
        int n = 0;
        int n2 = xPathContext.getContextSize();
        if (xPathContext.isPredicateMode()) {
            n = xPathContext.getContextPosition();
            n2 = n + 1;
        }
        if (nodeSet.size() > 0) {
            object = null;
            if (this.namespacePrefix != null) {
                object = xPathContext.getNamespaceURI(this.namespacePrefix);
            }
            for (int i = n; i < n2; ++i) {
                Object object2;
                int n3;
                Object object3 = nodeSet.elementAt(i);
                NodeSet nodeSet3 = null;
                if (xPathContext.hasCache()) {
                    nodeSet3 = xPathContext.getNavigatorCacheValue(object3, this.getAxis(), this.getType(), this.getName(), (String)object);
                }
                if (nodeSet3 == null && (nodeSet3 = navigator.getNodes(object3, this.getAxis(), this.getType(), this.getName(), (String)object, this.attributeMode)) != null) {
                    xPathContext.setNavigatorCacheValue(object3, this.getAxis(), this.getType(), this.getName(), (String)object, nodeSet3);
                }
                if (nodeSet3 == null) continue;
                xPathContext.setContextNodeSet(nodeSet3);
                if (predicateArray != null && nodeSet3.size() > 0) {
                    for (n3 = 0; n3 < nodeSet3.size(); ++n3) {
                        object2 = xPathContext.clone(nodeSet3.get(n3));
                        ((XPathContext)object2).setContextPosition(n3);
                        boolean bl = true;
                        for (int j = 0; j < predicateArray.length; ++j) {
                            Predicate predicate = predicateArray[j];
                            Boolean bl2 = (Boolean)predicate.eval((XPathContext)object2);
                            if (bl2.booleanValue()) continue;
                            bl = false;
                            break;
                        }
                        if (!bl) continue;
                        nodeSet2.addNode(nodeSet3.get(n3));
                    }
                    continue;
                }
                for (n3 = 0; n3 < nodeSet3.size(); ++n3) {
                    object2 = nodeSet3.elementAt(n3);
                    xPathContext.setContextPosition(n3);
                    nodeSet2.addNode(object2);
                }
            }
        }
        xPathContext.setContextNodeSet(nodeSet2);
        if (nodeSet2.size() > 0) {
            object = this.getNextNodeLocation();
            if (object == null) {
                return nodeSet2;
            }
            return ((Node)object).eval(xPathContext);
        }
        return nodeSet2;
    }
}

