/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xmlpad.tree;

import com.japisoft.fastparser.node.SimpleNode;
import com.japisoft.fastparser.swing.SwingNode;
import com.japisoft.fastparser.tools.XMLToolkit;
import com.japisoft.framework.event.GlobalMouseAdapter;
import com.japisoft.framework.job.Job;
import com.japisoft.framework.job.JobManager;
import com.japisoft.framework.job.SwingEventSynchro;
import com.japisoft.xmlpad.SharedProperties;
import com.japisoft.xmlpad.XMLContainer;
import com.japisoft.xmlpad.action.ActionModel;
import com.japisoft.xmlpad.editor.StructureDamagedListener;
import com.japisoft.xmlpad.editor.XMLEditor;
import com.japisoft.xmlpad.tree.TreeErrorListener;
import com.japisoft.xmlpad.tree.TreeListeners;
import com.japisoft.xmlpad.tree.TreeState;
import com.japisoft.xmlpad.tree.parser.ParsingJob;
import com.japisoft.xmlpad.tree.renderer.FastTreeRenderer;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class TreeListeners
extends GlobalMouseAdapter
implements StructureDamagedListener,
TreeSelectionListener {
    private XMLContainer container;
    private ParsingJob parsingJob;
    private TreeErrorListener errorListener;
    private JTree treeDelegate;
    private boolean dispose = false;
    private JPopupMenu popupDD = null;
    private ActionCopy actionCopy = null;
    private ActionMove actionMove = null;
    private String errorMessage = null;
    private boolean popupEnabled = true;
    private Point lastMousePressed = null;
    private boolean notifiedErrorNonTemporary = false;
    private boolean disableHistory = false;
    private SimpleNode lastTreeLocation;
    private boolean locationUsed = true;
    TreeLocationJob tlJob = null;
    public static Class _parsingJobClass = ParsingJob.class;
    SimpleNode DDSource = null;
    SimpleNode DDTarget = null;
    private boolean copyMode = false;
    public static DataFlavor NODE_FLAVOR = new DataFlavor(SimpleNode.class, "Simple node");

    public TreeListeners(XMLContainer xMLContainer) {
        this.container = xMLContainer;
        this.parsingJob = new ParsingJob(xMLContainer, this);
    }

    public TreeListeners(XMLContainer xMLContainer, JTree jTree) {
        this(xMLContainer);
        this.treeDelegate = jTree;
    }

    public void dispose() {
        if (this.dispose) {
            return;
        }
        this.dispose = true;
        this.container.getUIAccessibility().getTree().removeMouseListener(this);
        this.container.getUIAccessibility().getTree().removeMouseMotionListener(this);
        this.container.getUIAccessibility().getTree().getSelectionModel().removeTreeSelectionListener(this);
        this.container = null;
        this.treeDelegate = null;
        this.parsingJob.disposeAll();
    }

    public TreeErrorListener getTreeErrorListener() {
        if (this.errorListener == null && this.getTree() != null) {
            this.errorListener = new TreeErrorListener(this.getTree());
        }
        return this.errorListener;
    }

    public void init() {
        this.getTree().getSelectionModel().addTreeSelectionListener(this);
        this.getTree().addMouseListener(this);
        this.getTree().addMouseMotionListener(this);
        this.getTree().setTransferHandler(new NodeDragDrop());
    }

    public JTree getTree() {
        if (this.treeDelegate != null) {
            return this.treeDelegate;
        }
        return this.container.getTree();
    }

    private XMLEditor getEditor() {
        return this.container.getEditor();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        TreePath treePath;
        if (SharedProperties.TOOLTIP_TREE && (treePath = this.getTree().getPathForLocation(mouseEvent.getX(), mouseEvent.getY())) != null && this.getTree().getCellRenderer() instanceof FastTreeRenderer) {
            FastTreeRenderer fastTreeRenderer = (FastTreeRenderer)this.getTree().getCellRenderer();
            SwingNode swingNode = (SwingNode)treePath.getLastPathComponent();
            String string = swingNode.errorMessage;
            if (string != null) {
                fastTreeRenderer.getInnerComponent().setToolTipText(string);
            } else {
                fastTreeRenderer.getInnerComponent().setToolTipText(this.getToolTipForNode(swingNode));
            }
        }
    }

    private String getToolTipForNode(SimpleNode simpleNode) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html><body>");
        if (simpleNode.getType() == 1) {
            stringBuffer.append("<b>");
            if (simpleNode.getNameSpacePrefix() != null) {
                stringBuffer.append(simpleNode.getNameSpacePrefix()).append(":");
            }
            stringBuffer.append(simpleNode.getContent());
            if (simpleNode.getNameSpaceURI() != null) {
                stringBuffer.append("<i> (").append(simpleNode.getNameSpaceURI()).append(") </i>");
            }
            stringBuffer.append("</b>");
            stringBuffer.append("<br>");
        }
        stringBuffer.append("Loc: <i>").append(simpleNode.getXPathLocation()).append("</i>");
        if (simpleNode.getType() == 0) {
            stringBuffer.append("<br><div style='width:300px'>").append(simpleNode.getNodeContent()).append("</div>");
        } else {
            if (simpleNode.getViewAttributeCount() > 0) {
                stringBuffer.append("<br>Attributes:");
            }
            for (int i = 0; i < simpleNode.getViewAttributeCount(); ++i) {
                stringBuffer.append("<br>");
                String string = simpleNode.getViewAttributeAt(i);
                String string2 = simpleNode.getAttribute(string);
                stringBuffer.append("-<b>").append(string).append("</b> ").append(string2);
            }
        }
        stringBuffer.append("</body></html>");
        return stringBuffer.toString();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        ToolTipManager.sharedInstance().registerComponent(this.getTree());
    }

    public void mouseExited(MouseEvent mouseEvent) {
        ToolTipManager.sharedInstance().unregisterComponent(this.getTree());
    }

    public void setPopupEnabled(boolean bl) {
        this.popupEnabled = bl;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        SimpleNode simpleNode;
        this.lastMousePressed = mouseEvent.getPoint();
        ActionModel.resetActionState(this.container);
        if (!this.container.hasFocus()) {
            return;
        }
        this.copyMode = (mouseEvent.getModifiers() & 2) != 0;
        TreePath treePath = this.getTree().getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath != null) {
            this.getTree().setSelectionPath(treePath);
        }
        if (this.popupEnabled && mouseEvent.isPopupTrigger() && this.container.isEditable()) {
            if (this.container.getCurrentTreePopup() != null) {
                this.container.getCurrentTreePopup().show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        } else if (treePath == null || (simpleNode = (SimpleNode)treePath.getLastPathComponent()).isRoot()) {
            // empty if block
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.mousePressed(mouseEvent);
    }

    public void notifiedErrorNonTemporary() {
        this.notifiedErrorNonTemporary = true;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (!this.container.hasFocus()) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (TreeListeners.this.getTree().getSelectionPath() != null) {
                    TreeListeners.this.selectNode(TreeListeners.this.getTree().getSelectionPath());
                }
            }
        });
    }

    public void selectNodeFromPath(String string) {
        SimpleNode simpleNode;
        SimpleNode simpleNode2;
        DefaultTreeModel defaultTreeModel;
        if (this.getTree().getModel() instanceof DefaultTreeModel && (defaultTreeModel = (DefaultTreeModel)this.getTree().getModel()).getRoot() instanceof SimpleNode && (simpleNode2 = (simpleNode = (SimpleNode)defaultTreeModel.getRoot()).getNodeForXPathLocation(string, true)) != null) {
            this.disableHistory = true;
            this.resetTreeLocation(simpleNode2);
            this.disableHistory = false;
        }
    }

    private void selectNode(TreePath treePath) {
        SimpleNode simpleNode = (SimpleNode)treePath.getLastPathComponent();
        if (simpleNode != null) {
            int n = simpleNode.getStartingLine();
            boolean bl = this.locationUsed;
            this.locationUsed = false;
            int n2 = simpleNode.getStartingOffset();
            this.container.updateNodeLocation(simpleNode);
            this.getEditor().setCaretPositionWithoutNotification(n2);
            this.getEditor().highlightLine(n);
            this.locationUsed = bl;
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (!this.disableHistory && this.container.getUIAccessibility().getTree().hasFocus()) {
            this.selectNode(treeSelectionEvent.getPath());
        }
    }

    public boolean isLocationLocked() {
        return this.parsingJob.isLocationLocked();
    }

    public void notifyStructureChanged() {
        if (this.getEditor() == null) {
            return;
        }
        JobManager.addJob(this.parsingJob);
    }

    public TreeState getState() {
        if (this.getTree() == null) {
            return null;
        }
        TreeState treeState = new TreeState();
        treeState.model = this.getTree().getModel();
        treeState.selected = this.getTree().getSelectionPath();
        treeState.expanded = false;
        if (treeState.selected != null) {
            treeState.expanded = this.getTree().isExpanded(treeState.selected);
        }
        return treeState;
    }

    public void setState(TreeState treeState) {
        if (this.getTree() != null && treeState.model != this.getTree().getModel()) {
            this.getTree().setModel(treeState.model);
            if (treeState.selected != null) {
                this.getTree().setSelectionPath(treeState.selected);
                if (treeState.expanded) {
                    this.getTree().expandPath(treeState.selected);
                }
            }
        }
    }

    public void resetTreeLocation(SimpleNode simpleNode) {
        if (!this.locationUsed) {
            return;
        }
        if (this.getTree() == null) {
            return;
        }
        if (this.tlJob == null) {
            this.tlJob = new TreeLocationJob();
        }
        this.tlJob.setContent(simpleNode);
        JobManager.addJob(this.tlJob);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertNodeInto(SimpleNode simpleNode, SimpleNode simpleNode2, boolean bl) {
        if (simpleNode == simpleNode2) {
            return;
        }
        SimpleNode simpleNode3 = simpleNode2;
        while (simpleNode3 != null) {
            if ((simpleNode3 = simpleNode3.getSimpleParent()) != simpleNode) continue;
            return;
        }
        int n = simpleNode.getStartingOffset();
        int n2 = simpleNode.getStoppingOffset();
        if (simpleNode.isText()) {
            --n2;
        }
        try {
            String string = this.container.getDocument().getText(n, n2 - n + 1);
            int n3 = simpleNode2.getStartingOffset();
            n3 = this.container.getText().indexOf(62, n3) + 1;
            if (simpleNode2.isClosedLeaf()) {
                this.container.getEditor().select(n3 - 2, n3);
                String string2 = "></" + simpleNode2.getContent() + ">";
                this.container.getEditor().replaceSelection(string2);
                if (n > --n3) {
                    n += 2 + simpleNode2.getContent().length();
                    n2 += 2 + simpleNode2.getContent().length();
                }
            }
            boolean bl2 = this.container.isRealTimeTreeOnTextChange();
            this.container.setRealTimeTreeOnTextChange(false);
            try {
                this.container.getDocument().insertString(n3, string, null);
                if (n3 < n) {
                    n += string.length();
                    n2 += string.length();
                }
                if (!bl) {
                    this.container.getDocument().remove(n, n2 - n + 1);
                }
            }
            finally {
                this.container.setRealTimeTreeOnTextChange(bl2);
            }
            this.notifyStructureChanged();
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.lastMousePressed.distance(mouseEvent.getPoint()) > 4.0) {
            this.getTree().getTransferHandler().exportAsDrag(this.getTree(), mouseEvent, this.copyMode ? 1 : 2);
        }
    }

    class TransferableTreeNode
    implements Transferable {
        DataFlavor[] flavors = new DataFlavor[]{NODE_FLAVOR};
        SimpleNode node;

        public TransferableTreeNode(SimpleNode simpleNode) {
            this.node = simpleNode;
        }

        public synchronized DataFlavor[] getTransferDataFlavors() {
            return this.flavors;
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return dataFlavor.getRepresentationClass() == SimpleNode.class;
        }

        public synchronized Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (this.isDataFlavorSupported(dataFlavor)) {
                return this.node;
            }
            throw new UnsupportedFlavorException(dataFlavor);
        }
    }

    class NodeDragDrop
    extends TransferHandler {
        NodeDragDrop() {
        }

        protected Transferable createTransferable(JComponent jComponent) {
            TreePath treePath = TreeListeners.this.getTree().getSelectionPath();
            return new TransferableTreeNode((SimpleNode)treePath.getLastPathComponent());
        }

        public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                if (dataFlavorArray[i].getRepresentationClass() != SimpleNode.class) continue;
                return true;
            }
            return false;
        }

        public void exportAsDrag(JComponent jComponent, InputEvent inputEvent, int n) {
            TreePath treePath = TreeListeners.this.getTree().getSelectionPath();
            if (!((SimpleNode)treePath.getLastPathComponent()).isRoot()) {
                super.exportAsDrag(jComponent, inputEvent, n);
            }
        }

        public boolean importData(JComponent jComponent, Transferable transferable) {
            try {
                TreePath treePath = TreeListeners.this.getTree().getSelectionPath();
                if (treePath != null) {
                    TreeListeners.this.insertNodeInto((SimpleNode)transferable.getTransferData(NODE_FLAVOR), (SimpleNode)treePath.getLastPathComponent(), TreeListeners.this.copyMode);
                }
                return super.importData(jComponent, transferable);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                return false;
            }
            catch (IOException iOException) {
                return false;
            }
        }

        public int getSourceActions(JComponent jComponent) {
            return TreeListeners.this.copyMode ? 1 : 2;
        }
    }

    class TreeLocationJob
    implements Job,
    SwingEventSynchro {
        private SimpleNode content = null;
        private TreePath tp = null;

        TreeLocationJob() {
        }

        public void stopIt() {
        }

        public void dispose() {
            this.content = null;
            this.tp = null;
        }

        public Object getSource() {
            return TreeListeners.this.container;
        }

        public boolean isAlone() {
            return true;
        }

        public void setContent(SimpleNode simpleNode) {
            this.content = simpleNode;
        }

        public boolean preRun() {
            if (this.content == null) {
                return false;
            }
            this.tp = XMLToolkit.getTreePath(this.content);
            return true;
        }

        public void run() {
            try {
                TreeListeners.this.getTree().setSelectionPath(this.tp);
                TreeListeners.this.getTree().scrollPathToVisible(this.tp);
                TreeListeners.this.lastTreeLocation = this.content;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

