/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xmlpad.editor;

import com.japisoft.xmlpad.editor.UnknownEntity;
import java.util.Hashtable;

public class XMLEntityResolver
extends Hashtable {
    public static String LT_ENTITY = "lt";
    public static String GT_ENTITY = "gt";
    public static String QUOTE_ENTITY = "quote";
    public static String AMP_ENTITY = "amp";
    private TemporaryCharacter tc = new TemporaryCharacter();
    private Hashtable htEntityValue = null;

    public XMLEntityResolver() {
        this.setEnableDefaultXMLEntities(true);
    }

    public void setEnableDefaultXMLEntities(boolean bl) {
        if (bl) {
            this.storeEntityValue('<', LT_ENTITY);
            this.storeEntityValue('>', GT_ENTITY);
            this.storeEntityValue('\"', QUOTE_ENTITY);
            this.storeEntityValue('&', AMP_ENTITY);
        } else {
            this.removeEntityValue('<');
            this.removeEntityValue('>');
            this.removeEntityValue('\"');
            this.removeEntityValue('&');
        }
    }

    public void storeEntityValue(char c, String string) {
        this.put(new TemporaryCharacter(c), string);
        this.storeEntity(string, c);
    }

    public void removeEntityValue(char c) {
        TemporaryCharacter temporaryCharacter = new TemporaryCharacter(c);
        String string = (String)this.get(temporaryCharacter);
        if (string != null) {
            this.remove(temporaryCharacter);
            this.removeEntity(string);
        }
    }

    public String getEntityValue(char c) {
        this.tc.setValue(c);
        return (String)this.get(this.tc);
    }

    public boolean hasEntityValue(char c) {
        return this.getEntityValue(c) != null;
    }

    public void storeEntity(String string, char c) {
        if (this.htEntityValue == null) {
            this.htEntityValue = new Hashtable();
        }
        this.htEntityValue.put(string, new TemporaryCharacter(c));
    }

    public void removeEntity(String string) {
        if (this.htEntityValue == null) {
            return;
        }
        this.htEntityValue.remove(string);
    }

    public char getEntityResolution(String string) throws UnknownEntity {
        if (this.htEntityValue == null) {
            throw new UnknownEntity();
        }
        TemporaryCharacter temporaryCharacter = (TemporaryCharacter)this.htEntityValue.get(string);
        if (temporaryCharacter == null) {
            throw new UnknownEntity();
        }
        return temporaryCharacter.getValue();
    }

    public class TemporaryCharacter {
        private char value;

        public TemporaryCharacter(char c) {
            this.setValue(c);
        }

        public void setValue(char c) {
            this.value = c;
        }

        public char getValue() {
            return this.value;
        }

        public TemporaryCharacter() {
        }

        public boolean equals(Object object) {
            if (object instanceof TemporaryCharacter) {
                return ((TemporaryCharacter)object).hashCode() == this.hashCode();
            }
            return super.equals(object);
        }

        public int hashCode() {
            return this.value;
        }
    }
}

