/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xmlpad.editor;

import com.japisoft.fastparser.node.SimpleNode;
import com.japisoft.fastparser.tools.XMLToolkit;
import com.japisoft.xmlpad.SharedProperties;
import com.japisoft.xmlpad.XMLContainer;
import com.japisoft.xmlpad.editor.StructureDamagedListener;
import com.japisoft.xmlpad.editor.XMLEditor;
import com.japisoft.xmlpad.editor.XMLEditorKit;
import com.japisoft.xmlpad.editor.XMLTextView;
import com.japisoft.xmlpad.editor.XMLView;
import com.japisoft.xmlpad.helper.model.SchemaLocator;
import java.awt.Point;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.PlainDocument;
import javax.swing.text.Segment;
import org.xml.sax.InputSource;

public class XMLDocument
extends PlainDocument {
    private XMLEditor editor;
    private StructureDamagedListener listener;
    private boolean structureDamagedSupport = true;
    private boolean autoClose = true;
    private boolean syntaxPopup = true;
    private StringBuffer bufferHelper = null;
    private boolean completionMode = false;
    private boolean forceLocation = false;
    Point lastDTDLocation = null;

    public XMLDocument(XMLEditor xMLEditor) {
        this.addDocumentListener(new XMLDocumentListener());
        this.editor = xMLEditor;
    }

    public XMLEditor getCurrentEditor() {
        return this.editor.getXMLContainer().getEditor();
    }

    public void setEditor(XMLEditor xMLEditor) {
        this.editor = xMLEditor;
    }

    public XMLContainer getContainer() {
        return this.editor.getXMLContainer();
    }

    protected void structureDamaged() {
        if (!this.structureDamagedSupport) {
            return;
        }
        if (this.listener != null) {
            this.listener.notifyStructureChanged();
        }
        if (this.editor.getXMLContainer().getTreeListeners() != null) {
            this.editor.getXMLContainer().getTreeListeners().notifyStructureChanged();
        }
    }

    public void setStructureDamagedListener(StructureDamagedListener structureDamagedListener) {
        this.listener = structureDamagedListener;
    }

    public boolean isInsideComment(int n) {
        int n2 = this.getDefaultRootElement().getElementIndex(n);
        Element element = this.getDefaultRootElement().getElement(n2);
        int n3 = element.getStartOffset();
        int n4 = element.getEndOffset();
        int n5 = n - n3;
        try {
            String string = this.getText(n3, n4 - n3);
            int n6 = string.indexOf("<!--");
            int n7 = string.indexOf("-->");
            if (n7 > -1) {
                n7 += 3;
            }
            if (n5 > n6 && n5 < n7) {
                return true;
            }
            if (n5 > n6 && n7 == -1 && n6 != -1) {
                return true;
            }
            if (n5 < n7 && n6 == -1 && n7 != -1) {
                return true;
            }
            if (n6 == n7 && n6 == -1 && this.editor.getEditorKit() instanceof XMLEditorKit) {
                XMLEditorKit xMLEditorKit = (XMLEditorKit)this.editor.getEditorKit();
                if (xMLEditorKit.lastView instanceof XMLTextView) {
                    XMLTextView xMLTextView = (XMLTextView)xMLEditorKit.lastView;
                    if (xMLTextView == null || xMLTextView.lp == null) {
                        return false;
                    }
                    return xMLTextView.lp.getLastType(n2) == 1;
                }
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return false;
    }

    public boolean isInsideCDATA(int n) {
        int n2 = this.getDefaultRootElement().getElementIndex(n);
        Element element = this.getDefaultRootElement().getElement(n2);
        int n3 = element.getStartOffset();
        int n4 = element.getEndOffset();
        int n5 = n - n3;
        try {
            String string = this.getText(n3, n4 - n3);
            int n6 = string.indexOf("<![CDATA[");
            int n7 = string.indexOf("]]>");
            if (n7 > -1) {
                n7 += 3;
            }
            if (n5 > n6 && n5 < n7) {
                return true;
            }
            if (n5 > n6 && n7 == -1 && n6 != -1) {
                return true;
            }
            if (n5 < n7 && n6 == -1 && n7 != -1) {
                return true;
            }
            if (n6 == n7 && n6 == -1 && this.editor.getEditorKit() instanceof XMLEditorKit) {
                XMLEditorKit xMLEditorKit = (XMLEditorKit)this.editor.getEditorKit();
                if (xMLEditorKit.lastView instanceof XMLView) {
                    XMLView xMLView = (XMLView)xMLEditorKit.lastView;
                    return xMLView.lp.getLastType(n2) == 14;
                }
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return false;
    }

    public int nextTag(int n) {
        try {
            String string = this.getText(n, this.getLength());
            byte[] byArray = string.getBytes();
            for (int i = 0; i < byArray.length; ++i) {
                if (byArray[i] != 60 || i + 1 >= byArray.length || byArray[i + 1] == 33 || byArray[i + 1] == 63) continue;
                return i;
            }
            return byArray.length - 1;
        }
        catch (BadLocationException badLocationException) {
            return n;
        }
    }

    public String getWordAt(int n) {
        Element element = this.getDefaultRootElement();
        int n2 = element.getElementIndex(n);
        element = element.getElement(n2);
        try {
            String string = this.getText(element.getStartOffset(), element.getEndOffset() - element.getStartOffset() + 1);
            int n3 = n - element.getStartOffset();
            int n4 = 0;
            int n5 = 0;
            int n6 = -1;
            int n7 = -1;
            for (n4 = n3; n4 >= 0; --n4) {
                if (Character.isSpaceChar(string.charAt(n4)) && n6 == -1) {
                    n6 = n4 + 1;
                }
                if (string.charAt(n4) != '\'' && string.charAt(n4) != '\"') continue;
                ++n4;
                break;
            }
            if (n4 == -1) {
                n4 = n6;
            }
            for (n5 = n3; n5 < string.length(); ++n5) {
                if (Character.isSpaceChar(string.charAt(n5)) && n7 == -1) {
                    n7 = n5 - 1;
                }
                if (string.charAt(n5) != '\'' && string.charAt(n5) != '\"') continue;
                --n5;
                break;
            }
            if (n5 == string.length()) {
                n5 = n7;
            }
            if (n5 > n4 && n4 != -1) {
                return string.substring(n4, n5 + 1);
            }
            return null;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public String getForwardAttributeName(XMLDocument xMLDocument, int n) {
        try {
            StringBuffer stringBuffer = null;
            for (int i = n; i > 0; --i) {
                char c = xMLDocument.getText(i, 1).charAt(0);
                if (c == '=') {
                    stringBuffer = new StringBuffer();
                    continue;
                }
                if (c == '<') {
                    return null;
                }
                if (stringBuffer == null) continue;
                if (c == ' ' || c == '\t' || c == '\n') break;
                stringBuffer.insert(0, c);
            }
            if (stringBuffer != null) {
                return stringBuffer.toString();
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return null;
    }

    public SimpleNode getXMLPath(int n) {
        if (this.getContainer().getTree() != null) {
            Object object = this.getContainer().getTree().getModel().getRoot();
            if (object instanceof SimpleNode) {
                return XMLToolkit.getNodeForOffset(((SimpleNode)object).getDocument(), n);
            }
        } else if (this.getContainer().getRootNode() != null) {
            return XMLToolkit.getNodeForOffset(this.getContainer().getRootNode().getDocument(), n);
        }
        return null;
    }

    public void enableStructureDamagedSupport(boolean bl) {
        this.structureDamagedSupport = bl;
    }

    public boolean isEnableStructureDamagedSupport() {
        return this.structureDamagedSupport;
    }

    public void setAutoCloseTag(boolean bl) {
        this.autoClose = bl;
    }

    public boolean isAutoCloseTag() {
        return this.autoClose;
    }

    public void setSyntaxPopup(boolean bl) {
        this.syntaxPopup = bl;
    }

    public boolean isSyntaxPopup() {
        return this.syntaxPopup;
    }

    public int[] getAttributeValueLocation(int n) {
        try {
            String string;
            String string2;
            int n2;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            char c = '\u0000';
            for (n2 = n; n2 < this.getLength(); ++n2) {
                string2 = this.getText(n2, 1);
                if ("'".equals(string2) || "\"".equals(string2)) {
                    string = this.getText(n2 + 1, 1);
                    if (!" ".equals(string) && !"\t".equals(string) && !">".equals(string) && !"/".equals(string)) continue;
                    n4 = n2;
                    c = string2.charAt(0);
                    break;
                }
                if (">".equals(string2) || "=".equals(string2) && ("'".equals(string = this.getText(n2 + 1, 1)) || "\"".equals(string))) break;
            }
            for (n2 = n - 1; n2 > 0; --n2) {
                string2 = this.getText(n2, 1);
                if ("'".equals(string2) || "\"".equals(string2)) {
                    string = this.getText(n2 - 1, 1);
                    if (!"=".equals(string)) continue;
                    n3 = n2;
                    n5 = string2.charAt(0);
                    break;
                }
                if ("<".equals(string2)) break;
            }
            if (n3 > 0 && n4 > 0) {
                return new int[]{n3, n4, n5, c};
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return null;
    }

    public boolean isInProlog(int n) {
        if (this.getContainer().getRootNode() == null) {
            return true;
        }
        return this.getContainer().getRootNode().getStartingOffset() >= n;
    }

    public boolean isInsideAttributeValue(int n) {
        return this.getAttributeValueLocation(n) != null;
    }

    public boolean isInsideTagExceptAttributeValue(int n) {
        return this.isInsideTag(n, true, true);
    }

    public boolean isInsideTag(int n) {
        return this.isInsideTag(n, false, false);
    }

    public boolean isInsideTag(int n, boolean bl, boolean bl2) {
        return this.isInsideTag(n, bl, bl2, true);
    }

    boolean isInsideTag(int n, boolean bl, boolean bl2, boolean bl3) {
        int n2 = 0;
        Element element = null;
        if (bl && this.isInsideAttributeValue(n)) {
            return false;
        }
        try {
            element = this.getDefaultRootElement();
            n2 = element.getElementIndex(n);
            Element element2 = element.getElement(n2);
            int n3 = element2.getStartOffset();
            int n4 = element2.getEndOffset();
            if (bl3) {
                n3 = Math.max(0, n3 - 300);
            }
            String string = this.getText(n3, n4 - n3);
            int n5 = n - n3 - 1;
            int n6 = 0;
            int n7 = 32;
            int n8 = 32;
            for (int i = n5; i >= 0; --i) {
                n7 = n8;
                n8 = string.charAt(i);
                if (n8 == 60) {
                    if (n7 == 63) {
                        return false;
                    }
                    if (n7 == 33) {
                        return false;
                    }
                    return n7 != 47 || !bl2;
                }
                if (n8 == 62) {
                    return false;
                }
                if (n8 != 39 && n8 != 34) continue;
                ++n6;
            }
        }
        catch (BadLocationException badLocationException) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public Integer[] getCommentDelimiters(int n) {
        try {
            String string = this.getText(0, this.getLength());
            byte[] byArray = string.getBytes();
            if (n >= byArray.length) {
                return null;
            }
            for (int i = n - 2; i >= 0; --i) {
                if (byArray[i] != 60 || byArray[i + 1] != 33 || byArray[i + 2] != 45) continue;
                int n2 = n;
                while (n2 + 2 <= byArray.length) {
                    if (byArray[n2] == 45 && byArray[n2 + 1] == 45 && byArray[n2 + 2] == 62) {
                        return new Integer[]{new Integer(i), new Integer(n2 + 2)};
                    }
                    ++n2;
                }
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return null;
    }

    public void resetCompletionMode(boolean bl) {
        if (!bl) {
            this.bufferHelper = null;
            this.completionMode = false;
        } else {
            this.editor.setEnabledXPathLocation(false);
            this.completionMode = true;
            this.bufferHelper = new StringBuffer();
        }
    }

    public StringBuffer getCompletionBuffer() {
        return this.bufferHelper;
    }

    public boolean manageCompletion(boolean bl, int n, String string) {
        return this.editor.getXMLContainer().getHelperManager().activateContentAssistant(this.getContainer().getCurrentElementNode(), null, bl, n, string);
    }

    public boolean manageCompletion(SimpleNode simpleNode, boolean bl, int n, String string) {
        return this.editor.getXMLContainer().getHelperManager().activateContentAssistant(simpleNode, null, bl, n, string);
    }

    public void insertStringWithoutStructureDamaged(int n, String string, AttributeSet attributeSet) {
        try {
            super.insertString(n, string, attributeSet);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void insertStringWithoutHelper(int n, String string, AttributeSet attributeSet) {
        try {
            super.insertString(n, string, attributeSet);
            this.structureDamaged();
            this.getCurrentEditor().getXMLContainer().setModifiedState(true);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void insertStringWithoutHelper(int n, String string, AttributeSet attributeSet, boolean bl) {
        this.insertStringWithoutHelper(n, string, attributeSet);
        if (bl) {
            this.getCurrentEditor().setCaretPositionWithoutNotification(n + string.length());
        }
    }

    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        String string2;
        if (!this.getCurrentEditor().getXMLContainer().isEditableDocumentMode()) {
            return;
        }
        if (this.getCurrentEditor().getXMLContainer().getDocumentIntegrity().isProtectTag() && this.isInsideTag(n, false, false)) {
            return;
        }
        if (this.completionMode) {
            if (this.bufferHelper == null) {
                this.bufferHelper = new StringBuffer();
            }
            this.bufferHelper.append(string);
        } else if (this.syntaxPopup && this.manageCompletion(false, n, string)) {
            return;
        }
        super.insertString(n, string, attributeSet);
        boolean bl = false;
        if (string.endsWith("\n") || this.getContainer().isRealTimeTreeOnTextChange()) {
            bl = true;
        }
        if ("\n".equals(string) && (string2 = this.getIndentAtOffset(n)) != null) {
            super.insertString(n + 1, string2, attributeSet);
        }
        if (this.isAutoCloseTag() && ">".equals(string)) {
            bl = this.manageAutoClose(n, attributeSet);
        }
        if (bl && !"<".equals(string)) {
            this.structureDamaged();
        }
        this.editor.getXMLContainer().setModifiedState(true);
    }

    private boolean manageAutoClose(int n, AttributeSet attributeSet) throws BadLocationException {
        char c;
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = n - 1; i >= 0 && ((c = this.getText(i, 1).charAt(0)) != '/' || i != n - 1) && c != '>'; --i) {
            if (c == ' ' || c == '\t' || c == '\n') {
                stringBuffer = new StringBuffer();
                continue;
            }
            if (c == '<') {
                String string;
                char c2 = this.getText(i + 1, 1).charAt(0);
                if (c2 == '!' || c2 == '?' || c2 == '/' || (string = stringBuffer.toString()).length() <= 0 || this.hasNextClosingTag(n, string)) break;
                super.insertString(n + 1, this.getClosingTagPart(this.getIndentAtOffset(n), string), attributeSet);
                bl = true;
                this.forceLocation = true;
                this.getContainer().getEditor().setCaretPosition(n + 1);
                break;
            }
            stringBuffer.insert(0, c);
        }
        return bl;
    }

    public String getPreviousOpeningTagInsideATagPartWithoutPrefix(int n) throws BadLocationException {
        String string = this.getPreviousOpeningTagInsideATagPart(n);
        if (string != null) {
            int n2 = string.indexOf(":");
            if (n2 > -1) {
                return string.substring(n2 + 1);
            }
            return string;
        }
        return null;
    }

    public String getPreviousOpeningTagInsideATagPart(int n) throws BadLocationException {
        StringBuffer stringBuffer = null;
        for (int i = n; i >= 0; --i) {
            char c = this.getText(i, 1).charAt(0);
            if (c == ' ' || c == '\t' || c == '\n') {
                stringBuffer = new StringBuffer();
                continue;
            }
            if (c == '<') {
                return stringBuffer.toString();
            }
            if (stringBuffer == null) continue;
            stringBuffer.insert(0, c);
        }
        if (stringBuffer == null) {
            return null;
        }
        return stringBuffer.toString();
    }

    public String getPreviousOpeningTag(int n) throws BadLocationException {
        StringBuffer stringBuffer = null;
        for (int i = n; i >= 0; --i) {
            char c = this.getText(i, 1).charAt(0);
            if (c == '>') {
                stringBuffer = new StringBuffer();
                continue;
            }
            if (c == '<') {
                if (stringBuffer == null) {
                    return null;
                }
                String string = stringBuffer.toString();
                if (string.startsWith("/") || string.endsWith("/")) {
                    return null;
                }
                return string;
            }
            if (stringBuffer == null) continue;
            if (c == ' ' || c == '\t' || c == '\n') {
                if (stringBuffer.toString().endsWith("/")) {
                    return null;
                }
                stringBuffer = new StringBuffer();
                continue;
            }
            stringBuffer.insert(0, c);
        }
        return null;
    }

    private boolean hasNextClosingTag(int n, String string) throws BadLocationException {
        StringBuffer stringBuffer = null;
        for (int i = n; i < this.getLength(); ++i) {
            char c = this.getText(i, 1).charAt(0);
            if (c == '<') {
                if (stringBuffer != null) {
                    return false;
                }
                stringBuffer = new StringBuffer();
                continue;
            }
            if (c == '>') {
                if (stringBuffer == null || !stringBuffer.toString().equals("/" + string)) continue;
                return true;
            }
            if (stringBuffer == null) continue;
            stringBuffer.append(c);
        }
        return false;
    }

    public boolean forceLocation() {
        boolean bl = this.forceLocation;
        this.forceLocation = false;
        return bl;
    }

    public boolean parseSchema() {
        String string = "http://www.w3.org/2001/XMLSchema-instance";
        String string2 = "schemaLocation";
        String string3 = "noNamespaceSchemaLocation";
        try {
            for (int i = 0; i < this.getLength(); ++i) {
                int n;
                if (!"<".equals(this.getText(i, 1)) || this.getText(i + 1, 1).equals("!") || this.getText(i + 1, 1).equals("?")) continue;
                StringBuffer stringBuffer = new StringBuffer();
                String string4 = null;
                for (n = i + 1; n < this.getLength(); ++n) {
                    String string5 = this.getText(n, 1);
                    if (string4 == null && (" ".equals(string5) || "\t".equals(string5) || "\n".equals(string5))) {
                        string4 = stringBuffer.toString();
                    }
                    stringBuffer.append(string5);
                    if (">".equals(string5)) break;
                }
                if ((n = stringBuffer.indexOf(string)) > -1) {
                    String string6 = string2;
                    int n2 = stringBuffer.indexOf(string6);
                    if (n2 == -1) {
                        string6 = string3;
                        n2 = stringBuffer.indexOf(string6);
                    }
                    if (n2 > -1) {
                        for (int j = n2 + string6.length() + 1; j < stringBuffer.length(); ++j) {
                            if (stringBuffer.charAt(j) != '\"' && stringBuffer.charAt(j) != '\'') continue;
                            StringBuffer stringBuffer2 = new StringBuffer();
                            for (int k = j + 1; k < stringBuffer.length() && stringBuffer.charAt(k) != '\"' && stringBuffer.charAt(k) != '\''; ++k) {
                                stringBuffer2.append(stringBuffer.charAt(k));
                            }
                            if (stringBuffer2.length() <= 0) continue;
                            String string7 = stringBuffer2.toString();
                            ArrayList<String> arrayList = new ArrayList<String>();
                            ArrayList<String> arrayList2 = new ArrayList<String>();
                            String[] stringArray = new String[]{null};
                            String[] stringArray2 = new String[]{string7};
                            if (string6 == string2) {
                                int n3;
                                StringTokenizer stringTokenizer = new StringTokenizer(string7, " \t\n\r");
                                int n4 = 0;
                                while (stringTokenizer.hasMoreTokens()) {
                                    if (n4 % 2 == 0) {
                                        arrayList.add(stringTokenizer.nextToken());
                                    } else {
                                        arrayList2.add(stringTokenizer.nextToken());
                                    }
                                    ++n4;
                                }
                                stringArray = new String[arrayList.size()];
                                stringArray2 = new String[arrayList2.size()];
                                for (n3 = 0; n3 < arrayList.size(); ++n3) {
                                    stringArray[n3] = (String)arrayList.get(n3);
                                }
                                for (n3 = 0; n3 < arrayList2.size(); ++n3) {
                                    stringArray2[n3] = (String)arrayList2.get(n3);
                                }
                            }
                            int n5 = this.getDefaultRootElement().getElementIndex(n2 + string6.length() + 1);
                            this.getCurrentEditor().getXMLContainer().getSchemaAccessibility().setSchema(string4, stringArray, stringArray2, n5);
                            return true;
                        }
                    }
                }
                break;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.getCurrentEditor().getXMLContainer().getSchemaAccessibility().setSchema(null, null, null, -1);
        return false;
    }

    public boolean parseDTD() {
        int n;
        int n2;
        boolean bl;
        block16: {
            bl = false;
            n2 = 0;
            n = 0;
            try {
                String string = null;
                StringBuffer stringBuffer = null;
                for (int i = 0; i < this.getLength(); ++i) {
                    if (!"<".equals(this.getText(i, 1))) continue;
                    n2 = i;
                    boolean bl2 = "!".equals(this.getText(i + 1, 1));
                    if (bl2 && !"-".equals(this.getText(i + 2, 1))) {
                        block5: for (int j = i + 1; j < this.getLength(); ++j) {
                            String string2 = this.getText(j, 1);
                            if (!Character.isWhitespace(string2.charAt(0))) {
                                if (stringBuffer == null) {
                                    stringBuffer = new StringBuffer();
                                }
                                stringBuffer.append(string2);
                            } else if (stringBuffer != null) {
                                string = stringBuffer.toString();
                                stringBuffer = null;
                            }
                            if (">".equals(string2)) {
                                n = j;
                                this.parseDTDLine(i + 2, j - 1);
                                bl = true;
                                break block16;
                            }
                            if (!"[".equals(string2)) continue;
                            for (int k = j + 1; k < this.getLength(); ++k) {
                                if (!"]".equals(this.getText(k, 1))) continue;
                                String string3 = this.getText(j + 1, k - j - 1);
                                if (string3.indexOf("<!ELEMENT") <= -1) continue block5;
                                try {
                                    this.getCurrentEditor().getXMLContainer().getSchemaAccessibility().setDTD(string, new SchemaLocator(new StringReader(string3)));
                                }
                                catch (Exception exception) {
                                    System.err.println("Unknown ERROR : " + exception.getMessage());
                                }
                                return true;
                            }
                        }
                        continue;
                    }
                    if (bl2 || "?".equals(this.getText(i + 1, 1))) {
                        continue;
                    }
                    break;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        this.lastDTDLocation = null;
        if (!bl) {
            this.getCurrentEditor().getXMLContainer().getSchemaAccessibility().setDTD(null, null, -1);
        } else {
            this.lastDTDLocation = new Point(n2, n);
        }
        return bl;
    }

    public Point getLastDTDLocation() {
        return this.lastDTDLocation;
    }

    private void parseDTDLine(int n, int n2) {
        try {
            String string;
            String string2;
            block30: {
                String string3;
                StringTokenizer stringTokenizer;
                block31: {
                    String string4 = this.getText(n, n2 - n + 1);
                    stringTokenizer = new StringTokenizer(string4, " \t\n\r");
                    string2 = null;
                    string = null;
                    boolean bl = false;
                    if (!stringTokenizer.hasMoreTokens() || !"DOCTYPE".equals(string3 = stringTokenizer.nextToken()) || !stringTokenizer.hasMoreTokens()) break block30;
                    string2 = stringTokenizer.nextToken();
                    if (!stringTokenizer.hasMoreTokens()) break block30;
                    string3 = stringTokenizer.nextToken();
                    if (!"SYSTEM".equals(string3)) break block31;
                    if (!stringTokenizer.hasMoreTokens()) break block30;
                    StringBuffer stringBuffer = null;
                    boolean bl2 = false;
                    while (stringTokenizer.hasMoreTokens()) {
                        string3 = stringTokenizer.nextToken();
                        if (string3.startsWith("\"") || string3.endsWith("\"") || string3.startsWith("'") || string3.endsWith("'")) {
                            if (stringBuffer == null) {
                                stringBuffer = new StringBuffer();
                            } else {
                                stringBuffer.append(" ");
                            }
                            if (string3.length() > 2) {
                                if (string3.charAt(0) == '\"' || string3.charAt(0) == '\'') {
                                    string3 = string3.substring(1);
                                }
                                if (string3.charAt(string3.length() - 1) == '\"' || string3.charAt(string3.length() - 1) == '\'') {
                                    string3 = string3.substring(0, string3.length() - 1);
                                }
                                stringBuffer.append(string3);
                            }
                            if (bl2) break;
                            bl2 = true;
                            continue;
                        }
                        if (stringBuffer == null) {
                            stringBuffer = new StringBuffer();
                        } else {
                            stringBuffer.append(" ");
                        }
                        stringBuffer.append(string3);
                    }
                    if (stringBuffer != null) {
                        string = stringBuffer.toString();
                    }
                    break block30;
                }
                if ("PUBLIC".equals(string3)) {
                    String string5;
                    StringBuffer stringBuffer = new StringBuffer();
                    boolean bl = false;
                    while (stringTokenizer.hasMoreTokens()) {
                        string5 = stringTokenizer.nextToken();
                        stringBuffer.append(string5);
                        if (string5.startsWith("\"") || string5.startsWith("'")) {
                            bl = true;
                        }
                        if ((string5.endsWith("\"") || string5.endsWith("'")) && bl) break;
                        if (!bl) continue;
                        stringBuffer.append(" ");
                    }
                    if (bl) {
                        stringBuffer.deleteCharAt(0);
                        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                        string5 = stringBuffer.toString();
                        if (SharedProperties.DEFAULT_ENTITY_RESOLVER != null) {
                            try {
                                InputSource inputSource = SharedProperties.DEFAULT_ENTITY_RESOLVER.resolveEntity(string5, null);
                                if (inputSource != null) {
                                    SchemaLocator schemaLocator = null;
                                    if (inputSource.getCharacterStream() != null) {
                                        schemaLocator = new SchemaLocator(inputSource.getCharacterStream());
                                    } else if (inputSource.getByteStream() != null) {
                                        schemaLocator = new SchemaLocator(inputSource.getByteStream());
                                    } else if (inputSource.getSystemId() != null) {
                                        schemaLocator = new SchemaLocator(inputSource.getSystemId());
                                    }
                                    if (schemaLocator != null) {
                                        this.getCurrentEditor().getXMLContainer().getSchemaAccessibility().setDTD(string2, schemaLocator);
                                        return;
                                    }
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    if (stringTokenizer.hasMoreTokens()) {
                        while (stringTokenizer.hasMoreTokens()) {
                            string3 = stringTokenizer.nextToken();
                            if ((!string3.startsWith("\"") || !string3.endsWith("\"")) && (!string3.startsWith("'") || !string3.endsWith("'"))) continue;
                            string = string3.substring(1, string3.length() - 1);
                            break;
                        }
                    }
                }
            }
            int n3 = this.getDefaultRootElement().getElementIndex(n);
            if (string != null) {
                this.getCurrentEditor().getXMLContainer().getSchemaAccessibility().setDTD(string2, string, n3);
            } else {
                this.getCurrentEditor().getXMLContainer().getSchemaAccessibility().setDTD(null, null, -1);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public boolean isBetweenTagDelimiters(int n) {
        int n2 = this.getDefaultRootElement().getElementIndex(n);
        Element element = this.getDefaultRootElement().getElement(n2);
        int n3 = element.getStartOffset();
        int n4 = element.getEndOffset();
        boolean bl = true;
        int n5 = 0;
        try {
            for (int i = n3; i < n4; ++i) {
                if (!bl && "<".equals(this.getText(i, 1))) {
                    bl = true;
                    n5 = i;
                    continue;
                }
                if (!bl || !">".equals(this.getText(i, 1))) continue;
                if (n > n5 && n <= i) {
                    return true;
                }
                bl = false;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return false;
    }

    public boolean isInsideDTDElementDefinition(int n) {
        return this.isInsideDTDDefinition("<!ELEMENT", n);
    }

    public boolean isInsideDTDAttributeDefinition(int n) {
        return this.isInsideDTDDefinition("<!ATTLIST", n);
    }

    private boolean isInsideDTDDefinition(String string, int n) {
        try {
            int n2;
            boolean bl = false;
            for (n2 = n; n2 < this.getLength(); ++n2) {
                if ("<".equals(this.getText(n2, 1))) {
                    return false;
                }
                if (!">".equals(this.getText(n2, 1))) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return false;
            }
            for (n2 = n - 1; n2 > 0; --n2) {
                String string2;
                if (">".equals(this.getText(n2, 1))) {
                    return false;
                }
                if ("<".equals(this.getText(n2, 1))) {
                    return false;
                }
                if (n2 <= 9 || !string.equals(string2 = this.getText(n2 - 9, 9))) continue;
                return true;
            }
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
        return false;
    }

    public String getDTDElementDefinitionFor(int n) {
        String string = "<!ELEMENT ";
        int n2 = this.getDefaultRootElement().getElementIndex(n);
        Element element = this.getDefaultRootElement().getElement(n2);
        int n3 = element.getStartOffset();
        int n4 = element.getEndOffset();
        try {
            String string2 = this.getText(n3, n4 - n3 + 1);
            int n5 = string2.indexOf(string);
            if (n5 > -1) {
                string2 = string2.substring(n5 + string.length());
                int n6 = (string2 = string2.trim()).indexOf(" ");
                if (n6 > -1) {
                    return string2.substring(0, n6);
                }
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return null;
    }

    public String[] getElementsFromDTD() {
        int n;
        String[] stringArray;
        String string = "<!ELEMENT ";
        ArrayList<String> arrayList = null;
        try {
            stringArray = this.getText(0, this.getLength());
            n = 0;
            while (n != -1) {
                if ((n = stringArray.indexOf(string, n)) == -1) continue;
                StringBuffer stringBuffer = null;
                for (int i = n + string.length(); i < this.getLength(); ++i) {
                    if (!Character.isSpaceChar(stringArray.charAt(i))) {
                        if (stringBuffer == null) {
                            stringBuffer = new StringBuffer();
                        }
                        stringBuffer.append(stringArray.charAt(i));
                        continue;
                    }
                    if (stringBuffer != null) {
                        if (arrayList == null) {
                            arrayList = new ArrayList<String>();
                        }
                        arrayList.add(stringBuffer.toString());
                        break;
                    }
                    if (stringArray.charAt(i) == '>') break;
                }
                ++n;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        if (arrayList == null) {
            return null;
        }
        stringArray = new String[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            stringArray[n] = (String)arrayList.get(n);
        }
        return stringArray;
    }

    public void removeWithoutStructureDamaged(int n, int n2) {
        try {
            super.remove(n, n2);
            this.editor.getXMLContainer().setModifiedState(true);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void remove(int n, int n2) throws BadLocationException {
        if (!this.getCurrentEditor().getXMLContainer().isEditableDocumentMode()) {
            return;
        }
        if (this.getCurrentEditor().getXMLContainer().getDocumentIntegrity().isProtectTag() && this.isInsideTagExceptAttributeValue(n)) {
            return;
        }
        boolean bl = false;
        if (n2 > 0 && this.isEnableStructureDamagedSupport()) {
            String string = this.getText(n, n2);
            if (string.endsWith("\n") || this.getContainer().isRealTimeTreeOnTextChange()) {
                bl = true;
            }
            if (!bl) {
                for (int i = 0; i < string.length(); ++i) {
                    if (string.charAt(i) != '<') continue;
                    bl = true;
                    break;
                }
            }
        }
        super.remove(n, n2);
        if (bl) {
            this.structureDamaged();
        }
        this.editor.getXMLContainer().setModifiedState(true);
    }

    private String getClosingTagPart(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n");
        if (string != null) {
            stringBuffer.append(string);
        }
        stringBuffer.append("</");
        stringBuffer.append(string2);
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    private String getIndentAtOffset(int n) {
        try {
            char c;
            int n2;
            Element element = this.getDefaultRootElement();
            int n3 = element.getElementIndex(n);
            Element element2 = element.getElement(n3);
            int n4 = element2.getStartOffset();
            int n5 = element2.getEndOffset();
            String string = this.getText(n4, n5 - n4);
            int n6 = string.length();
            for (n2 = 0; n2 < n6 && (c = string.charAt(n2)) <= ' ' && c != '\n'; ++n2) {
            }
            if (n2 > 0) {
                return string.substring(0, n2);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return null;
    }

    private int getStartEndOffset(int n) throws BadLocationException {
        for (int i = Math.min(this.getLength() - 1, n); i > 0; --i) {
            if (!"<".equals(this.getText(i, 1))) continue;
            return i;
        }
        return 0;
    }

    private int getEndStartOffset(int n) throws BadLocationException {
        for (int i = n; i < this.getLength(); ++i) {
            if (!">".equals(this.getText(i, 1))) continue;
            return i;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point updateElement(String string, String string2, int n, int n2) {
        int n3;
        int n4;
        Point point;
        boolean bl;
        boolean bl2;
        block12: {
            bl2 = this.isEnableStructureDamagedSupport();
            bl = this.getCurrentEditor().isEnabledXPathLocation();
            this.enableStructureDamagedSupport(false);
            this.getCurrentEditor().setEnabledXPathLocation(false);
            point = null;
            n4 = 0;
            if (string2 != null) {
                n4 = this.getStartEndOffset(n2);
            }
            n3 = this.getEndStartOffset(n);
            if (n4 != -1 && n3 != -1) break block12;
            Point point2 = null;
            this.enableStructureDamagedSupport(bl2);
            this.getCurrentEditor().setEnabledXPathLocation(bl);
            this.getCurrentEditor().setDelayedStructureDamaged(true);
            return point2;
        }
        try {
            try {
                int n5;
                point = new Point(0, 0);
                if (string2 != null && n2 > 0) {
                    n5 = n2 - n4 + 1;
                    if (n5 + n4 > this.getLength()) {
                        n5 = this.getLength() - n4;
                    }
                    this.replace(n4, n5, string2, null);
                    int n6 = n4 + string2.length();
                    try {
                        for (int i = 0; i < 30 && !this.getText(i + n6, 1).equals("<"); ++i) {
                            if (!this.getText(i + n6, 1).equals(">")) continue;
                            this.replace(n6, i + 1, "", null);
                            break;
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
                n5 = n3 - n + 1;
                this.replace(n, n5, string, null);
                point.y = n4 - (n5 - string.length()) + (string2 != null ? string2.length() - 1 : 0);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            this.enableStructureDamagedSupport(bl2);
            this.getCurrentEditor().setEnabledXPathLocation(bl);
            this.getCurrentEditor().setDelayedStructureDamaged(true);
        }
        return point;
    }

    public void updateNode(SimpleNode simpleNode, String string) {
        int n = simpleNode.getStartingOffset();
        int n2 = simpleNode.getStoppingOffset();
        try {
            this.replace(n, n2 - n + 1, string, null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void updateNodeOpeningClosing(SimpleNode simpleNode) {
        String string;
        String string2;
        String string3 = null;
        String string4 = null;
        StringBuffer stringBuffer = new StringBuffer("<");
        if (simpleNode.getNameSpacePrefix() != null) {
            stringBuffer.append(simpleNode.getNameSpacePrefix()).append(":");
        }
        stringBuffer.append(simpleNode.getNodeContent());
        for (int i = 0; i < simpleNode.getViewAttributeCount(); ++i) {
            string2 = simpleNode.getViewAttributeAt(i);
            string = simpleNode.getAttribute(string2);
            stringBuffer.append(" ");
            stringBuffer.append(string2);
            stringBuffer.append("=\"");
            stringBuffer.append(XMLToolkit.resolveCharEntities(string));
            stringBuffer.append("\"");
        }
        Object object = simpleNode.getNamespaceDeclared();
        while (object != null && object.hasMoreElements()) {
            string2 = (String)object.nextElement();
            string = simpleNode.getNameSpaceDeclarationURI(string2);
            stringBuffer.append(" ");
            stringBuffer.append("xmlns:").append(string2);
            stringBuffer.append("=\"").append(string).append("\"");
        }
        if (simpleNode.getDefaultNamespace() != null) {
            stringBuffer.append(" ");
            stringBuffer.append("xmlns=\"").append(simpleNode.getDefaultNamespace()).append("\"");
        }
        if (simpleNode.isClosedLeaf()) {
            stringBuffer.append("/");
        }
        stringBuffer.append(">");
        string3 = stringBuffer.toString();
        if (!simpleNode.isClosedLeaf()) {
            object = new StringBuffer("</");
            if (simpleNode.getNameSpacePrefix() != null) {
                ((StringBuffer)object).append(simpleNode.getNameSpacePrefix()).append(":");
            }
            ((StringBuffer)object).append(simpleNode.getNodeContent());
            ((StringBuffer)object).append(">");
            string4 = ((StringBuffer)object).toString();
        }
        this.updateElement(string3, string4, simpleNode.getStartingOffset(), simpleNode.getStoppingOffset());
    }

    public class XMLDocumentListener
    implements DocumentListener {
        Segment line = new Segment();

        public void insertUpdate(DocumentEvent documentEvent) {
            this.notifiedChange();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.notifiedChange();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.notifiedChange();
        }

        private void notifiedChange() {
            XMLDocument.this.editor.notifyDocumentChanged();
            if (!XMLDocument.this.isEnableStructureDamagedSupport()) {
                return;
            }
            XMLDocument.this.structureDamaged();
        }
    }
}

