/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xmldiff.ui;

import com.japisoft.fastparser.Parser;
import com.japisoft.fastparser.node.SimpleNode;
import com.japisoft.fastparser.swing.SwingNodeFactory;
import com.japisoft.fastparser.tools.XMLToolkit;
import com.japisoft.framework.ui.text.FileTextField;
import com.japisoft.framework.ui.text.PathBuilder;
import com.japisoft.xmldiff.XMLDiff;
import com.japisoft.xmldiff.element.ModelElementDiff;
import com.japisoft.xmldiff.event.XMLDiffSelection;
import com.japisoft.xmldiff.ui.CustomTreeRenderer;
import com.japisoft.xmldiff.ui.ResourceFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileReader;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class XMLDiffPanel
extends JPanel
implements ActionListener,
TreeSelectionListener,
ListSelectionListener {
    JSplitPane mainSplitPane = new JSplitPane();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel panelLeft = new JPanel();
    JScrollPane spTable = new JScrollPane();
    JTable tableDiff = new JTable(){

        public TableCellRenderer getDefaultRenderer(Class clazz) {
            return new CustomTableCellRenderer();
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    };
    JPanel panelRight = new JPanel();
    Border border1;
    TitledBorder titledBorder1;
    Border border2;
    TitledBorder titledBorder2;
    TitledBorder titledBorder3;
    JLabel lblPathLeft = new JLabel();
    FileTextField tfPathLeft = new FileTextField(null, new String[]{"xml"});
    JScrollPane spLeft = new JScrollPane();
    JTree treeLeft = new JTree();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JLabel lblRight = new JLabel();
    FileTextField tfPathRight = new FileTextField(null, new String[]{"xml"});
    JScrollPane spRight = new JScrollPane();
    JTree treeRight = new JTree();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    XMLDiffSelection selection;
    private boolean disabledValueChanged = false;

    public XMLDiffPanel(PathBuilder pathBuilder) {
        try {
            this.jbInit();
            this.tfPathLeft.setPathBuilder(pathBuilder);
            this.tfPathRight.setPathBuilder(pathBuilder);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public XMLDiffPanel(TreeNode treeNode, String string, PathBuilder pathBuilder) {
        try {
            this.jbInit();
            this.tfPathLeft.setText(string);
            this.tfPathLeft.setPathBuilder(pathBuilder);
            this.tfPathRight.setPathBuilder(pathBuilder);
            this.updateTree(treeNode, this.treeLeft);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setXMLDiffSelection(XMLDiffSelection xMLDiffSelection) {
        this.selection = xMLDiffSelection;
    }

    public void addNotify() {
        super.addNotify();
        this.tfPathLeft.setActionListener(this);
        this.tfPathRight.setActionListener(this);
        this.treeLeft.getSelectionModel().addTreeSelectionListener(this);
        this.treeRight.getSelectionModel().addTreeSelectionListener(this);
        this.tableDiff.getSelectionModel().addListSelectionListener(this);
    }

    public void removeNotify() {
        super.removeNotify();
        this.tfPathLeft.setActionListener(null);
        this.tfPathRight.setActionListener(null);
        this.treeLeft.getSelectionModel().removeTreeSelectionListener(this);
        this.treeRight.getSelectionModel().removeTreeSelectionListener(this);
        this.tableDiff.getSelectionModel().removeListSelectionListener(this);
    }

    private void jbInit() throws Exception {
        this.border1 = BorderFactory.createEmptyBorder();
        this.titledBorder1 = new TitledBorder(BorderFactory.createLineBorder(Color.lightGray, 1), "XML Document");
        this.border2 = BorderFactory.createEmptyBorder();
        this.titledBorder2 = new TitledBorder(BorderFactory.createLineBorder(Color.lightGray, 1), "XML Document");
        this.titledBorder3 = new TitledBorder(BorderFactory.createLineBorder(new Color(153, 153, 153), 2), "Changes");
        this.setLayout(this.borderLayout1);
        this.mainSplitPane.setPreferredSize(new Dimension(135, 300));
        this.mainSplitPane.setDividerSize(10);
        this.mainSplitPane.setLastDividerLocation(150);
        this.mainSplitPane.setOneTouchExpandable(true);
        this.spTable.setBorder(this.titledBorder3);
        this.spTable.setOpaque(true);
        this.spTable.setPreferredSize(new Dimension(453, 200));
        this.panelLeft.setBorder(this.titledBorder1);
        this.panelLeft.setMinimumSize(new Dimension(0, 0));
        this.panelLeft.setPreferredSize(new Dimension(0, 0));
        this.panelLeft.setLayout(this.gridBagLayout1);
        this.panelRight.setLayout(this.gridBagLayout2);
        this.panelRight.setBorder(this.titledBorder2);
        this.panelRight.setDebugGraphicsOptions(0);
        this.panelRight.setMinimumSize(new Dimension(0, 0));
        this.panelRight.setPreferredSize(new Dimension(0, 0));
        this.lblPathLeft.setText("Path :");
        this.tfPathLeft.setText("");
        this.lblRight.setText("Path :");
        this.tfPathRight.setText("");
        this.add((Component)this.mainSplitPane, "Center");
        this.mainSplitPane.add((Component)this.panelLeft, "left");
        this.mainSplitPane.add((Component)this.panelRight, "right");
        this.add((Component)this.spTable, "South");
        this.spTable.getViewport().add((Component)this.tableDiff, null);
        this.panelLeft.add((Component)this.lblPathLeft, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.panelLeft.add((Component)this.tfPathLeft, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 39, 0, 2), 0, 0));
        this.panelLeft.add((Component)this.spLeft, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(11, 0, 2, 2), 298, -143));
        this.spLeft.getViewport().add((Component)this.treeLeft, null);
        this.panelRight.add((Component)this.lblRight, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 22, 0));
        this.panelRight.add((Component)this.tfPathRight, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 45, 0, 6), 0, 0));
        this.panelRight.add((Component)this.spRight, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(13, 0, 4, 6), 426, -147));
        this.spRight.getViewport().add((Component)this.treeRight, null);
        this.mainSplitPane.setDividerLocation(300);
        this.tableDiff.setSelectionMode(0);
        this.treeLeft.setModel(new DefaultTreeModel(new DefaultMutableTreeNode("Your document")));
        this.treeRight.setModel(new DefaultTreeModel(new DefaultMutableTreeNode("Your document")));
        CustomTreeRenderer customTreeRenderer = null;
        customTreeRenderer = new CustomTreeRenderer();
        this.treeLeft.setCellRenderer(customTreeRenderer);
        this.treeRight.setCellRenderer(customTreeRenderer);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.tfPathLeft) {
            this.updateTree(this.tfPathLeft.getText(), this.treeLeft);
        } else if (actionEvent.getSource() == this.tfPathRight) {
            this.updateTree(this.tfPathRight.getText(), this.treeRight);
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (treeSelectionEvent.getPath().getLastPathComponent() instanceof SimpleNode) {
            SimpleNode simpleNode = (SimpleNode)treeSelectionEvent.getPath().getLastPathComponent();
            ArrayList arrayList = (ArrayList)simpleNode.getApplicationObject();
            this.updateTable(arrayList);
            if (this.selection != null) {
                if (simpleNode.getDocument().getRoot() == this.treeLeft.getModel().getRoot()) {
                    this.selection.select(this.tfPathLeft.getText(), simpleNode);
                } else {
                    this.selection.select(this.tfPathRight.getText(), simpleNode);
                }
            }
        }
    }

    private void updateTable(ArrayList arrayList) {
        this.disabledValueChanged = true;
        DefaultTableModel defaultTableModel = new DefaultTableModel(new Object[]{"Change", "Content"}, 0);
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                ModelElementDiff modelElementDiff = (ModelElementDiff)arrayList.get(i);
                defaultTableModel.addRow(new Object[]{modelElementDiff, modelElementDiff});
            }
        }
        this.tableDiff.setModel(defaultTableModel);
        this.disabledValueChanged = false;
    }

    private void updateTree(String string, JTree jTree) {
        Parser parser = new Parser();
        parser.setNodeFactory(SwingNodeFactory.getFactory());
        try {
            parser.setReader(new FileReader(string));
            parser.parse();
            TreeNode treeNode = (TreeNode)((Object)parser.getDocument().getRoot());
            this.updateTree(treeNode, jTree);
        }
        catch (Throwable throwable) {
            JOptionPane.showMessageDialog(this, "Can't parse this document : " + string);
        }
    }

    private void updateTree(TreeNode treeNode, JTree jTree) {
        jTree.setModel(new DefaultTreeModel(treeNode));
        if (this.treeLeft.getModel().getRoot() instanceof SimpleNode && this.treeRight.getModel().getRoot() instanceof SimpleNode) {
            this.runDiff();
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.disabledValueChanged) {
            return;
        }
        int n = this.tableDiff.getSelectedRow();
        if (n == -1) {
            return;
        }
        ModelElementDiff modelElementDiff = (ModelElementDiff)this.tableDiff.getModel().getValueAt(n, 0);
        SimpleNode simpleNode = modelElementDiff.source;
        if (simpleNode != null) {
            TreePath treePath = XMLToolkit.getTreePath(simpleNode);
            if (simpleNode.getDocument().getRoot() == this.treeLeft.getModel().getRoot()) {
                this.treeLeft.setSelectionPath(treePath);
                this.treeLeft.expandPath(treePath);
                this.treeLeft.scrollPathToVisible(treePath);
            } else {
                this.treeRight.setSelectionPath(treePath);
                this.treeRight.expandPath(treePath);
                this.treeRight.scrollPathToVisible(treePath);
            }
        }
    }

    private void runDiff() {
        this.tfPathLeft.setEnabled(false);
        this.tfPathRight.setEnabled(false);
        new DiffThread().start();
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        XMLDiffPanel xMLDiffPanel = new XMLDiffPanel(null);
        jFrame.getContentPane().add(xMLDiffPanel);
        jFrame.setSize(600, 500);
        xMLDiffPanel.mainSplitPane.setDividerLocation(jFrame.getWidth() / 2);
        jFrame.setVisible(true);
    }

    class CustomTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        public CustomTableCellRenderer() {
            this.setOpaque(true);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                this.setForeground(jTable.getSelectionForeground());
                this.setBackground(jTable.getSelectionBackground());
            } else {
                this.setForeground(jTable.getForeground());
                this.setBackground(jTable.getBackground());
            }
            this.setFont(jTable.getFont());
            ModelElementDiff modelElementDiff = (ModelElementDiff)object;
            Color color = ResourceFactory.getColorForType(modelElementDiff.type);
            if (color != null) {
                this.setBackground(bl ? color.darker() : color);
            }
            if (n2 == 0) {
                this.setText(modelElementDiff.name);
                this.setIcon(ResourceFactory.getIconForType(modelElementDiff.type));
            } else if (n2 == 1) {
                this.setText(modelElementDiff.value);
            }
            return this;
        }
    }

    class DiffThread
    extends Thread {
        DiffThread() {
        }

        private void clean(SimpleNode simpleNode) {
            ArrayList arrayList = (ArrayList)simpleNode.getApplicationObject();
            if (arrayList != null && arrayList.size() > 0) {
                simpleNode.setApplicationObject(null);
                for (int i = 0; i < simpleNode.childCount(); ++i) {
                    this.clean(simpleNode.childAt(i));
                }
            }
        }

        public void run() {
            XMLDiff xMLDiff = new XMLDiff();
            SimpleNode simpleNode = (SimpleNode)XMLDiffPanel.this.treeLeft.getModel().getRoot();
            SimpleNode simpleNode2 = (SimpleNode)XMLDiffPanel.this.treeRight.getModel().getRoot();
            if (simpleNode.getApplicationObject() instanceof ArrayList) {
                this.clean(simpleNode);
            }
            if (simpleNode2.getApplicationObject() instanceof ArrayList) {
                this.clean(simpleNode2);
            }
            xMLDiff.diff(simpleNode, simpleNode2);
            XMLDiffPanel.this.tfPathLeft.setEnabled(true);
            XMLDiffPanel.this.tfPathRight.setEnabled(true);
            if (((SimpleNode)XMLDiffPanel.this.treeLeft.getModel().getRoot()).getApplicationObject() == null && ((SimpleNode)XMLDiffPanel.this.treeRight.getModel().getRoot()).getApplicationObject() == null) {
                JOptionPane.showMessageDialog(XMLDiffPanel.this, "Both documents are equal");
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ((DefaultTreeModel)XMLDiffPanel.this.treeLeft.getModel()).reload();
                    ((DefaultTreeModel)XMLDiffPanel.this.treeRight.getModel()).reload();
                    if (((SimpleNode)XMLDiffPanel.this.treeLeft.getModel().getRoot()).getApplicationObject() instanceof ArrayList) {
                        XMLDiffPanel.this.treeLeft.setSelectionPath(new TreePath(XMLDiffPanel.this.treeLeft.getModel().getRoot()));
                    }
                }
            });
        }
    }
}

