/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.treefilebrowser;

import com.japisoft.treefilebrowser.ActionButton;
import com.japisoft.treefilebrowser.ActionModel;
import com.japisoft.treefilebrowser.ActionPanel;
import com.japisoft.treefilebrowser.FileFilter;
import com.japisoft.treefilebrowser.FileFilterCombo;
import com.japisoft.treefilebrowser.FileFilterListener;
import com.japisoft.treefilebrowser.FileFilterModel;
import com.japisoft.treefilebrowser.FileSelectionListener;
import com.japisoft.treefilebrowser.FileTree;
import com.japisoft.treefilebrowser.FileTreeModel;
import com.japisoft.treefilebrowser.FileView;
import com.japisoft.treefilebrowser.action.CreateDirectoryAction;
import com.japisoft.treefilebrowser.action.CreateFileAction;
import com.japisoft.treefilebrowser.action.DeleteAction;
import com.japisoft.treefilebrowser.action.DirectoryAction;
import com.japisoft.treefilebrowser.action.FileBrowserAction;
import com.japisoft.treefilebrowser.action.OrderingAction;
import com.japisoft.treefilebrowser.action.RefreshAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.io.File;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.tree.TreePath;

public class JTreeFileBrowser
extends JComponent {
    public static int DIRECTORY_FIRST = 0;
    public static int FILE_FIRST = 1;
    private ActionPanel actionPanel = null;
    private FileTree fileTree = null;
    private ActionButton actionButton = null;
    private ActionModel model = null;
    private FileFilterCombo combo = null;
    private FileFilterModel model2 = null;
    private Container parentCombo = null;
    private boolean southOrientation = true;
    private boolean addNotifyStep = false;
    private PrepareActionForDirectoryListener listener1 = null;
    private FileFilterListener listener2 = null;

    public JTreeFileBrowser(Action action, boolean bl) {
        this.southOrientation = bl;
        this.init(action);
        this.setEnabledMultipleSelection(false);
    }

    public JTreeFileBrowser(Action action) {
        this(action, true);
    }

    public JTreeFileBrowser() {
        this(null);
    }

    private void init(Action action) {
        this.setLayout(new BorderLayout());
        String string = this.southOrientation ? "South" : "North";
        this.actionPanel = new ActionPanel();
        this.add((Component)this.actionPanel, "North");
        if (action == null) {
            this.fileTree = new FileTree(action);
            this.add((Component)new JScrollPane(this.fileTree), "Center");
            this.combo = new FileFilterCombo();
            this.add((Component)this.combo, string);
            this.parentCombo = this;
        } else {
            if (this.southOrientation) {
                this.actionPanel = new ActionPanel();
                this.add((Component)this.actionPanel, "North");
            } else {
                this.actionPanel = new ActionPanel();
                this.add((Component)this.actionPanel, "South");
            }
            this.fileTree = new FileTree(action);
            this.add((Component)new JScrollPane(this.fileTree), "Center");
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            this.combo = new FileFilterCombo();
            jPanel.add((Component)this.combo, "Center");
            this.actionButton = new ActionButton();
            jPanel.add((Component)this.actionButton, "West");
            this.add((Component)jPanel, string);
            this.actionButton.setAction(action);
            this.parentCombo = jPanel;
        }
        this.fileTree.setSelectedFile(new File(System.getProperty("user.home")));
        this.prepareDefaultActions();
        this.prepareDefaultFileFilters();
    }

    protected void prepareDefaultActions() {
        this.getActionModel().addAction(new RefreshAction());
        this.getActionModel().addAction(new CreateDirectoryAction());
        this.getActionModel().addAction(new CreateFileAction());
        this.getActionModel().addAction(new DeleteAction());
        this.getActionModel().addAction(new OrderingAction());
    }

    protected void prepareDefaultFileFilters() {
    }

    public void setOrderingMode(int n) {
        ((FileTreeModel)this.fileTree.getModel()).setOrderingMode(n);
        if (this.addNotifyStep) {
            this.refresh();
        }
    }

    public int getOrderingMode() {
        return ((FileTreeModel)this.fileTree.getModel()).getOrderingMode();
    }

    public ActionModel getActionModel() {
        if (this.model == null) {
            this.model = new ActionModel();
        }
        return this.model;
    }

    public FileFilterModel getFileFilterModel() {
        if (this.model2 == null) {
            this.model2 = new FileFilterModel();
        }
        return this.model2;
    }

    public FileFilter getCurrentFileFilter() {
        return (FileFilter)this.combo.getSelectedItem();
    }

    public void setFileView(FileView fileView) {
        this.fileTree.setFileView(fileView);
    }

    public void setSelectedFile(File file) {
        this.fileTree.setSelectedFile(file);
        if (this.listener1 == null) {
            this.listener1 = new PrepareActionForDirectoryListener();
        }
        this.listener1.fileSelected(new File[]{file});
    }

    public File[] getSelectedFiles() {
        return this.fileTree.getSelectedFiles();
    }

    public File getSelectedFile() {
        return this.fileTree.getSelectedFile();
    }

    public void setEnabledFileMoving(boolean bl) {
        this.fileTree.setEnabledFileMoving(bl);
    }

    public boolean isEnabledFileMoving() {
        return this.fileTree.isEnabledFileMoving();
    }

    public void setEnabledFileRenaming(boolean bl) {
        this.fileTree.setEnabledFileRenaming(bl);
    }

    public boolean isEnabledFileRenaming() {
        return this.fileTree.isEnabledFileRenaming();
    }

    public void setAUnitSupport(boolean bl) {
        ((FileTreeModel)this.fileTree.getModel()).setAUnitSupport(bl);
        this.refreshRoot();
    }

    public boolean isAUnitSupport() {
        return ((FileTreeModel)this.fileTree.getModel()).isAUnitSupport();
    }

    public void addNotify() {
        super.addNotify();
        this.addNotifyStep = true;
        this.actionPanel.prepareAction(this.getActionModel());
        for (int i = 0; i < this.getActionModel().getActionCount(); ++i) {
            if (!(this.getActionModel().getAction(i) instanceof FileBrowserAction)) continue;
            ((FileBrowserAction)this.getActionModel().getAction(i)).setSource(this);
        }
        if (this.listener1 == null) {
            this.listener1 = new PrepareActionForDirectoryListener();
        }
        this.addFileSelectionListener(this.listener1);
        if (this.listener2 == null) {
            this.listener2 = new DefaultFileFilterListener();
        }
        if (this.getFileFilterModel().getFileFilterCount() == 0) {
            this.parentCombo.remove(this.combo);
            this.parentCombo.invalidate();
            this.parentCombo.validate();
        } else {
            this.combo.init(this.getFileFilterModel());
            this.combo.setListener(this.listener2);
            this.listener2.setActifFileFilter(this.getFileFilterModel().getFileFilter(0));
        }
    }

    public void removeNotify() {
        super.removeNotify();
        this.removeFileSelectionListener(this.listener1);
        this.combo.setListener(null);
    }

    public void addFileSelectionListener(FileSelectionListener fileSelectionListener) {
        this.fileTree.addFileSelectionListener(fileSelectionListener);
    }

    public void removeFileSelectionListener(FileSelectionListener fileSelectionListener) {
        this.fileTree.removeFileSelectionListener(fileSelectionListener);
    }

    public void refresh() {
        if (this.fileTree.getSelectionPath() != null) {
            ((FileTreeModel)this.fileTree.getModel()).reload(this.fileTree.getSelectionPath());
        }
        this.fileTree.repaint();
    }

    public void refreshParent() {
        TreePath treePath;
        if (this.fileTree.getSelectionPath() != null && (treePath = this.fileTree.getSelectionPath()).getParentPath() != null) {
            ((FileTreeModel)this.fileTree.getModel()).reload(treePath.getParentPath());
            this.fileTree.repaint();
        }
    }

    void refreshRoot() {
        ((FileTreeModel)this.fileTree.getModel()).reload(new TreePath(this.fileTree.getModel().getRoot()));
    }

    public void setEnabledMultipleSelection(boolean bl) {
        this.fileTree.getSelectionModel().setSelectionMode(bl ? 4 : 1);
    }

    public boolean isEnabledMultipleSelection() {
        return this.fileTree.getSelectionModel().getSelectionMode() == 4;
    }

    class DefaultFileFilterListener
    implements FileFilterListener {
        DefaultFileFilterListener() {
        }

        public void setActifFileFilter(FileFilter fileFilter) {
            JTreeFileBrowser.this.fileTree.setFileFilter(fileFilter);
        }
    }

    class PrepareActionForDirectoryListener
    implements FileSelectionListener {
        PrepareActionForDirectoryListener() {
        }

        public void fileSelected(File[] fileArray) {
            int n;
            boolean bl = true;
            for (n = 0; n < fileArray.length; ++n) {
                bl = fileArray[n].isDirectory() && bl;
            }
            for (n = 0; n < JTreeFileBrowser.this.model.getActionCount(); ++n) {
                if (!(JTreeFileBrowser.this.model.getAction(n) instanceof DirectoryAction)) continue;
                JTreeFileBrowser.this.model.getAction(n).setEnabled(bl);
            }
        }
    }
}

