/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.framework.dialog.actions;

import com.japisoft.framework.SharedProperties;
import com.japisoft.framework.dialog.actions.DialogAction;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;

public abstract class AbstractDialogAction
extends AbstractAction
implements DialogAction {
    private int id;
    private ResourceBundle resource = null;
    private ActionListener listenerDelegate;
    private boolean forFooter = true;
    private boolean specialMode = false;
    private boolean veto = false;

    public AbstractDialogAction(int n) {
        this(n, true);
    }

    public AbstractDialogAction(int n, boolean bl) {
        this.id = n;
        if (bl && SharedProperties.BUNDLE_MODE) {
            this.prepareBundleValues();
        } else {
            this.prepareStaticValues();
        }
    }

    protected void prepareStaticValues() {
    }

    protected void prepareBundleValues() {
        try {
            this.resource = ResourceBundle.getBundle(this.getBundledName());
        }
        catch (MissingResourceException missingResourceException) {
            System.out.println("Warning : no resource for the action " + this.getClass().getName());
        }
        this.putValue("Name", this.getLabel("NAME", "?"));
        this.putValue("ShortDescription", this.getLabel("SHORT_DESCRIPTION", "?"));
    }

    protected String getBundledName() {
        return this.getClass().getName();
    }

    protected String getLabel(String string, String string2) {
        if (this.resource == null) {
            return string2;
        }
        try {
            return this.resource.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return string2;
        }
    }

    public int getActionId() {
        return this.id;
    }

    public void setActionDelegate(ActionListener actionListener) {
        this.listenerDelegate = actionListener;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.listenerDelegate != null) {
            this.listenerDelegate.actionPerformed(actionEvent);
        }
    }

    public void setForDialogFooter(boolean bl) {
        this.forFooter = bl;
    }

    public boolean isForDialogFooter() {
        return this.forFooter;
    }

    public boolean isSpecial() {
        return this.specialMode;
    }

    public void setSpecial(boolean bl) {
        this.specialMode = bl;
    }

    public void vetoClosingDialog(boolean bl) {
        this.veto = bl;
    }

    public boolean isVetoClosingDialog() {
        return this.veto;
    }
}

