/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.framework;

import com.japisoft.framework.ApplicationException;
import com.japisoft.framework.ApplicationStep;
import com.japisoft.framework.application.descriptor.InterfaceBuilder;
import com.japisoft.framework.preferences.Preferences;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JFrame;

public class ApplicationModel {
    public static String LONG_APPNAME = null;
    public static String SHORT_APPNAME = null;
    public static String BUILD = "010105";
    public static String INNER_BUILD = null;
    public static int MAJOR_VERSION = 1;
    public static int MAJOR_YEAR = 2000;
    public static int RELEASE_CANDIDATE = 0;
    public static int SERVICE_PACK = 0;
    public static int MINOR_VERSION = 0;
    public static int SUBMINOR_VERSION = 0;
    public static int BETA_VERSION = 0;
    public static String MAIN_SUPPORT_EMAIL = null;
    public static String REGISTERED_FILE = null;
    public static String REPORTING_URL = null;
    public static String COMPANY_URL = null;
    public static String PRODUCT_URL = null;
    public static String USERINTERFACE_FILE = null;
    public static String AUTODOC_FILE = "autodoc.xsl";
    public static String APP_IMG_PATH = null;
    public static String DEF_MANUAL_PATH = null;
    public static boolean MACOSX_MODE = false;
    public static boolean DEBUG_MODE = "true".equals(System.getProperty("application.debug"));
    public static String DEBUG_AUTODOC_FILE = null;
    public static JFrame MAIN_FRAME = null;
    public static InterfaceBuilder INTERFACE_BUILDER = null;
    public static URL PREFERENCES_SUBMENU = null;
    static String[] FILE_ENCODING;
    private static Hashtable htSharedProperties;
    private static Vector vApplicationStep;

    static void init(String string) throws ApplicationException {
        URL uRL = ClassLoader.getSystemResource(string);
        if (uRL == null) {
            throw new ApplicationException("Cannot find the application descriptor file at " + string);
        }
        Properties properties = new Properties();
        try {
            properties.load(uRL.openStream());
            ApplicationModel.init(properties);
        }
        catch (IOException iOException) {
            throw new ApplicationException("Error while loading the application descriptor file", iOException);
        }
    }

    static void init(Properties properties) throws ApplicationException {
        String string;
        LONG_APPNAME = properties.getProperty("LONG_APPNAME");
        SHORT_APPNAME = properties.getProperty("SHORT_APPNAME");
        BUILD = properties.getProperty("BUILD");
        try {
            MAJOR_VERSION = Integer.parseInt(properties.getProperty("MAJOR_VERSION", "1"));
            MINOR_VERSION = Integer.parseInt(properties.getProperty("MINOR_VERSION", "0"));
            SUBMINOR_VERSION = Integer.parseInt(properties.getProperty("SUBMINOR_VERSION", "0"));
            BETA_VERSION = Integer.parseInt(properties.getProperty("BETA_VERSION", "0"));
        }
        catch (NumberFormatException numberFormatException) {
            throw new ApplicationException("Error inside the version number from the descriptor file " + numberFormatException.getMessage());
        }
        MAIN_SUPPORT_EMAIL = properties.getProperty("MAIN_SUPPORT_EMAIL");
        REGISTERED_FILE = properties.getProperty("REGISTERED_FILE");
        REPORTING_URL = properties.getProperty("REPORTING_URL");
        USERINTERFACE_FILE = properties.getProperty("USERINTERFACE_FILE", "application.xml");
        AUTODOC_FILE = properties.getProperty("AUTODOC_FILE", "autodoc.xsl");
        int n = 1;
        while ((string = properties.getProperty("step." + n)) != null) {
            try {
                Class<?> clazz = Class.forName(string);
                ApplicationModel.addApplicationStep((ApplicationStep)clazz.newInstance());
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ApplicationException(classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                throw new ApplicationException(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ApplicationException(illegalAccessException);
            }
            ++n;
        }
    }

    static void checkApplicationName() {
        if (SHORT_APPNAME == null) {
            throw new RuntimeException("No application name found. Please reset APPNAME from the ApplicationModel");
        }
    }

    public static File getAppUserPath() {
        boolean bl;
        ApplicationModel.checkApplicationName();
        File file = new File(System.getProperty("user.home"));
        file = new File(file, "." + SHORT_APPNAME);
        if (!file.exists() && !(bl = file.mkdirs())) {
            return null;
        }
        return file;
    }

    public static String getAppNameVersion() {
        ApplicationModel.checkApplicationName();
        return LONG_APPNAME + "-" + ApplicationModel.getAppVersion();
    }

    public static String getAppVersion() {
        return MAJOR_VERSION + "." + MINOR_VERSION + "" + (SUBMINOR_VERSION > 0 ? "." + SUBMINOR_VERSION : "") + (BETA_VERSION > 0 ? " Beta " + BETA_VERSION : "");
    }

    public static String getAppYear() {
        return MAJOR_YEAR + ApplicationModel.getReleaseCandidateVersion() + ApplicationModel.getServicePackVersion() + " [Build " + BUILD + "]";
    }

    private static String getReleaseCandidateVersion() {
        if (RELEASE_CANDIDATE > 0) {
            return " ( RC " + RELEASE_CANDIDATE + (BETA_VERSION > 0 ? " Beta" + BETA_VERSION : "") + " )";
        }
        return BETA_VERSION > 0 ? " Beta " + BETA_VERSION : "";
    }

    private static String getServicePackVersion() {
        if (SERVICE_PACK > 0) {
            return " ( Service Pack " + SERVICE_PACK + (BETA_VERSION > 0 ? " Beta" + BETA_VERSION : "") + " )";
        }
        return "";
    }

    public static void starting() {
        System.out.println("Starting " + ApplicationModel.getAppNameVersion());
    }

    public static String getCurrentFileEncoding() {
        String[] stringArray = Preferences.getPreference("file", "rw-encoding", FILE_ENCODING);
        return stringArray[0];
    }

    public static void debug(String string) {
        if (DEBUG_MODE) {
            System.out.println("DEBUG:" + string);
        }
    }

    public static void debug(Throwable throwable) {
        if (DEBUG_MODE) {
            throwable.printStackTrace();
        }
    }

    public static void setSharedProperty(String string, Object object) {
        if (htSharedProperties == null) {
            htSharedProperties = new Hashtable();
        }
        htSharedProperties.put(string, object);
    }

    public static Object getSharedProperty(String string) {
        if (htSharedProperties == null) {
            return null;
        }
        return htSharedProperties.get(string);
    }

    public static void addApplicationStep(ApplicationStep applicationStep) {
        if (vApplicationStep == null) {
            vApplicationStep = new Vector();
        }
        vApplicationStep.add(applicationStep);
    }

    public static void addApplicationStep(ApplicationStep applicationStep, int n) {
        if (vApplicationStep == null) {
            vApplicationStep = new Vector();
        }
        vApplicationStep.add(n, applicationStep);
    }

    public static void removeApplicationStep(ApplicationStep applicationStep) {
        if (vApplicationStep == null) {
            throw new RuntimeException("There're no available application steps. Wrong method usage");
        }
        vApplicationStep.remove(applicationStep);
    }

    public static int getApplicationStepCount() {
        if (vApplicationStep == null) {
            return 0;
        }
        return vApplicationStep.size();
    }

    public static ApplicationStep getApplicationStepAt(int n) {
        if (vApplicationStep == null) {
            throw new RuntimeException("There're no available application steps. Wrong method usage");
        }
        return (ApplicationStep)vApplicationStep.get(n);
    }

    public static boolean isWindowsPlatform() {
        String string = System.getProperty("os.name");
        return string != null && string.toLowerCase().indexOf("windows") > -1;
    }

    public static boolean isMacOSXPlatform() {
        String string = System.getProperty("os.name");
        return string != null && string.toLowerCase().indexOf("mac os x") > -1;
    }

    public static boolean isOtherPlatform() {
        return !ApplicationModel.isWindowsPlatform() && !ApplicationModel.isMacOSXPlatform();
    }

    static {
        MACOSX_MODE = ApplicationModel.isMacOSXPlatform();
        FILE_ENCODING = new String[]{"DEFAULT", "ASCII", "Cp1252", "ISO8859_1", "UnicodeBig", "UnicodeBigUnmarked", "UnicodeLittle", "UnicodeLittleUnmarked", "UTF8", "UTF-16"};
    }
}

