/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.fastparser.node;

import com.japisoft.fastparser.FastVector;
import com.japisoft.fastparser.document.Document;
import com.japisoft.fastparser.node.MutableNode;
import com.japisoft.fastparser.node.NodeFactory;
import com.japisoft.fastparser.node.ViewableNode;
import com.japisoft.fastparser.walker.TreeWalker;
import com.japisoft.fastparser.walker.ValidCriteria;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;

public class SimpleNode
implements MutableNode,
ViewableNode {
    private int type;
    private String content;
    private int idContent;
    private int startingLine;
    private int stoppingLine;
    private int startingOffset;
    private int stoppingOffset;
    private Document doc;
    private String nameSpacePrefix;
    private String nameSpaceURI;
    private Hashtable htNameSpaceDeclaration;
    private String defaultNamespace;
    private SimpleNode parent;
    private FastVector children = null;
    Hashtable attributes = null;
    FastVector attributesOrder = null;
    private String value;
    private ArrayList attributesNode;
    private String xpathLocationCache = null;
    private boolean closedLeaf = false;
    private Object applicationObject;

    public SimpleNode(int n, String string) {
        this.type = n;
        this.content = string;
    }

    public SimpleNode(int n, int n2) {
        this.type = n;
        this.idContent = n2;
    }

    public SimpleNode(String string) {
        this(1, string);
    }

    public SimpleNode(SimpleNode simpleNode, int n, String string) {
        this(n, string);
        this.setSimpleParent(simpleNode);
    }

    public int getStartingOffset() {
        return this.startingOffset;
    }

    public int getStoppingOffset() {
        return this.stoppingOffset;
    }

    public void setStartingOffset(int n) {
        this.startingOffset = n;
    }

    public void setStoppingOffset(int n) {
        this.stoppingOffset = n;
    }

    public void setStartingLine(int n) {
        this.startingLine = n;
    }

    public int getStartingLine() {
        return this.startingLine;
    }

    public int getStoppingLine() {
        return this.stoppingLine;
    }

    public void setStoppingLine(int n) {
        this.stoppingLine = n;
    }

    public void addNameSpaceDeclaration(String string, String string2) {
        if (this.htNameSpaceDeclaration == null) {
            this.htNameSpaceDeclaration = new Hashtable();
        }
        this.htNameSpaceDeclaration.put(string, string2);
    }

    public void removeNameSpaceDeclaration(String string) {
        if (this.htNameSpaceDeclaration != null) {
            this.htNameSpaceDeclaration.remove(string);
        }
    }

    public void removeAllNameSpaceDeclaration() {
        this.htNameSpaceDeclaration = null;
    }

    public Enumeration getNameSpaceDeclaration() {
        if (this.htNameSpaceDeclaration == null) {
            return null;
        }
        return this.htNameSpaceDeclaration.keys();
    }

    public String getNameSpaceDeclarationURI(String string) {
        if (this.htNameSpaceDeclaration == null) {
            return null;
        }
        return (String)this.htNameSpaceDeclaration.get(string);
    }

    public boolean isNamespaceDeclared(String string) {
        if (this.htNameSpaceDeclaration == null) {
            return false;
        }
        return this.htNameSpaceDeclaration.containsKey(string);
    }

    public Enumeration getNamespaceDeclared() {
        if (this.htNameSpaceDeclaration == null) {
            return null;
        }
        return this.htNameSpaceDeclaration.keys();
    }

    public void setNameSpace(String string, String string2) {
        this.nameSpacePrefix = string;
        this.nameSpaceURI = string2;
    }

    public String getNameSpacePrefix() {
        return this.nameSpacePrefix;
    }

    public String getNameSpaceURI() {
        if (this.nameSpaceURI == null) {
            return this.defaultNamespace;
        }
        return this.nameSpaceURI;
    }

    public void setDefaultNamespace(String string) {
        this.defaultNamespace = string;
        if (this.nameSpacePrefix == null) {
            this.nameSpaceURI = string;
        }
    }

    public String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    public void setDocument(Document document) {
        this.doc = document;
    }

    public Document getDocument() {
        if (this.doc == null) {
            this.doc = new Document();
            this.doc.setRoot(this);
        }
        return this.doc;
    }

    public SimpleNode clone(boolean bl) {
        if (this.getDocument() == null) {
            if (this.getSimpleParent() != null && this.getSimpleParent().getDocument() != null) {
                this.setDocument(this.getSimpleParent().getDocument());
            } else {
                throw new RuntimeException("Can't clone need a document");
            }
        }
        if (this.getDocument().getNodeFactory() == null) {
            throw new RuntimeException("Can't clone need a NodeFactory inside the document");
        }
        NodeFactory nodeFactory = this.getDocument().getNodeFactory();
        if (this.isText()) {
            return (SimpleNode)nodeFactory.getTextNode(this.getContent());
        }
        if (this.isComment()) {
            return (SimpleNode)nodeFactory.getCommentNode(this.getContent());
        }
        if (this.isTag()) {
            return this.cloneTag(bl);
        }
        throw new RuntimeException("Can't clone , unknown node type : " + this);
    }

    private SimpleNode cloneTag(boolean bl) {
        SimpleNode simpleNode = (SimpleNode)this.getDocument().getNodeFactory().getTagNode(this.getContent());
        if (this.attributes != null) {
            simpleNode.attributes = (Hashtable)this.attributes.clone();
            simpleNode.attributesOrder = (FastVector)this.attributesOrder.clone();
        }
        if (this.htNameSpaceDeclaration != null) {
            simpleNode.htNameSpaceDeclaration = (Hashtable)this.htNameSpaceDeclaration.clone();
        }
        if (this.nameSpacePrefix != null) {
            simpleNode.nameSpacePrefix = this.nameSpacePrefix;
        }
        if (this.nameSpaceURI != null) {
            simpleNode.nameSpaceURI = this.nameSpaceURI;
        }
        if (this.defaultNamespace != null) {
            simpleNode.defaultNamespace = this.defaultNamespace;
        }
        if (bl) {
            for (int i = 0; i < this.childCount(); ++i) {
                simpleNode.addChildNode(this.childAt(i).clone(bl));
            }
        }
        return simpleNode;
    }

    public void setSimpleParent(SimpleNode simpleNode) {
        this.parent = simpleNode;
    }

    public SimpleNode getSimpleParent() {
        return this.parent;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public void setContent(String string) {
        this.content = string;
    }

    public String getContent() {
        if (this.content != null) {
            return this.content;
        }
        if (this.type == 1) {
            return this.doc.getStringById(this.idContent);
        }
        return this.content;
    }

    public boolean matchContent(String string) {
        if (this.content != null) {
            return this.content.equals(string);
        }
        if (string != null) {
            return string.equals(this.getContent());
        }
        return false;
    }

    public String getQualifiedContent() {
        if (this.nameSpacePrefix == null) {
            return this.getContent();
        }
        return this.nameSpacePrefix + ":" + this.getContent();
    }

    public void setType(int n) {
        this.type = n;
    }

    public int getType() {
        return this.type;
    }

    public boolean isText() {
        return this.type == 0;
    }

    public boolean isTag() {
        return this.type == 1;
    }

    public boolean isComment() {
        return this.type == 2;
    }

    public boolean isAttribute() {
        return this.type == 4;
    }

    public void insertChildNode(int n, SimpleNode simpleNode) {
        if (this.children == null) {
            this.addChildNode(simpleNode);
        } else {
            simpleNode.setSimpleParent(this);
            this.children.insertElementAt(simpleNode, n);
        }
    }

    public void replaceChildNode(SimpleNode simpleNode, SimpleNode simpleNode2) {
        int n;
        if (this.children != null && (n = this.children.indexOf(simpleNode)) > -1) {
            this.children.insertElementAt(simpleNode2, n);
            this.children.remove(simpleNode);
        }
    }

    public void addChildNode(SimpleNode simpleNode) {
        if (this.isText() && simpleNode.isText()) {
            this.setContent(this.getContent() + simpleNode.getContent());
            return;
        }
        if (this.children == null) {
            this.children = new FastVector();
        }
        simpleNode.setSimpleParent(this);
        this.children.add(simpleNode);
    }

    public void removeChildrenNodes() {
        this.children = null;
    }

    public void removeChildNode(SimpleNode simpleNode) {
        if (this.children == null) {
            return;
        }
        this.children.remove(simpleNode);
        simpleNode.setSimpleParent(null);
        if (this.children.size() == 0) {
            this.children = null;
        }
    }

    public void removeChildNodeAt(int n) {
        if (this.children == null) {
            return;
        }
        this.children.removeElementAt(n);
    }

    public int childNodeIndex(SimpleNode simpleNode) {
        if (this.children == null) {
            return -1;
        }
        return this.children.indexOf(simpleNode);
    }

    public int childCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    public Enumeration getAllChild() {
        if (this.children == null) {
            return null;
        }
        return this.children.elements();
    }

    public SimpleNode childAt(int n) {
        if (this.children == null) {
            return null;
        }
        return (SimpleNode)this.children.get(n);
    }

    public SimpleNode getFirstChildByName(String string) {
        for (int i = 0; i < this.childCount(); ++i) {
            if (!this.childAt(i).matchContent(string)) continue;
            return this.childAt(i);
        }
        return null;
    }

    public boolean hasTextChildNode() {
        for (int i = 0; i < this.childCount(); ++i) {
            if (!this.childAt(i).isText()) continue;
            return true;
        }
        return false;
    }

    public boolean isLeaf() {
        return this.children == null;
    }

    public void setAttribute(String string, String string2) {
        int n;
        if (this.attributesNode != null) {
            for (n = 0; n < this.attributesNode.size(); ++n) {
                SimpleNode simpleNode = (SimpleNode)this.attributesNode.get(n);
                if (!simpleNode.matchContent(string)) continue;
                if (string2 == null) {
                    this.attributesNode.remove(n);
                    break;
                }
                simpleNode.setNodeValue(string2);
            }
        }
        if (this.attributes == null && string2 != null) {
            this.attributes = new Hashtable();
            this.attributesOrder = new FastVector();
            this.attributes.put(string, string2);
            this.attributesOrder.add(string);
        } else if (string2 == null) {
            if (this.attributes != null) {
                this.attributesOrder.remove(string);
                this.attributes.remove(string);
            }
        } else {
            n = this.attributes.containsKey(string) ? 1 : 0;
            this.attributes.put(string, string2);
            if (n == 0) {
                this.attributesOrder.add(string);
            }
        }
    }

    public void setAttribute(String string, int n) {
        this.setAttribute(string, "" + n);
    }

    public void setAttribute(String string, double d) {
        this.setAttribute(string, "" + d);
    }

    public void setAttribute(String string, boolean bl) {
        this.setAttribute(string, "" + bl);
    }

    public String getAttribute(String string, String string2) {
        String string3 = this.getAttribute(string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    public String getFirstAttributeValue() {
        if (this.attributesOrder != null && this.attributesOrder.size() > 0) {
            return (String)this.attributes.get(this.attributesOrder.get(0));
        }
        return null;
    }

    public Enumeration getNodeByName(String string, boolean bl) {
        TreeWalker treeWalker = new TreeWalker(this);
        return treeWalker.getTagNodeByName(string, bl);
    }

    public Enumeration getNodeByCriteria(ValidCriteria validCriteria, boolean bl) {
        TreeWalker treeWalker = new TreeWalker(this);
        return treeWalker.getNodeByCriteria(validCriteria, bl);
    }

    public String getAttribute(String string) {
        if (this.attributes == null) {
            return null;
        }
        return (String)this.attributes.get(string);
    }

    public boolean hasAttribute(String string) {
        if (this.attributes == null) {
            return false;
        }
        return this.getAttribute(string) != null;
    }

    public String toString() {
        return this.getContent();
    }

    public void setNodeContent(String string) {
        this.setContent(string);
    }

    public String getNodeContent() {
        return this.getContent();
    }

    public void setNodeValue(String string) {
        this.value = string;
    }

    public String getNodeValue() {
        return this.value;
    }

    public void setNodeParent(MutableNode mutableNode) {
        this.setSimpleParent((SimpleNode)mutableNode);
    }

    public void setNodeAttribute(String string, String string2) {
        this.setAttribute(string, string2);
    }

    public void addNode(MutableNode mutableNode) {
        this.addChildNode((SimpleNode)mutableNode);
    }

    public Enumeration getViewAttributes() {
        if (this.attributes == null) {
            return null;
        }
        return this.attributesOrder.elements();
    }

    public List getViewAttributeNodes() {
        if (this.attributes == null) {
            return null;
        }
        if (this.attributesNode != null) {
            return this.attributesNode;
        }
        for (int i = 0; i < this.attributesOrder.size(); ++i) {
            String string = (String)this.attributesOrder.get(i);
            String string2 = (String)this.attributes.get(string);
            NodeFactory nodeFactory = this.getDocument().getNodeFactory();
            SimpleNode simpleNode = (SimpleNode)nodeFactory.getTextNode(string);
            simpleNode.setType(4);
            simpleNode.setSimpleParent(this);
            simpleNode.setNodeValue(string2);
            if (this.attributesNode == null) {
                this.attributesNode = new ArrayList();
            }
            this.attributesNode.add(simpleNode);
        }
        return this.attributesNode;
    }

    public String getViewAttributeAt(int n) {
        if (this.attributes == null) {
            return null;
        }
        return (String)this.attributesOrder.get(n);
    }

    public int getViewAttributeCount() {
        if (this.attributes == null) {
            return 0;
        }
        return this.attributes.size();
    }

    public String getViewAttribute(String string) {
        return this.getAttribute(string);
    }

    public String getViewContent() {
        return this.getContent();
    }

    public boolean isViewLeaf() {
        return this.getViewChildCount() == 0;
    }

    public int getViewChildCount() {
        return this.childCount();
    }

    public ViewableNode getViewChildAt(int n) {
        return this.childAt(n);
    }

    public boolean isViewText() {
        return this.isText();
    }

    public boolean isViewComment() {
        return this.isComment();
    }

    private SimpleNode resolveXPath(String string) {
        int n;
        int n2 = 0;
        int n3 = string.indexOf("[");
        if (n3 > -1) {
            n = string.indexOf("]");
            if (n > n3) {
                try {
                    n2 = Integer.parseInt(string.substring(n3 + 1, n)) - 1;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            string = string.substring(0, n3);
        }
        for (n = 0; n < this.childCount(); ++n) {
            SimpleNode simpleNode = this.childAt(n);
            if ("text()".equals(string) && simpleNode.isText()) {
                return simpleNode;
            }
            if (!simpleNode.isTag() || !string.equals(simpleNode.getNodeContent())) continue;
            if (n2 == 0) {
                return simpleNode;
            }
            --n2;
        }
        return null;
    }

    public SimpleNode getNodeForXPathLocation(String string, boolean bl) {
        if (string == null) {
            throw new RuntimeException("Invalid xpath expression null ?");
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = false;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '/') {
                if (i == 0) {
                    bl2 = true;
                    continue;
                }
                String string2 = stringBuffer.toString();
                stringBuffer = new StringBuffer();
                SimpleNode simpleNode = null;
                if (!bl2) {
                    simpleNode = this.resolveXPath(string2);
                } else {
                    simpleNode = (SimpleNode)this.getDocument().getRoot();
                    int n = string2.indexOf(91);
                    if (n > -1) {
                        string2 = string2.substring(0, n);
                    }
                    if (!simpleNode.getContent().equals(string2)) {
                        simpleNode = null;
                    }
                    bl2 = false;
                }
                if (simpleNode == null) {
                    if (bl) {
                        return simpleNode;
                    }
                    return this;
                }
                if (i + 1 < string.length()) {
                    return simpleNode.getNodeForXPathLocation(string.substring(i + 1), bl);
                }
                return simpleNode;
            }
            stringBuffer.append(string.charAt(i));
        }
        if (stringBuffer.length() > 0) {
            SimpleNode simpleNode = this.resolveXPath(stringBuffer.toString());
            if (simpleNode == null && bl) {
                return this;
            }
            return simpleNode;
        }
        if (bl) {
            return this;
        }
        return null;
    }

    public String getXPathLocation() {
        if (this.isText()) {
            if (this.getSimpleParent() == null) {
                return "text()";
            }
            return this.getSimpleParent().getXPathLocation() + "/text()";
        }
        SimpleNode simpleNode = this.getSimpleParent();
        if (simpleNode == null) {
            return "/" + this.getContent();
        }
        return simpleNode.getXPathLocation(this);
    }

    public String getCachedXPathLocation() {
        if (this.xpathLocationCache != null) {
            return this.xpathLocationCache;
        }
        this.xpathLocationCache = this.getXPathLocation();
        return this.xpathLocationCache;
    }

    public String getXPathLocation(SimpleNode simpleNode) {
        String string = simpleNode.getNodeContent();
        int n = 1;
        for (int i = 0; i < this.childCount(); ++i) {
            SimpleNode simpleNode2 = this.childAt(i);
            if (simpleNode2 == simpleNode) {
                return this.getXPathLocation() + "/" + string + "[" + n + "]";
            }
            if (!simpleNode2.isTag() || !simpleNode2.getNodeContent().equals(string)) continue;
            ++n;
        }
        return this.getSimpleParent().getXPathLocation();
    }

    public boolean equals(SimpleNode simpleNode) {
        if (simpleNode.getType() == simpleNode.getType()) {
            if (simpleNode.getType() == 0) {
                return this.getContent().equals(simpleNode.getContent());
            }
            if (simpleNode.getType() == 1) {
                if (this.getContent().equals(simpleNode.getContent())) {
                    if (this.attributes == null) {
                        return simpleNode.attributes == null;
                    }
                    if (simpleNode.attributes == null) {
                        return false;
                    }
                    for (int i = 0; i < this.getViewAttributeCount(); ++i) {
                        String string = this.getViewAttributeAt(i);
                        String string2 = this.getAttribute(string);
                        if (simpleNode.getAttribute(string) != null && simpleNode.getAttribute(string).equals(string2)) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
            return super.equals(simpleNode);
        }
        return false;
    }

    public String getRawXML() {
        StringBuffer stringBuffer = new StringBuffer();
        this.resetRawXML(stringBuffer);
        return stringBuffer.toString();
    }

    private void resetRawXML(StringBuffer stringBuffer) {
        if (this.isTag()) {
            stringBuffer.append(this.openDeclaration());
            for (int i = 0; i < this.childCount(); ++i) {
                this.childAt(i).resetRawXML(stringBuffer);
            }
            stringBuffer.append(this.closeDeclaration());
        } else {
            stringBuffer.append(this.getNodeContent());
        }
    }

    public String openDeclaration() {
        String string;
        String string2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<");
        if (this.getNameSpacePrefix() != null) {
            stringBuffer.append(this.getNameSpacePrefix()).append(":");
        }
        stringBuffer.append(this.getNodeContent());
        if (this.getDefaultNamespace() != null) {
            stringBuffer.append(" xmlns=\"").append(this.getDefaultNamespace()).append("\"");
        }
        if (this.htNameSpaceDeclaration != null) {
            Enumeration enumeration = this.htNameSpaceDeclaration.keys();
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                string = (String)this.htNameSpaceDeclaration.get(string2);
                stringBuffer.append(" xmlns:").append(string2).append("=\"").append(string).append("\"");
            }
        }
        if (this.attributesOrder != null) {
            for (int i = 0; i < this.attributesOrder.size(); ++i) {
                string2 = (String)this.attributesOrder.get(i);
                string = (String)this.attributes.get(string2);
                stringBuffer.append(" ");
                stringBuffer.append(string2);
                stringBuffer.append("=\"");
                stringBuffer.append(this.mapAttributeValueEntities(string));
                stringBuffer.append("\"");
            }
        }
        if (this.isLeaf()) {
            stringBuffer.append("/");
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    private String mapAttributeValueEntities(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '<') {
                stringBuffer.append("&lt;");
                continue;
            }
            if (c == '>') {
                stringBuffer.append("&gt;");
                continue;
            }
            if (c == '\"') {
                stringBuffer.append("&quot;");
                continue;
            }
            if (c == '\'') {
                stringBuffer.append("&apos;");
                continue;
            }
            if (c == '&' && (i + 1 >= string.length() || string.charAt(i + 1) != '#')) {
                stringBuffer.append("&amp;");
                continue;
            }
            if (c == '\n') {
                stringBuffer.append("&#10;");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public String closeDeclaration() {
        if (this.isLeaf()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("</").append(this.getQualifiedContent()).append(">");
        return stringBuffer.toString();
    }

    public void setClosedLeaf(boolean bl) {
        this.closedLeaf = bl;
    }

    public boolean isClosedLeaf() {
        return this.closedLeaf;
    }

    public void setApplicationObject(Object object) {
        this.applicationObject = object;
    }

    public Object getApplicationObject() {
        return this.applicationObject;
    }
}

