/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.ui.panels.search;

import com.japisoft.editix.ui.EditixFactory;
import com.japisoft.editix.ui.EditixFrame;
import com.japisoft.fastparser.node.SimpleNode;
import com.japisoft.fastparser.walker.AttributeCriteria;
import com.japisoft.fastparser.walker.NamespacePrefixCriteria;
import com.japisoft.fastparser.walker.NamespaceURICriteria;
import com.japisoft.fastparser.walker.NodeNameCriteria;
import com.japisoft.fastparser.walker.TextCriteria;
import com.japisoft.fastparser.walker.TreeWalker;
import com.japisoft.fastparser.walker.ValidCriteria;
import com.japisoft.framework.ui.Toolkit;
import com.japisoft.xmlpad.XMLContainer;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.jdesktop.layout.GroupLayout;

public class SearchUI
extends JPanel
implements ActionListener,
ListSelectionListener {
    JLabel lblCriteria = new JLabel();
    JComboBox cbCriteria = new JComboBox<String>(new String[]{"ELEMENT", "ATTRIBUTE NAME", "ATTRIBUTE VALUE", "TEXT", "NAMESPACE PREFIX", "NAMESPACE URI"});
    JLabel jLabel1 = new JLabel();
    JLabel jLabel2 = new JLabel();
    JTextField txtValue = new JTextField();
    JButton btnApplyFromRoot = new JButton();
    JButton btnApplyFromCurrent = new JButton();
    JScrollPane spResult = new JScrollPane();
    JTable tbResult = new JTable(){

        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    };
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    private String lastDocumentLocation = null;

    public SearchUI() {
        this.jbInit();
        this.getActionMap().put("run", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchUI.this.btnApplyFromRoot.doClick();
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke(10, 128), "run");
        Icon icon = Toolkit.getIconFromClasspath("images/gear_run.png");
        this.btnApplyFromRoot.setIcon(icon);
        this.btnApplyFromCurrent.setIcon(icon);
    }

    private void jbInit() {
        this.tbResult.getSelectionModel().setSelectionMode(0);
        this.jLabel1.setText("Select your search criteria");
        this.jLabel2.setText("<html><body>Value <b><font size='-2'>(Enter for running)</font></b></b></body></html>");
        this.btnApplyFromRoot.setText("Search From Root");
        this.btnApplyFromRoot.setToolTipText("Search from root node");
        this.btnApplyFromCurrent.setText("Search From Current");
        this.btnApplyFromCurrent.setToolTipText("search from the current node");
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (Component)this.spResult, -1, 228, Short.MAX_VALUE).add(1, (Component)this.cbCriteria, 0, 228, Short.MAX_VALUE).add(1, (Component)this.jLabel1).add(1, (Component)this.jLabel2).add(1, (Component)this.txtValue, -1, 228, Short.MAX_VALUE).add(1, (Component)this.btnApplyFromRoot).add(1, (Component)this.btnApplyFromCurrent)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.cbCriteria, -2, -1, -2).addPreferredGap(0).add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.txtValue, -2, -1, -2).addPreferredGap(0).add((Component)this.btnApplyFromRoot).addPreferredGap(0).add((Component)this.btnApplyFromCurrent).addPreferredGap(0).add((Component)this.spResult, -1, 233, Short.MAX_VALUE).addContainerGap()));
        this.spResult.getViewport().add((Component)this.tbResult, null);
    }

    public void addNotify() {
        super.addNotify();
        this.btnApplyFromCurrent.addActionListener(this);
        this.btnApplyFromRoot.addActionListener(this);
        this.tbResult.getSelectionModel().addListSelectionListener(this);
        this.txtValue.addActionListener(this);
    }

    public void removeNotify() {
        super.removeNotify();
        this.btnApplyFromCurrent.removeActionListener(this);
        this.btnApplyFromRoot.removeActionListener(this);
        this.tbResult.getSelectionModel().removeListSelectionListener(this);
        this.txtValue.removeActionListener(this);
    }

    public void searchByParam(String string) {
        if (string.startsWith("e")) {
            this.cbCriteria.setSelectedIndex(0);
        } else if (string.startsWith("a")) {
            this.cbCriteria.setSelectedIndex(1);
        }
        this.txtValue.setText(string.substring(1));
        this.actionPerformed(null);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        SimpleNode simpleNode = null;
        XMLContainer xMLContainer = EditixFrame.ACCESSOR.getSelectedContainer();
        if (xMLContainer == null) {
            EditixFactory.buildAndShowErrorDialog("No document");
            return;
        }
        this.lastDocumentLocation = xMLContainer.getCurrentDocumentLocation();
        if (actionEvent != null) {
            if (actionEvent.getSource() == this.btnApplyFromCurrent) {
                simpleNode = xMLContainer.getCurrentNode();
            } else if (actionEvent.getSource() == this.btnApplyFromRoot) {
                if (xMLContainer.getTree() == null) {
                    EditixFactory.buildAndShowErrorDialog("No available tree");
                    return;
                }
                simpleNode = (SimpleNode)xMLContainer.getTree().getModel().getRoot();
            } else {
                simpleNode = (SimpleNode)xMLContainer.getTree().getModel().getRoot();
            }
        } else {
            simpleNode = (SimpleNode)xMLContainer.getTree().getModel().getRoot();
        }
        if (simpleNode == null) {
            EditixFactory.buildAndShowErrorDialog("No node");
        } else {
            this.unshowResult();
            TreeWalker treeWalker = new TreeWalker(simpleNode);
            ValidCriteria validCriteria = null;
            if (this.cbCriteria.getSelectedIndex() == 0) {
                validCriteria = new NodeNameCriteria(this.txtValue.getText());
            } else if (this.cbCriteria.getSelectedIndex() == 1) {
                validCriteria = new AttributeCriteria(this.txtValue.getText());
            } else if (this.cbCriteria.getSelectedIndex() == 2) {
                validCriteria = new AttributeCriteria(AttributeCriteria.ANY_ATTRIBUTE, this.txtValue.getText());
            } else if (this.cbCriteria.getSelectedIndex() == 3) {
                validCriteria = new TextCriteria(this.txtValue.getText());
            } else if (this.cbCriteria.getSelectedIndex() == 4) {
                validCriteria = new NamespacePrefixCriteria(this.txtValue.getText());
            } else if (this.cbCriteria.getSelectedIndex() == 5) {
                validCriteria = new NamespaceURICriteria(this.txtValue.getText());
            }
            this.showResult(treeWalker.getNodeByCriteria(validCriteria, true), this.txtValue.getText(), this.cbCriteria.getSelectedIndex());
        }
    }

    private void showResult(Enumeration enumeration, String string, int n) {
        Object object;
        String string2 = null;
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            SimpleNode simpleNode;
            bl = false;
            object = (SimpleNode)enumeration.nextElement();
            if (((SimpleNode)object).isText()) {
                object = ((SimpleNode)object).getSimpleParent();
            }
            if (!((SimpleNode)object).isTag()) continue;
            if (n == 1) {
                string2 = string + " attribute";
                bl = true;
                arrayList.add(new Object[]{object, ((SimpleNode)object).getAttribute(string)});
            }
            if (bl) continue;
            if (!((SimpleNode)object).isLeaf() && (simpleNode = ((SimpleNode)object).childAt(0)).isText()) {
                if (string2 == null) {
                    string2 = "First text";
                }
                bl = true;
                arrayList.add(new Object[]{object, simpleNode.getContent()});
            }
            if (bl) continue;
            if (((SimpleNode)object).getFirstAttributeValue() != null) {
                if (string2 == null) {
                    string2 = "First attribute";
                }
                arrayList.add(new Object[]{object, ((SimpleNode)object).getFirstAttributeValue()});
                continue;
            }
            arrayList.add(new Object[]{object});
        }
        object = null;
        object = string2 != null ? new DefaultTableModel(0, 2) : new DefaultTableModel(0, 1);
        for (int i = 0; i < arrayList.size(); ++i) {
            ((DefaultTableModel)object).addRow((Object[])arrayList.get(i));
        }
        if (string2 != null) {
            ((DefaultTableModel)object).setColumnIdentifiers(new String[]{"Node (" + arrayList.size() + " found)", string2});
        } else {
            ((DefaultTableModel)object).setColumnIdentifiers(new String[]{"Node (" + arrayList.size() + " found)"});
        }
        this.tbResult.setModel((TableModel)object);
    }

    private void unshowResult() {
        DefaultTableModel defaultTableModel = new DefaultTableModel(new String[]{" No result "}, 0);
        this.tbResult.setModel(defaultTableModel);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = this.tbResult.getSelectedRow();
        if (n > -1) {
            boolean bl;
            SimpleNode simpleNode = (SimpleNode)this.tbResult.getModel().getValueAt(n, 0);
            if (this.lastDocumentLocation != null && !(bl = EditixFrame.ACCESSOR.activeXMLContainer(this.lastDocumentLocation))) {
                return;
            }
            XMLContainer xMLContainer = EditixFrame.ACCESSOR.getSelectedContainer();
            if (simpleNode.getStartingLine() > 0 && xMLContainer != null) {
                xMLContainer.getEditor().highlightLine(simpleNode.getStartingLine());
            }
        }
    }
}

