/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.ui;

import com.japisoft.css.CSSEditor;
import com.japisoft.editix.action.dtdschema.CustomXSDEditorAction;
import com.japisoft.editix.action.xsl.XSLTDialog;
import com.japisoft.editix.document.DocumentModel;
import com.japisoft.editix.ui.EditixErrorPanel;
import com.japisoft.editix.ui.EditixFrame;
import com.japisoft.editix.ui.EditixXMLContainer;
import com.japisoft.editix.ui.EditixXSLTFactoryImpl;
import com.japisoft.editix.ui.EncodingMenuBuilder;
import com.japisoft.editix.ui.FilePreferenceImpl;
import com.japisoft.editix.ui.XSDFactoryImpl;
import com.japisoft.editix.ui.xsd.XSDEditor;
import com.japisoft.editix.ui.xsd.XSDEditorObserver;
import com.japisoft.editix.ui.xslt.XSLTBookmarkContext;
import com.japisoft.editix.ui.xslt.XSLTEditor;
import com.japisoft.editix.ui.xslt.XSLTFilesListener;
import com.japisoft.framework.application.descriptor.ActionModel;
import com.japisoft.framework.preferences.Preferences;
import com.japisoft.framework.toolkit.Logger;
import com.japisoft.framework.ui.FastLabel;
import com.japisoft.framework.xml.XMLFileData;
import com.japisoft.p2.Manager;
import com.japisoft.universalbrowser.FileFilter;
import com.japisoft.universalbrowser.FileView;
import com.japisoft.universalbrowser.JUniversalBrowserTree;
import com.japisoft.xmlform.designer.DesignerEditor;
import com.japisoft.xmlform.editor.FormEditor;
import com.japisoft.xmlpad.IXMLPanel;
import com.japisoft.xmlpad.XMLContainer;
import com.japisoft.xmlpad.XMLDocumentInfo;
import com.japisoft.xquery.XQueryContainer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.HeadlessException;
import java.io.File;
import java.net.URL;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import org.apache.commons.vfs.FileObject;

public class EditixFactory {
    private static JFileChooser fileChooser = null;
    private static JFileChooser projectChooser = null;
    static XSLTFilesListener xsltListener = null;

    public static IXMLPanel buildNewContainer() {
        return EditixFactory.buildNewContainer(false);
    }

    public static XSLTDialog getConfigDialog(boolean bl) {
        if (!bl) {
            return new XSLTDialog();
        }
        XSLTDialog xSLTDialog = new XSLTDialog("XQuery", "XQuery parameters", "Use the check icon for checking your syntax\nStore these parameters using a project for the next time", true);
        return xSLTDialog;
    }

    public static IXMLPanel buildNewContainer(String string, XMLFileData xMLFileData) {
        int n = string.lastIndexOf(".");
        String string2 = null;
        if (n > -1) {
            string2 = string.substring(n + 1);
        }
        XMLDocumentInfo xMLDocumentInfo = DocumentModel.getDocumentForExt(string2);
        return EditixFactory.buildNewContainerWithType(xMLDocumentInfo.getType(), xMLFileData);
    }

    public static IXMLPanel buildNewContainer(String string) {
        XMLDocumentInfo xMLDocumentInfo;
        int n = string.lastIndexOf(".");
        String string2 = null;
        if (n > -1) {
            string2 = string.substring(n + 1);
        }
        if ((xMLDocumentInfo = DocumentModel.getDocumentForExt(string2)) != null) {
            IXMLPanel iXMLPanel = EditixFactory.getPanelForType(xMLDocumentInfo.getType());
            iXMLPanel.getMainContainer().setDocumentInfo(xMLDocumentInfo);
            return iXMLPanel;
        }
        return EditixFactory.buildNewContainer(false);
    }

    public static IXMLPanel buildNewContainer(String string, String string2) {
        XMLDocumentInfo xMLDocumentInfo = null;
        if (string != null) {
            xMLDocumentInfo = DocumentModel.getDocumentForType(string);
        }
        if (xMLDocumentInfo != null) {
            IXMLPanel iXMLPanel = EditixFactory.getPanelForType(xMLDocumentInfo.getType());
            iXMLPanel.setDocumentInfo(xMLDocumentInfo);
            return iXMLPanel;
        }
        return EditixFactory.buildNewContainer(false);
    }

    public static IXMLPanel buildNewContainerWithType(String string, XMLFileData xMLFileData) {
        XMLDocumentInfo xMLDocumentInfo = DocumentModel.getDocumentForType(string);
        IXMLPanel iXMLPanel = null;
        if (xMLDocumentInfo != null) {
            iXMLPanel = EditixFactory.getPanelForType(xMLDocumentInfo.getType());
            iXMLPanel.setDocumentInfo(xMLDocumentInfo);
        } else {
            iXMLPanel = EditixFactory.buildNewContainer(false);
        }
        iXMLPanel.getMainContainer().setText(xMLFileData.getContent());
        iXMLPanel.getMainContainer().getDocumentInfo().setEncoding(xMLFileData.getEncoding());
        return iXMLPanel;
    }

    public static IXMLPanel getPanelForDocument(XMLDocumentInfo xMLDocumentInfo) {
        return EditixFactory.getPanelForType(xMLDocumentInfo.getType());
    }

    public static IXMLPanel getPanelForType(String string) {
        if (!Manager.isFree()) {
            if ("EXF".equals(string)) {
                DesignerEditor designerEditor = new DesignerEditor(new EditixXSLTFactoryImpl());
                return designerEditor;
            }
            if ("XXF".equals(string)) {
                FormEditor formEditor = new FormEditor(new EditixXSLTFactoryImpl());
                return formEditor;
            }
        }
        if ("XQR".equals(string)) {
            XQueryContainer xQueryContainer = new XQueryContainer(new EditixXSLTFactoryImpl(), true, ActionModel.restoreAction("parseXQuery"));
            xQueryContainer.getMainContainer().setErrorPanelAvailable(true);
            xQueryContainer.getMainContainer().getUIAccessibility().setErrorView(new EditixErrorPanel());
            xQueryContainer.setPreference(FilePreferenceImpl.getSingleton());
            xQueryContainer.setProperty(XSLTEditor.ENCODING, Preferences.getPreference("file", "rw-encoding", new String[0])[0]);
            return xQueryContainer;
        }
        if ("CSS".equals(string)) {
            CSSEditor cSSEditor = new CSSEditor(ActionModel.restoreAction("parseCSS"));
            cSSEditor.setErrorPanelAvailable(true);
            cSSEditor.getUIAccessibility().setErrorView(new EditixErrorPanel());
            cSSEditor.setDisposeAction(false);
            return cSSEditor;
        }
        if ("XSD".equals(string)) {
            XSDEditor xSDEditor = new XSDEditor(new XSDFactoryImpl());
            xSDEditor.setCustomActionListener(new CustomXSDEditorAction());
            xSDEditor.setObserver(new XSDEditorObserver(){

                public void switchToView(XSDEditor xSDEditor, boolean bl) {
                    if (bl) {
                        EditixFrame.ACCESSOR.getBuilder().pushAction(xSDEditor.getAction("copy"), "copy");
                        EditixFrame.ACCESSOR.getBuilder().pushAction(xSDEditor.getAction("cut"), "cut");
                        EditixFrame.ACCESSOR.getBuilder().pushAction(xSDEditor.getAction("paste"), "paste");
                    } else {
                        EditixFrame.ACCESSOR.getBuilder().popAction("copy");
                        EditixFrame.ACCESSOR.getBuilder().popAction("cut");
                        EditixFrame.ACCESSOR.getBuilder().popAction("paste");
                    }
                }
            });
            return xSDEditor;
        }
        if (string.startsWith("XSLT")) {
            XSLTEditor xSLTEditor = new XSLTEditor(EditixFactory.getXSLTFilesListenerInstance(), new EditixXSLTFactoryImpl(), true);
            xSLTEditor.getMainContainer().getDocumentColorAccessibility().setBackgroundColorForPrefix("xsl", Preferences.getPreference("editor", "xsltbackground", new Color(200, 200, 240)));
            xSLTEditor.setPreference(FilePreferenceImpl.getSingleton());
            xSLTEditor.getMainContainer().setBookmarkContext(new XSLTBookmarkContext());
            xSLTEditor.setProperty(XSLTEditor.ENCODING, Preferences.getPreference("file", "rw-encoding", new String[0])[0]);
            return xSLTEditor;
        }
        if ("DTD".equals(string)) {
            EditixXMLContainer editixXMLContainer = new EditixXMLContainer(){

                public Action getAction(String string) {
                    if ("parse".equals(string)) {
                        return ActionModel.restoreAction("parseDTD");
                    }
                    return super.getAction(string);
                }
            };
            return editixXMLContainer;
        }
        return new EditixXMLContainer();
    }

    public static IXMLPanel buildNewContainer(boolean bl) {
        EditixXMLContainer editixXMLContainer = new EditixXMLContainer();
        editixXMLContainer.setDocumentInfo(DocumentModel.getDocumentForType("XML"));
        if (bl) {
            editixXMLContainer.getDocumentInfo().setCurrentDocumentLocation("Empty.xml");
        }
        return editixXMLContainer;
    }

    public static JFileChooser buildFileChooser() {
        if (fileChooser != null) {
            return fileChooser;
        }
        CustomJFileChooser customJFileChooser = new CustomJFileChooser();
        fileChooser = customJFileChooser;
        customJFileChooser.setFileSelectionMode(0);
        customJFileChooser.setMultiSelectionEnabled(true);
        javax.swing.filechooser.FileFilter fileFilter = null;
        for (int i = 0; i < DocumentModel.getDocumentCount(); ++i) {
            XMLDocumentInfo xMLDocumentInfo = DocumentModel.getDocumentAt(i);
            customJFileChooser.addChoosableFileFilter(xMLDocumentInfo.getFileFilter());
            if (fileFilter != null) continue;
            fileFilter = xMLDocumentInfo.getFileFilter();
        }
        customJFileChooser.setFileFilter(fileFilter);
        return customJFileChooser;
    }

    public static JFileChooser buildFileChooserForDocumentType(String string) {
        XMLDocumentInfo xMLDocumentInfo = DocumentModel.getDocumentForType(string);
        if (xMLDocumentInfo == null) {
            return EditixFactory.buildFileChooser();
        }
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setFileFilter(xMLDocumentInfo.getFileFilter());
        return jFileChooser;
    }

    public static JFileChooser buildProjectFileChooser() {
        JFileChooser jFileChooser;
        if (projectChooser != null) {
            return projectChooser;
        }
        projectChooser = jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setFileFilter(new javax.swing.filechooser.FileFilter(){

            public String getDescription() {
                return "*.pre (editix project file)";
            }

            public boolean accept(File file) {
                return file.isDirectory() || file.toString().toLowerCase().endsWith(".pre");
            }
        });
        return jFileChooser;
    }

    public static boolean mustSaveDialog(XMLContainer xMLContainer) {
        if (xMLContainer.getDocumentInfo().getCurrentDocumentLocation() == null || xMLContainer.getDocumentInfo().getCurrentDocumentLocation().indexOf("://") != -1) {
            EditixFactory.buildAndShowErrorDialog("Please save your current document before operating");
            return true;
        }
        return false;
    }

    public static void buildAndShowErrorDialog(String string) {
        if (EditixFrame.ACCESSOR != null && EditixFrame.ACCESSOR.isVisible()) {
            JOptionPane.showMessageDialog(EditixFrame.ACCESSOR, string, "Error", 0);
        }
    }

    public static void buildAndShowWarningDialog(String string) {
        if (EditixFrame.ACCESSOR != null && EditixFrame.ACCESSOR.isVisible()) {
            JOptionPane.showMessageDialog(EditixFrame.ACCESSOR, string, "Warning", 2);
        }
    }

    public static String buildAndShowInputDialog(String string) {
        return JOptionPane.showInputDialog(EditixFrame.ACCESSOR.getComponent(0), (Object)string);
    }

    public static String buildAndShowInputDialog(String string, String string2) {
        return JOptionPane.showInputDialog(EditixFrame.ACCESSOR.getComponent(0), string, string2);
    }

    public static void buildAndShowInformationDialog(String string) {
        JOptionPane.showMessageDialog(EditixFrame.ACCESSOR, string, "Info", 1);
    }

    public static int buildAndShowChoiceDialog(String string) {
        return JOptionPane.showConfirmDialog(EditixFrame.ACCESSOR, string, "Choice", 0);
    }

    public static boolean buildAndShowConfirmDialog(String string) {
        return EditixFactory.buildAndShowChoiceDialog(string) == 0;
    }

    public static ImageIcon getImageIcon(String string) {
        URL uRL = ClassLoader.getSystemClassLoader().getResource(string);
        if (uRL != null) {
            return new ImageIcon(uRL);
        }
        Logger.addWarning("Can't find " + string);
        return null;
    }

    public static JUniversalBrowserTree getUniversalBrowserTree() {
        JUniversalBrowserTree jUniversalBrowserTree = new JUniversalBrowserTree();
        jUniversalBrowserTree.setFileView(new CustomFileView());
        return jUniversalBrowserTree;
    }

    public static JComboBox getFileFilterComboBox() {
        JComboBox jComboBox = new JComboBox();
        EditixFactory.fillComboBoxFilter(jComboBox);
        return jComboBox;
    }

    public static void fillComboBoxFilter(JComboBox jComboBox) {
        for (int i = 0; i < DocumentModel.getDocumentCount(); ++i) {
            XMLDocumentInfo xMLDocumentInfo = DocumentModel.getDocumentAt(i);
            jComboBox.addItem(new XMLDocumentInfoFileFilter(xMLDocumentInfo));
        }
        jComboBox.setRenderer(new ComboBoxFileFilterRenderer());
    }

    static XSLTFilesListener getXSLTFilesListenerInstance() {
        if (xsltListener == null) {
            xsltListener = new XSLTFilesListenersImpl();
        }
        return xsltListener;
    }

    static class XSLTFilesListenersImpl
    implements XSLTFilesListener {
        XSLTFilesListenersImpl() {
        }

        public void setCurrentContainer(XMLContainer xMLContainer) {
            EditixFrame.ACCESSOR.updateCurrentXMLContainer(xMLContainer);
        }
    }

    public static class XMLDocumentInfoFileFilter
    implements FileFilter {
        XMLDocumentInfo delegate = null;

        public XMLDocumentInfoFileFilter(XMLDocumentInfo xMLDocumentInfo) {
            this.delegate = xMLDocumentInfo;
        }

        public boolean accept(File file) {
            return this.delegate.getFileFilter().accept(file);
        }

        public String getDescription() {
            return this.delegate.getDocumentDescription();
        }

        public Icon getIcon() {
            return this.delegate.getDocumentIcon();
        }

        public String getType() {
            return this.delegate.getType();
        }

        public boolean accept(FileObject fileObject) {
            return this.accept(new File(fileObject.getName().getBaseName()));
        }

        public String toString() {
            return this.getDescription();
        }
    }

    static class CustomFileView
    implements FileView {
        CustomFileView() {
        }

        public Color getBackground(FileObject fileObject) {
            return null;
        }

        public Color getForeground(FileObject fileObject) {
            return null;
        }

        public Icon getIcon(FileObject fileObject) {
            String string = fileObject.getName().getBaseName();
            if (string.indexOf(".") == -1) {
                return null;
            }
            File file = new File(string);
            for (int i = 0; i < DocumentModel.getDocumentCount(); ++i) {
                XMLDocumentInfo xMLDocumentInfo = DocumentModel.getDocumentAt(i);
                if (!xMLDocumentInfo.getFileFilter().accept(file)) continue;
                return xMLDocumentInfo.getDocumentIcon();
            }
            return null;
        }
    }

    public static class CustomJFileChooser
    extends JFileChooser {
        private JComboBox combo;

        protected JDialog createDialog(Component component) throws HeadlessException {
            JDialog jDialog = super.createDialog(component);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
            JLabel jLabel = new JLabel("Be sure to select the right file filter (XML, XSLT...) before opening a file.");
            jLabel.setForeground(Color.blue);
            jPanel.add((Component)jLabel, "Center");
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BorderLayout());
            this.combo = EncodingMenuBuilder.encodingComboBox();
            jPanel2.add((Component)new JLabel("Encoding :"), "Center");
            jPanel2.add((Component)this.combo, "South");
            jPanel.add((Component)jPanel2, "South");
            jDialog.getContentPane().add("South", jPanel);
            return jDialog;
        }

        public int showDialog(Component component, String string) throws HeadlessException {
            return super.showDialog(component, string);
        }

        public String getSelectedEncoding() {
            return (String)this.combo.getSelectedItem();
        }
    }

    static class ComboBoxFileFilterRenderer
    implements ListCellRenderer {
        FastLabel lbl = new FastLabel();

        ComboBoxFileFilterRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (bl) {
                this.lbl.setBackground(jList.getSelectionBackground());
                this.lbl.setForeground(jList.getSelectionForeground());
            } else {
                this.lbl.setBackground(jList.getBackground());
                this.lbl.setForeground(jList.getForeground());
            }
            if (object instanceof String) {
                this.lbl.setText(object.toString());
                this.lbl.setIcon(null);
                return this.lbl;
            }
            XMLDocumentInfoFileFilter xMLDocumentInfoFileFilter = (XMLDocumentInfoFileFilter)object;
            this.lbl.setText(xMLDocumentInfoFileFilter.getDescription());
            this.lbl.setIcon(xMLDocumentInfoFileFilter.getIcon());
            return this.lbl;
        }
    }
}

