/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.db;

import com.japisoft.editix.db.NodeDb;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public abstract class AbstractNodeDb
implements TreeNode,
NodeDb {
    protected String url = null;
    protected String user = null;
    protected String password = null;
    protected ArrayList children = null;
    protected MutableTreeNode parent = null;
    private boolean open = false;
    private boolean error = false;
    private String errorMessage = null;
    protected String driverName;
    protected String name;

    public void setParent(NodeDb nodeDb) {
        this.parent = nodeDb;
    }

    public void setParent(MutableTreeNode mutableTreeNode) {
        this.parent = mutableTreeNode;
    }

    public void addChild(NodeDb nodeDb) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        nodeDb.setParent(this);
        String string = nodeDb.toString();
        boolean bl = false;
        for (int i = 0; i < this.children.size(); ++i) {
            NodeDb nodeDb2 = (NodeDb)this.children.get(i);
            if (nodeDb2.toString().compareTo(string) <= 0) continue;
            this.children.add(i, nodeDb);
            bl = true;
            break;
        }
        if (!bl) {
            this.children.add(nodeDb);
        }
    }

    public Enumeration children() {
        this.checkOpen();
        if (this.children == null) {
            return null;
        }
        return Collections.enumeration(this.children);
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public TreeNode getChildAt(int n) {
        this.checkOpen();
        return (TreeNode)this.children.get(n);
    }

    private void checkOpen() {
        if (!this.open) {
            if (this.children == null) {
                try {
                    this.open();
                }
                catch (Exception exception) {
                    this.error = true;
                    this.errorMessage = exception.getMessage();
                }
            }
            this.open = true;
        }
    }

    public int getChildCount() {
        this.checkOpen();
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    public int getIndex(TreeNode treeNode) {
        if (this.children == null) {
            return -1;
        }
        return this.children.indexOf(treeNode);
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public boolean isLeaf() {
        this.checkOpen();
        return this.children == null || this.children.size() == 0;
    }

    public void close() {
        this.open = false;
        this.children = null;
        this.errorMessage = null;
        this.error = false;
    }

    public void open() throws Exception {
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean hasError() {
        return this.error;
    }

    public void setUserObject(Object object) {
    }

    public void insert(MutableTreeNode mutableTreeNode, int n) {
    }

    public void remove(int n) {
    }

    public void remove(MutableTreeNode mutableTreeNode) {
        if (this.children != null) {
            this.children.remove(mutableTreeNode);
        }
    }

    public void removeFromParent() {
    }

    public void setDriverName(String string) {
        this.driverName = string;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public boolean canBeDeleted() {
        return true;
    }

    public boolean delete() throws Exception {
        if (this.parent != null) {
            this.close();
            this.parent.remove(this);
            return true;
        }
        return false;
    }

    protected void prepareName() {
    }

    public String toString() {
        if (this.name == null) {
            this.prepareName();
        }
        return this.name;
    }

    public void refresh() throws Exception {
        for (int i = 0; i < this.getChildCount(); ++i) {
            NodeDb nodeDb = (NodeDb)this.getChildAt(i);
            nodeDb.close();
        }
        this.children = null;
        this.open();
    }
}

