/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.action.xsl;

import com.japisoft.editix.action.xsl.XSLTDialog;
import com.japisoft.editix.ui.EditixFactory;
import com.japisoft.editix.ui.EditixFrame;
import com.japisoft.editix.xslt.debug.XSLTManager;
import com.japisoft.framework.ui.toolkit.BrowserCaller;
import com.japisoft.p2.Manager;
import com.japisoft.xmlpad.IXMLPanel;
import com.japisoft.xmlpad.XMLContainer;
import com.japisoft.xmlpad.action.ActionModel;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class XSLTDebugAction
extends AbstractAction {
    public void actionPerformed(ActionEvent actionEvent) {
        if (Manager.isFree()) {
            EditixFactory.buildAndShowInformationDialog("This action is not available inside the Free Edition.\nPlease look at http://www.editix.com");
            BrowserCaller.displayURL("http://www.editix.com");
            return;
        }
        XMLContainer xMLContainer = EditixFrame.ACCESSOR.getSelectedContainer();
        IXMLPanel iXMLPanel = EditixFrame.ACCESSOR.getSelectedPanel();
        if (xMLContainer == null) {
            return;
        }
        if (EditixFactory.mustSaveDialog(xMLContainer)) {
            return;
        }
        boolean bl = ActionModel.activeActionByName(ActionModel.SAVE_ACTION, xMLContainer, xMLContainer.getEditor());
        if (!bl) {
            return;
        }
        if (!XSLTManager.hasBreakpoint(iXMLPanel)) {
            EditixFactory.buildAndShowErrorDialog("No breakpoint found for debugging !\nClick on the left column of the editor for adding/removing a breakpoint");
            return;
        }
        if (!"true".equals(xMLContainer.getProperty("xslt.ok"))) {
            XSLTDialog xSLTDialog = new XSLTDialog();
            xSLTDialog.init(iXMLPanel);
            xSLTDialog.setVisible(true);
            xSLTDialog.dispose();
            if (xSLTDialog.isOk()) {
                xSLTDialog.store(iXMLPanel);
                XSLTManager.startDebug(iXMLPanel);
            }
        } else {
            XSLTManager.startDebug(iXMLPanel);
        }
    }
}

