/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.action.xml;

import com.japisoft.editix.ui.EditixDialog;
import com.japisoft.editix.ui.EditixFactory;
import com.japisoft.editix.ui.EditixFrame;
import com.japisoft.editix.ui.panels.diff.DiffPanel;
import com.japisoft.fastparser.node.SimpleNode;
import com.japisoft.framework.dialog.actions.DialogActionModel;
import com.japisoft.framework.dialog.actions.StoringLocationAction;
import com.japisoft.framework.ui.toolkit.BrowserCaller;
import com.japisoft.p2.Manager;
import com.japisoft.xmlpad.XMLContainer;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class XMLDiffAction
extends AbstractAction {
    public void actionPerformed(ActionEvent actionEvent) {
        if (Manager.isFree()) {
            EditixFactory.buildAndShowInformationDialog("This action is not available inside the Free Edition.\nPlease look at http://www.editix.com");
            BrowserCaller.displayURL("http://www.editix.com");
            return;
        }
        EditixDialog editixDialog = new EditixDialog("XML diff", "Compare XML documents", "Select both documents to compare the XML content", DialogActionModel.getDefaultDialogCloseActionModel().addDialogAction(new StoringLocationAction()));
        XMLContainer xMLContainer = EditixFrame.ACCESSOR.getSelectedContainer();
        editixDialog.getContentPane().add(new DiffPanel(xMLContainer));
        editixDialog.setSize(650, 550);
        editixDialog.setModal(false);
        editixDialog.setVisible(true);
    }

    public void select(String string, SimpleNode simpleNode) {
        XMLContainer xMLContainer = EditixFrame.ACCESSOR.getSelectedContainer();
        if (xMLContainer != null && xMLContainer.getCurrentDocumentLocation() == null || string.equals(xMLContainer.getCurrentDocumentLocation())) {
            xMLContainer.getEditor().highlightLine(simpleNode.getStartingLine());
        }
    }
}

