/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.action.file;

import com.japisoft.editix.action.file.CloseAllAction;
import com.japisoft.editix.project.ProjectManager;
import com.japisoft.editix.ui.EditixFactory;
import com.japisoft.editix.ui.EditixFrame;
import com.japisoft.editix.ui.panels.PanelManager;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;

public class OpenProjectAction
extends AbstractAction {
    private boolean canCloseProject(ActionEvent actionEvent) {
        CloseAllAction.RETURN_STATUS = true;
        return CloseAllAction.RETURN_STATUS;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.getValue("param") != null) {
            if (!this.canCloseProject(actionEvent)) {
                return;
            }
            OpenProjectAction.openProject(true, "" + this.getValue("param"));
            return;
        }
        JFileChooser jFileChooser = EditixFactory.buildProjectFileChooser();
        if (jFileChooser.showOpenDialog(EditixFrame.ACCESSOR.getComponent(0)) == 0) {
            File file = jFileChooser.getSelectedFile();
            if (!file.exists() || !this.canCloseProject(actionEvent)) {
                if (!file.exists()) {
                    EditixFactory.buildAndShowErrorDialog("Can't load " + file);
                }
                return;
            }
            OpenProjectAction.openProject(false, file.toString());
        } else {
            EditixFrame.ACCESSOR.checkOneContainer();
        }
    }

    public static void openProject(boolean bl, String string) {
        PanelManager.initByAction("projectManager");
        boolean bl2 = ProjectManager.openProject(string);
        if (!bl2) {
            EditixFactory.buildAndShowErrorDialog("Can't load " + string);
            EditixFrame.ACCESSOR.getBuilder().removeMenuItemForParam("prjOpenRecent", string);
            EditixFrame.ACCESSOR.checkOneContainer();
            return;
        }
        if (!bl) {
            OpenProjectAction.updateOpenRecent(string);
        }
    }

    static void updateOpenRecent(String string) {
        if (string != null) {
            OpenProjectAction openProjectAction = new OpenProjectAction();
            openProjectAction.putValue("Name", string);
            openProjectAction.putValue("param", string);
            openProjectAction.putValue("iconPath", "images/package.png");
            EditixFrame.ACCESSOR.getBuilder().insertMenuItemAtFirst("prjOpenRecent", openProjectAction, 20);
        }
    }
}

