/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.action.dtdschema.generator.transformer;

import com.japisoft.editix.action.dtdschema.generator.MetaAttribute;
import com.japisoft.editix.action.dtdschema.generator.MetaNode;
import com.japisoft.editix.action.dtdschema.generator.Transformer;
import com.japisoft.xmlpad.action.ActionModel;
import java.util.ArrayList;
import java.util.Vector;

public class TemplateTransformer
implements Transformer {
    public String transform(MetaNode metaNode, ArrayList arrayList) {
        StringBuffer stringBuffer = new StringBuffer();
        this.transform(0, metaNode, arrayList, stringBuffer);
        return stringBuffer.toString();
    }

    public boolean hasVersion() {
        return true;
    }

    void transform(int n, MetaNode metaNode, ArrayList arrayList, StringBuffer stringBuffer) {
        if (metaNode.getChildren().size() > 0) {
            this.addRootHeader(n, metaNode, stringBuffer, false);
            Character c = (Character)ActionModel.getProperty(ActionModel.FORMAT_ACTION, "indent-char", new Character(' '));
            Vector vector = metaNode.getChildren();
            for (int i = 0; i < vector.size(); ++i) {
                this.transform(n + 1, (MetaNode)vector.get(i), arrayList, stringBuffer);
            }
            this.addRootFooter(n, metaNode, stringBuffer);
        } else if (metaNode.acceptText()) {
            this.addRootHeader(n, metaNode, stringBuffer, false);
            this.addRootFooter(n, metaNode, stringBuffer);
        } else {
            this.addRootHeader(n, metaNode, stringBuffer, true);
        }
    }

    private void indent(int n, StringBuffer stringBuffer) {
        Character c = (Character)ActionModel.getProperty(ActionModel.FORMAT_ACTION, "indent-char", new Character(' '));
        Integer n2 = (Integer)ActionModel.getProperty(ActionModel.FORMAT_ACTION, "indent-size", new Integer(1));
        for (int i = 0; i < n * n2; ++i) {
            stringBuffer.append(c);
        }
    }

    void addRootHeader(int n, MetaNode metaNode, StringBuffer stringBuffer, boolean bl) {
        stringBuffer.append(System.getProperty("line.separator"));
        this.indent(n, stringBuffer);
        stringBuffer.append("<").append(metaNode.getName());
        if (metaNode.hasAttributes()) {
            stringBuffer.append(" ");
            Vector vector = metaNode.getAttributes();
            for (int i = 0; i < vector.size(); ++i) {
                if (i > 0) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(((MetaAttribute)vector.get(i)).getName()).append("=").append("\"\"");
            }
            if (bl) {
                stringBuffer.append("/>");
            } else {
                stringBuffer.append(">");
            }
        } else if (bl) {
            stringBuffer.append("/>");
        } else {
            stringBuffer.append(">");
        }
    }

    void addRootFooter(int n, MetaNode metaNode, StringBuffer stringBuffer) {
        stringBuffer.append(System.getProperty("line.separator"));
        this.indent(n, stringBuffer);
        stringBuffer.append("</").append(metaNode.getName()).append(">");
    }

    public String getType() {
        return "XML";
    }
}

