/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.action.dtdschema;

import com.japisoft.editix.EditixApplicationModel;
import com.japisoft.editix.action.xml.format.FormatAction;
import com.japisoft.editix.ui.EditixFactory;
import com.japisoft.editix.ui.EditixFrame;
import com.japisoft.fastparser.node.SimpleNode;
import com.japisoft.framework.ui.toolkit.BrowserCaller;
import com.japisoft.framework.xml.dtd.instance.DTDInstanceGenerator;
import com.japisoft.framework.xml.xsd.instance.XSDInstanceGenerator;
import com.japisoft.p2.Manager;
import com.japisoft.xmlpad.IXMLPanel;
import com.japisoft.xmlpad.XMLContainer;
import com.japisoft.xmlpad.editor.XMLDocument;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class GenerateTemplateAction
extends AbstractAction {
    public void actionPerformed(ActionEvent actionEvent) {
        if (Manager.isFree()) {
            EditixFactory.buildAndShowInformationDialog("This action is not available inside the Free Edition.\nPlease look at http://www.editix.com");
            BrowserCaller.displayURL("http://www.editix.com");
            return;
        }
        XMLContainer xMLContainer = EditixFrame.ACCESSOR.getSelectedContainer();
        if (xMLContainer.getCurrentDocumentLocation() == null) {
            EditixFactory.buildAndShowWarningDialog("Please save your document for generating a template");
            return;
        }
        String string = xMLContainer.getDocumentInfo().getType();
        if ("DTD".equals(string)) {
            XMLDocument xMLDocument = xMLContainer.getDocument();
            String string2 = xMLDocument.getDTDElementDefinitionFor(xMLContainer.getCaretPosition());
            if (string2 == null) {
                EditixFactory.buildAndShowErrorDialog("Select a line with an element definition");
            } else {
                try {
                    String string3 = DTDInstanceGenerator.generateXMLInstance(string2, xMLContainer.getCurrentDocumentLocation(), null);
                    IXMLPanel iXMLPanel = EditixFactory.buildNewContainer();
                    string3 = "<?xml version='1.0' encoding='UTF-8'?>\n\n<!DOCTYPE " + string2 + " SYSTEM " + "\"" + xMLContainer.getCurrentDocumentLocation() + "\">\n" + string3;
                    iXMLPanel.getMainContainer().setText(string3);
                    FormatAction.format(iXMLPanel.getMainContainer(), null, null, "silence");
                    EditixFrame.ACCESSOR.addContainer(iXMLPanel);
                }
                catch (Throwable throwable) {
                    EditixApplicationModel.debug(throwable);
                    EditixFactory.buildAndShowErrorDialog("Can't build this template");
                }
            }
        } else if ("XSD".equals(string)) {
            SimpleNode simpleNode = xMLContainer.getCurrentElementNode();
            if (simpleNode.matchContent("element")) {
                String string4 = simpleNode.getAttribute("name");
                if (string4 == null) {
                    string4 = simpleNode.getAttribute("ref");
                }
                if (string4 == null) {
                    EditixFactory.buildAndShowErrorDialog("Can't find a name in this element definition ?");
                } else {
                    try {
                        int n;
                        String string5 = XSDInstanceGenerator.generateXMLInstance(string4, xMLContainer.getCurrentDocumentLocation());
                        SimpleNode simpleNode2 = (SimpleNode)simpleNode.getDocument().getRoot();
                        String string6 = null;
                        if (simpleNode2.hasAttribute("targetNamespace")) {
                            string6 = simpleNode2.getAttribute("targetNamespace");
                        }
                        if ((n = string5.indexOf("<" + string4)) > -1) {
                            string5 = string5.substring(0, n + 1 + string4.length()) + string5.substring(n + 1 + string4.length());
                        }
                        String string7 = "<?xml version='1.0' encoding='UTF-8'?>\n";
                        string7 = string7 + string5;
                        IXMLPanel iXMLPanel = EditixFactory.buildNewContainer();
                        iXMLPanel.getMainContainer().setText(string7);
                        FormatAction.format(iXMLPanel.getMainContainer(), null, null, "silence");
                        EditixFrame.ACCESSOR.addContainer(iXMLPanel);
                    }
                    catch (Throwable throwable) {
                        EditixApplicationModel.debug(throwable);
                        EditixFactory.buildAndShowErrorDialog("Can't build this template");
                    }
                }
            } else {
                EditixFactory.buildAndShowErrorDialog("Select a line with an element definition");
            }
        }
    }
}

