/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.action.dtdschema;

import com.japisoft.editix.ui.EditixFactory;
import com.japisoft.editix.ui.EditixFrame;
import com.japisoft.editix.ui.XSDFactoryImpl;
import com.japisoft.editix.ui.xsd.toolkit.SchemaHelper;
import com.japisoft.editix.ui.xsd.view.DesignerViewImpl;
import com.japisoft.editix.ui.xsd.view.designer.XSDAbstractComponentImpl;
import com.japisoft.editix.ui.xsd.view.designer.XSDComponent;
import com.japisoft.framework.ApplicationModel;
import com.japisoft.framework.ui.toolkit.BrowserCaller;
import com.japisoft.framework.ui.toolkit.FileManager;
import com.japisoft.p2.Manager;
import com.japisoft.xmlpad.IXMLPanel;
import com.japisoft.xmlpad.XMLContainer;
import com.japisoft.xmlpad.xml.validator.DefaultValidator;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GenerateSchemaDoc
extends AbstractAction {
    public static String getCommonHeader(XMLContainer xMLContainer) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<head>");
        stringBuffer.append("<title>");
        stringBuffer.append(xMLContainer.getDocumentInfo().getCurrentDocumentFileName());
        stringBuffer.append("</title>");
        stringBuffer.append("<style type='text/css'>");
        stringBuffer.append("body { font-family: Arial, Helvetica, sans-serif;\nbackgroundColor : white; } ");
        stringBuffer.append(".doc { width : 70%;\nbackground-color:#DDFFDD;\nborder-style : dashed; border-width : 1px; font-style:italic; }");
        stringBuffer.append(".name { font-weight : bolder; color : #20BB20; }");
        stringBuffer.append("</style>");
        stringBuffer.append("</head>");
        return stringBuffer.toString();
    }

    public static String getCommonFooter(XMLContainer xMLContainer) {
        return "<hr />\n<p style='text-align:center'><small>Generated with EditiX : <a href='http://www.editix.com'>http://www.editix.com</a> at " + new Date() + "</small></p>";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent actionEvent) {
        if (Manager.isFree()) {
            EditixFactory.buildAndShowInformationDialog("This action is not available inside the Free Edition.\nPlease look at http://www.editix.com");
            BrowserCaller.displayURL("http://www.editix.com");
            return;
        }
        XMLContainer xMLContainer = EditixFrame.ACCESSOR.getSelectedContainer();
        if (xMLContainer.getCurrentDocumentLocation() == null) {
            EditixFactory.buildAndShowErrorDialog("Please save your Schema before");
            return;
        }
        IXMLPanel iXMLPanel = EditixFrame.ACCESSOR.getSelectedPanel();
        iXMLPanel.prepareToSave();
        File file = FileManager.getSelectedFile(false, "html", "HTML output file");
        if (file != null) {
            DefaultValidator defaultValidator = new DefaultValidator(true);
            if (!defaultValidator.validate(xMLContainer, false)) {
                EditixFactory.buildAndShowErrorDialog("Error found inside the source\nPlease fix it");
                return;
            }
            Document document = defaultValidator.getDocument();
            Element element = document.getDocumentElement();
            if (element == null) {
                return;
            }
            try {
                PrintWriter printWriter = new PrintWriter(new FileWriter(file));
                try {
                    printWriter.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
                    printWriter.println("<html>");
                    printWriter.println(GenerateSchemaDoc.getCommonHeader(xMLContainer));
                    printWriter.println("<body>");
                    printWriter.println("<h1>");
                    printWriter.println("Schema <span class='name'>" + xMLContainer.getDocumentInfo().getCurrentDocumentFileName());
                    printWriter.println("</span></h1>");
                    printWriter.println("<p class='doc'>");
                    printWriter.println(this.getDocumentation(element));
                    printWriter.println("</p>");
                    NodeList nodeList = element.getChildNodes();
                    printWriter.println(this.getTM(nodeList));
                    boolean bl = false;
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        Element element2;
                        Node node = nodeList.item(i);
                        if (!(node instanceof Element) || "annotation".equals((element2 = (Element)node).getLocalName())) continue;
                        this.process(file, element2, printWriter);
                        bl = true;
                    }
                    printWriter.println(GenerateSchemaDoc.getCommonFooter(xMLContainer));
                    printWriter.println("</body>");
                    printWriter.println("</html>");
                }
                finally {
                    printWriter.close();
                }
                BrowserCaller.displayURL(file.toString());
            }
            catch (IOException iOException) {
                EditixFactory.buildAndShowErrorDialog("Can't create documentation : " + iOException.getMessage());
            }
        }
    }

    private String getTM(NodeList nodeList) {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || "annotation".equals((object = (Element)node).getLocalName())) continue;
            arrayList.add(this.getAnchor((Element)object));
        }
        Collections.sort(arrayList);
        String string = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            object = (String)arrayList.get(i);
            int n = ((String)object).indexOf(95);
            String string2 = ((String)object).substring(0, n);
            String string3 = ((String)object).substring(n + 1);
            if (!string2.equals(string)) {
                stringBuffer.append("<h3>").append(string2).append("</h3>");
            } else {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("<a href='#").append((String)object).append("'>").append(string3).append("</a>");
            string = string2;
        }
        return stringBuffer.toString();
    }

    private String getAnchor(Element element) {
        String string = element.getLocalName();
        return string + "_" + element.getAttribute("name");
    }

    private void process(File file, Element element, PrintWriter printWriter) {
        int n;
        Object object;
        Element element2;
        Element element3;
        int n2;
        Object object2;
        String string = element.getLocalName();
        printWriter.println("<hr color='gray' with='50%'>");
        printWriter.println("<a name='" + this.getAnchor(element) + "'>");
        printWriter.println("</a>");
        printWriter.println("<h2>");
        printWriter.println(Character.toUpperCase(string.charAt(0)) + string.substring(1));
        boolean bl = false;
        String string2 = null;
        if ("element".equals(string) && (object2 = SchemaHelper.getRef(element.getOwnerDocument().getDocumentElement(), "complexType", element.getAttribute("type"))) != null) {
            bl = true;
            string2 = this.getAnchor((Element)object2);
            printWriter.println("<a class='name' href='#" + string2 + "'>");
        }
        printWriter.println(" <span class='name'>");
        printWriter.println(element.getAttribute("name"));
        printWriter.println("</span>");
        if (bl) {
            printWriter.println("</a>");
        }
        printWriter.println("</h2>");
        printWriter.println("<p class='doc'>");
        printWriter.println(this.getDocumentation(element));
        printWriter.println("</p>");
        object2 = string + element.getAttribute("name") + ".png";
        try {
            if (GenerateSchemaDoc.generateImage(element, new File(file.getParentFile(), (String)object2))) {
                if (bl) {
                    printWriter.println("<a href='#" + string2 + "'>");
                }
                printWriter.println("<img border='0' src='" + (String)object2 + "'" + " alt='" + string + " " + element.getAttribute("name") + "'>");
                if (bl) {
                    printWriter.println("</a>");
                }
            }
        }
        catch (Throwable throwable) {
            ApplicationModel.debug(throwable);
        }
        NodeList nodeList = element.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "element");
        if (nodeList.getLength() > 0) {
            printWriter.println("<h3>Elements</h3>");
            printWriter.println("<table border='1'>");
            printWriter.println("<tr><th>Element</th><th>Type</th><th>Documentation</th></tr>");
            for (n2 = 0; n2 < nodeList.getLength(); ++n2) {
                element2 = element3 = (Element)nodeList.item(n2);
                printWriter.println("<tr>");
                printWriter.println("<td>");
                if (element3.hasAttribute("name")) {
                    printWriter.println(element3.getAttribute("name"));
                } else if (element3.hasAttribute("ref")) {
                    object = element3.getAttribute("ref");
                    element2 = SchemaHelper.getRef(element3.getOwnerDocument().getDocumentElement(), "element", element3.getAttribute("ref"));
                    if (element2 != null) {
                        printWriter.println("<a href='#" + this.getAnchor(element2) + "'>");
                    }
                    if ((n = ((String)object).indexOf(58)) > -1) {
                        printWriter.println(((String)object).substring(n + 1));
                    } else {
                        printWriter.println((String)object);
                    }
                    if (element2 != null) {
                        printWriter.println("</a>");
                    }
                }
                printWriter.println("</td>");
                printWriter.println("<td>");
                if (element2 == null) {
                    printWriter.println("?");
                } else {
                    object = SchemaHelper.getRef(element2.getOwnerDocument().getDocumentElement(), "complexType", element2.getAttribute("type"));
                    if (object != null) {
                        printWriter.println("<a href='#" + this.getAnchor((Element)object) + "'>" + object.getAttribute("name") + "</a>");
                    } else if (element2.hasAttribute("type")) {
                        printWriter.println(element2.getAttribute("type"));
                    } else {
                        printWriter.println("Local type");
                    }
                }
                printWriter.println("</td>");
                printWriter.println("<td class='doc'>");
                object = SchemaHelper.getDocumentation(element2 == null ? element3 : element2);
                if (object != null) {
                    printWriter.println((String)object);
                } else {
                    printWriter.println("No documentation");
                }
                printWriter.print("</td>");
                printWriter.println("</tr>");
            }
            printWriter.println("</table>");
        }
        if ((nodeList = element.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "attribute")).getLength() > 0) {
            printWriter.println("<h3>Attributes</h3>");
            printWriter.println("<table border='1'>");
            printWriter.println("<tr><th>Attribute</th><th>Type</th><th>Documentation</th></tr>");
            for (n2 = 0; n2 < nodeList.getLength(); ++n2) {
                element2 = element3 = (Element)nodeList.item(n2);
                printWriter.println("<tr>");
                printWriter.println("<td>");
                if (element3.hasAttribute("name")) {
                    printWriter.println(element3.getAttribute("name"));
                } else if (element3.hasAttribute("ref")) {
                    object = element3.getAttribute("ref");
                    element2 = SchemaHelper.getRef(element3.getOwnerDocument().getDocumentElement(), "attribute", element3.getAttribute("ref"));
                    if (element2 != null) {
                        printWriter.println("<a href='#" + this.getAnchor(element2) + "'>");
                    }
                    if ((n = ((String)object).indexOf(58)) > -1) {
                        printWriter.println(((String)object).substring(n + 1));
                    } else {
                        printWriter.println((String)object);
                    }
                    if (element2 != null) {
                        printWriter.println("</a>");
                    }
                }
                printWriter.println("</td>");
                printWriter.println("<td>");
                if (element2 == null) {
                    printWriter.println("?");
                } else {
                    object = SchemaHelper.getRef(element2.getOwnerDocument().getDocumentElement(), "simpleType", element2.getAttribute("type"));
                    if (object != null) {
                        printWriter.println("<a href='#" + this.getAnchor((Element)object) + "'>" + object.getAttribute("name") + "</a>");
                    } else if (element2.hasAttribute("type")) {
                        printWriter.println(element2.getAttribute("type"));
                    } else {
                        printWriter.println("Local type");
                    }
                }
                printWriter.println("</td>");
                printWriter.println("<td class='doc'>");
                object = SchemaHelper.getDocumentation(element2 == null ? element3 : element2);
                if (object != null) {
                    printWriter.println((String)object);
                } else {
                    printWriter.println("No documentation");
                }
                printWriter.print("</td>");
                printWriter.println("</tr>");
            }
            printWriter.println("</table>");
        }
    }

    public static boolean generateImage(Element element, File file) throws IOException {
        return GenerateSchemaDoc.generateImage(element, file, "PNG");
    }

    public static boolean generateImage(Element element, File file, String string) throws IOException {
        DesignerViewImpl designerViewImpl = new DesignerViewImpl(new XSDFactoryImpl());
        designerViewImpl.init(element);
        if (designerViewImpl.canInit()) {
            int n;
            JFrame jFrame = new JFrame();
            jFrame.setLocation(-100, -100);
            jFrame.setSize(0, 0);
            jFrame.getContentPane().add(new JScrollPane(designerViewImpl));
            jFrame.setVisible(true);
            designerViewImpl.openAll((XSDComponent)element.getUserData("ui"));
            int n2 = Integer.MAX_VALUE;
            for (n = 0; n < designerViewImpl.getComponentCount(); ++n) {
                XSDAbstractComponentImpl xSDAbstractComponentImpl;
                Component component = designerViewImpl.getComponent(n);
                if (!(component instanceof XSDAbstractComponentImpl) || (xSDAbstractComponentImpl = (XSDAbstractComponentImpl)component).getY() >= n2) continue;
                n2 = xSDAbstractComponentImpl.getY();
            }
            n2 = -n2;
            n = 0;
            int n3 = 0;
            for (int i = 0; i < designerViewImpl.getComponentCount(); ++i) {
                Component component = designerViewImpl.getComponent(i);
                if (!(component instanceof XSDAbstractComponentImpl)) continue;
                XSDAbstractComponentImpl xSDAbstractComponentImpl = (XSDAbstractComponentImpl)component;
                Rectangle rectangle = xSDAbstractComponentImpl.getView().getBounds();
                n = Math.max(rectangle.x + rectangle.width, n);
                n3 = Math.max(rectangle.y + rectangle.height + n2, n3);
                xSDAbstractComponentImpl.setLocation(rectangle.x, rectangle.y + n2);
            }
            BufferedImage bufferedImage = new BufferedImage(n, n3, 1);
            SwingUtilities.paintComponent(bufferedImage.getGraphics(), designerViewImpl, designerViewImpl.getParent(), 0, 0, n, n3);
            designerViewImpl.paint(bufferedImage.getGraphics());
            try {
                ImageIO.write((RenderedImage)bufferedImage, string, file);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            jFrame.setVisible(false);
            return true;
        }
        return false;
    }

    private String getDocumentation(Element element) {
        if (element == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2;
            if (!(nodeList.item(i) instanceof Element) || !"annotation".equals((element2 = (Element)nodeList.item(i)).getLocalName())) continue;
            NodeList nodeList2 = element2.getChildNodes();
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                Element element3;
                Node node = nodeList2.item(j);
                if (!(node instanceof Element) || !"documentation".equals((element3 = (Element)node).getLocalName())) continue;
                NodeList nodeList3 = element3.getChildNodes();
                for (int k = 0; k < nodeList3.getLength(); ++k) {
                    if (k > 0) {
                        stringBuffer.append("<br />");
                    }
                    Node node2 = nodeList3.item(k);
                    stringBuffer.append(this.escapeTextContent(node2.getTextContent()));
                }
            }
        }
        if (stringBuffer.length() == 0) {
            stringBuffer.append("No documentation");
        }
        return stringBuffer.toString();
    }

    private String escapeTextContent(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '<') {
                stringBuffer.append("&lt;");
                continue;
            }
            if (string.charAt(i) == '>') {
                stringBuffer.append("&gt;");
                continue;
            }
            if (string.charAt(i) == '\n') {
                stringBuffer.append("<br>");
                continue;
            }
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }
}

