/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.action.docbook;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class ParametersModel {
    private HashMap parameters;
    private HashMap helps;
    private String currentType = null;
    private HashMap values = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read() {
        this.parameters = new HashMap();
        this.helps = new HashMap();
        this.values = new HashMap();
        URL uRL = this.getClass().getResource("parameters.txt");
        if (uRL == null) {
            System.err.println("Can't find parameters.txt for docbook");
        } else {
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
                try {
                    String string = null;
                    while ((string = bufferedReader.readLine()) != null) {
                        if (string.startsWith("-")) {
                            this.setCurrentType(string);
                            continue;
                        }
                        this.addParameter(string);
                    }
                }
                finally {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void setCurrentType(String string) {
        int n = string.lastIndexOf(".") + 1;
        this.currentType = n > 0 ? string.substring(n) : "NoCategory";
    }

    private void addParameter(String string) {
        if (this.currentType == null) {
            return;
        }
        String[] stringArray = string.split("\u2014");
        if (stringArray != null && stringArray.length == 2) {
            String string2 = stringArray[0].trim();
            String string3 = stringArray[1].trim();
            ArrayList<String> arrayList = (ArrayList<String>)this.parameters.get(this.currentType);
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
                this.parameters.put(this.currentType, arrayList);
            }
            arrayList.add(string2);
            this.helps.put(string2, string3);
        }
    }

    public List getTypes() {
        ArrayList arrayList = new ArrayList(this.parameters.keySet());
        Collections.sort(arrayList);
        return arrayList;
    }

    public List getParameters(String string) {
        return (List)this.parameters.get(string);
    }

    public String getHelp(String string) {
        return (String)this.helps.get(string);
    }

    public void setValue(String string, String string2) {
        if (string != null) {
            if (string2 == null) {
                this.values.remove(string);
            } else {
                this.values.put(string, string2);
            }
        }
    }

    public String getValue(String string) {
        return (String)this.values.get(string);
    }

    public Set getValues() {
        return this.values.entrySet();
    }
}

