/*
 * Decompiled with CFR 0.152.
 */
package DTDDoc;

import DTDDoc.CommentParser;
import DTDDoc.ElementTreeBuilder;
import DTDDoc.ExtendedDTD;
import DTDDoc.ImmutablePair;
import DTDDoc.Tools;
import com.wutka.dtd.DTDAny;
import com.wutka.dtd.DTDAttlist;
import com.wutka.dtd.DTDAttribute;
import com.wutka.dtd.DTDCardinal;
import com.wutka.dtd.DTDChoice;
import com.wutka.dtd.DTDComment;
import com.wutka.dtd.DTDContainer;
import com.wutka.dtd.DTDDecl;
import com.wutka.dtd.DTDElement;
import com.wutka.dtd.DTDEmpty;
import com.wutka.dtd.DTDEntity;
import com.wutka.dtd.DTDEnumeration;
import com.wutka.dtd.DTDItem;
import com.wutka.dtd.DTDMixed;
import com.wutka.dtd.DTDName;
import com.wutka.dtd.DTDNotationList;
import com.wutka.dtd.DTDPCData;
import com.wutka.dtd.DTDProcessingInstruction;
import com.wutka.dtd.DTDSequence;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.Collator;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;

public class DTDCommenter {
    private File sourceDir = null;
    private File destDir = null;
    char CODE_SEPARATOR_DEPRECATED = (char)63;
    char CODE_SEPARATOR = (char)37;
    LinkedList elementsIndex = new LinkedList();
    private String header = null;
    private String footer = null;
    private boolean showHiddenTags;
    private boolean showFixmeTags;

    public DTDCommenter() {
    }

    public DTDCommenter(String string, String string2) {
        this.header = string;
        this.footer = string2;
    }

    public String getRelativePath(File file) throws IOException {
        String string = this.sourceDir.getCanonicalPath();
        String string2 = file.getCanonicalPath();
        if (string2.startsWith(string)) {
            return string2.substring(string.length() + 1);
        }
        return string2;
    }

    private void makeRelativePath(File file) throws SecurityException, IOException {
        String string = this.getRelativePath(file);
        int n = string.lastIndexOf(File.separatorChar);
        if (n >= 0) {
            String string2 = string.substring(0, n);
            File file2 = new File(this.destDir, string2);
            file2.mkdirs();
        }
    }

    private String makeHREFToParents(ExtendedDTD extendedDTD, DTDElement dTDElement) {
        Iterator iterator = extendedDTD.getParents(dTDElement.getName()).iterator();
        String string = "";
        while (iterator.hasNext()) {
            DTDElement dTDElement2 = (DTDElement)iterator.next();
            string = string + this.makeHREFToElement(extendedDTD, dTDElement2);
            if (!iterator.hasNext()) continue;
            string = string + ",";
        }
        return string;
    }

    private String makeHREFToElement(ExtendedDTD extendedDTD, DTDElement dTDElement) {
        if (dTDElement != null) {
            return "<a href=\"#" + extendedDTD.makeUniqueId(dTDElement) + "\">" + dTDElement.getName() + "</a>";
        }
        return "";
    }

    public String getDTDBaseURI(ExtendedDTD extendedDTD) {
        try {
            return (this.getRelativePath(extendedDTD.getSystemPath()) + ".html").replace(File.separatorChar, '/');
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public URI toURI(String string) {
        try {
            return new URI(string.replace(File.separatorChar, '/'));
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public URI makeURITo(ExtendedDTD extendedDTD) {
        return this.toURI(this.getDTDBaseURI(extendedDTD));
    }

    public URI makeURITo(ExtendedDTD extendedDTD, DTDElement dTDElement) {
        return this.toURI(this.getDTDBaseURI(extendedDTD) + "#" + extendedDTD.makeUniqueId(dTDElement));
    }

    public URI makeURITo(ExtendedDTD extendedDTD, DTDAttlist dTDAttlist, DTDAttribute dTDAttribute) {
        return this.toURI(this.getDTDBaseURI(extendedDTD) + "#" + extendedDTD.makeUniqueId(dTDAttlist, dTDAttribute));
    }

    public URI makeURITo(ExtendedDTD extendedDTD, DTDElement dTDElement, DTDAttribute dTDAttribute) {
        return this.toURI(this.getDTDBaseURI(extendedDTD) + "#" + extendedDTD.makeUniqueId(dTDElement, dTDAttribute));
    }

    public String makeExternalHREF(ExtendedDTD extendedDTD, DTDElement dTDElement, String string) throws IOException {
        return "<a href=\"" + this.makeURITo(extendedDTD, dTDElement).toString() + "\">" + string + "</a>";
    }

    public String makeExternalHREF(ExtendedDTD extendedDTD, String string, String string2) throws IOException {
        return this.makeExternalHREF(extendedDTD, extendedDTD.getElementByName(string), string2);
    }

    String extendContext(String string, DTDCardinal dTDCardinal) {
        if (dTDCardinal == DTDCardinal.NONE) {
            return string + '1';
        }
        if (dTDCardinal == DTDCardinal.OPTIONAL) {
            return string + '?';
        }
        if (dTDCardinal == DTDCardinal.ZEROMANY) {
            return string + '*';
        }
        if (dTDCardinal == DTDCardinal.ONEMANY) {
            return string + '+';
        }
        return string;
    }

    private TreeSet collectChildrenNames(DTDItem dTDItem, String string, ExtendedDTD extendedDTD) throws IOException {
        if (dTDItem instanceof DTDContainer) {
            Enumeration enumeration = ((DTDContainer)dTDItem).getItemsVec().elements();
            string = this.extendContext(string, ((DTDContainer)dTDItem).getCardinal());
            if (dTDItem instanceof DTDChoice) {
                string = string + '|';
            } else if (dTDItem instanceof DTDSequence) {
                string = string + ',';
            } else if (dTDItem instanceof DTDMixed) {
                string = string + '|';
            }
            TreeSet treeSet = null;
            while (enumeration.hasMoreElements()) {
                DTDItem dTDItem2 = (DTDItem)enumeration.nextElement();
                TreeSet treeSet2 = this.collectChildrenNames(dTDItem2, string, extendedDTD);
                if (treeSet != null && treeSet2 != null) {
                    treeSet.addAll(treeSet2);
                    continue;
                }
                treeSet = treeSet2;
            }
            return treeSet;
        }
        if (dTDItem instanceof DTDName) {
            NameInfo nameInfo = new NameInfo((DTDName)dTDItem, this.extendContext(string, ((DTDName)dTDItem).getCardinal()));
            TreeSet<NameInfo> treeSet = new TreeSet<NameInfo>();
            treeSet.add(nameInfo);
            return treeSet;
        }
        if (!(dTDItem instanceof DTDPCData)) {
            return null;
        }
        return null;
    }

    private void showChildrenHelper_print(NameInfo nameInfo, PrintWriter printWriter, ExtendedDTD extendedDTD) {
        DTDElement dTDElement = extendedDTD.getElementByName(nameInfo.getName());
        printWriter.print("<tr>");
        printWriter.print("<td>");
        if (dTDElement == null) {
            printWriter.print(nameInfo.getName());
        } else {
            printWriter.print(this.makeHREFToElement(extendedDTD, dTDElement));
        }
        printWriter.print("</td>");
        if (dTDElement != null) {
            printWriter.print("<td>");
            printWriter.print(nameInfo.getCardinality());
            printWriter.print("</td>");
            printWriter.println("</tr>");
        }
    }

    private void showChildren(DTDElement dTDElement, PrintWriter printWriter, ExtendedDTD extendedDTD) throws IOException {
        String string = "&lt;" + dTDElement.getName() + "&gt;'s children";
        printWriter.println("<table summary=\"" + string + "\" border=\"1\">");
        printWriter.println("<thead>");
        printWriter.println("<tr><th class=\"title\" colspan=\"2\">" + string + "</th></tr>");
        printWriter.println("<tr><th colspan=\"2\" height=\"1\" class=\"ruler\"></th></tr>");
        printWriter.print("<tr>");
        printWriter.print("<th class=\"subtitle\">Name</th>");
        printWriter.print("<th class=\"subtitle\">Cardinality</th>");
        printWriter.println("</tr>");
        printWriter.println("<tr><th colspan=\"2\" height=\"1\" class=\"ruler\"></th></tr>");
        printWriter.println("</thead>");
        printWriter.print("<tbody>");
        TreeSet treeSet = this.collectChildrenNames(dTDElement.getContent(), "", extendedDTD);
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            this.showChildrenHelper_print((NameInfo)iterator.next(), printWriter, extendedDTD);
        }
        printWriter.print("</tbody>");
        printWriter.print("</table>");
    }

    private String getAttributeValues(DTDAttribute dTDAttribute) {
        String string = null;
        if (!(dTDAttribute.getType() instanceof DTDNotationList)) {
            if (dTDAttribute.getType() instanceof DTDEnumeration) {
                DTDEnumeration dTDEnumeration = (DTDEnumeration)dTDAttribute.getType();
                string = "";
                for (int i = 0; i < dTDEnumeration.getItem().length; ++i) {
                    if (i > 0) {
                        string = string + ", ";
                    }
                    string = string + dTDEnumeration.getItem(i);
                }
            } else if (dTDAttribute.getType() instanceof String) {
                string = "<i>Match the " + dTDAttribute.getType() + " rules.</i>";
            }
        }
        return string;
    }

    private boolean attributeValueIsCDATA(DTDAttribute dTDAttribute) {
        return dTDAttribute.getType() instanceof String && "CDATA".equals((String)dTDAttribute.getType());
    }

    private void showAttributes(DTDElement dTDElement, PrintWriter printWriter, ExtendedDTD extendedDTD) {
        String string = "&lt;" + dTDElement.getName() + "&gt;'s attributes";
        printWriter.print("<p></p><table  summary=\"" + string + "\" border=\"1\">");
        printWriter.println("<tr>");
        printWriter.println("<th class=\"title\" colspan=\"3\">" + string + "</th>");
        printWriter.println("</tr>");
        printWriter.println("<tr><th colspan=\"3\" height=\"1\" class=\"ruler\"></th></tr>");
        printWriter.println("<tr>");
        printWriter.print("<th class=\"subtitle\">Name</th>");
        printWriter.print("<th class=\"subtitle\">Values</th>");
        printWriter.print("<th class=\"subtitle\">Default</th>");
        printWriter.println("</tr>");
        printWriter.println("<tr><th colspan=\"3\" height=\"1\" class=\"ruler\"></th></tr>");
        LinkedList linkedList = Tools.enumerationToList(dTDElement.attributes.keys());
        Collections.sort(linkedList, Collator.getInstance());
        for (String string2 : linkedList) {
            DTDAttribute dTDAttribute = (DTDAttribute)dTDElement.attributes.get(string2);
            printWriter.print("<tr>");
            printWriter.print("<td>");
            printWriter.print("<a href=\"#" + extendedDTD.makeUniqueId(extendedDTD.locateAttributesList(dTDAttribute), dTDAttribute) + "\">");
            printWriter.print(string2 + "</a></td>");
            printWriter.print("<td>");
            if (!this.attributeValueIsCDATA(dTDAttribute)) {
                printWriter.print(this.getAttributeValues(dTDAttribute));
            } else {
                printWriter.print("&nbsp;");
            }
            printWriter.print("</td>");
            printWriter.print("<td>");
            if (dTDAttribute.defaultValue != null) {
                printWriter.print(dTDAttribute.defaultValue);
            } else {
                printWriter.print("&nbsp;");
            }
            printWriter.print("</td>");
            printWriter.print("</tr>");
        }
        printWriter.print("</table>");
    }

    private void showElementTitle(String string, String string2, PrintWriter printWriter, String string3) {
        this.showTitle(false, string, string2, printWriter, string3);
    }

    private void showAttributeTitle(String string, String string2, PrintWriter printWriter, String string3) {
        this.showTitle(true, string, string2, printWriter, string3);
    }

    private void showTitle(boolean bl, String string, String string2, PrintWriter printWriter, String string3) {
        printWriter.print("<p></p>");
        printWriter.println("<table class=\"" + (bl ? "attributeTitle" : "elementTitle") + "\" summary=\"" + string3 + "\" border=\"1\"><tr><td class=\"" + (bl ? "leftAttributeTitle" : "leftElementTitle") + "\">");
        printWriter.print(string);
        printWriter.println("</td><td class=\"" + (bl ? "rightAttributeTitle" : "rightElementTitle") + "\">");
        if (string2 != null) {
            printWriter.println(string2);
        }
        printWriter.println("</td></tr></table>");
    }

    private Vector parseDTDFiles(Set set) throws Exception {
        Vector<ExtendedDTD> vector = new Vector<ExtendedDTD>();
        for (File file : set) {
            vector.add(new ExtendedDTD(file));
        }
        return vector;
    }

    private void makeTOC(Vector vector, String string) throws Exception {
        String[] stringArray;
        File file = new File(this.destDir, "toc.html");
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "US-ASCII");
        PrintWriter printWriter = new PrintWriter(outputStreamWriter);
        DateFormat dateFormat = DateFormat.getDateInstance(2);
        String string2 = dateFormat.format(new Date());
        printWriter.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
        printWriter.println("<html><head>");
        printWriter.println("<meta http-equiv=\"CONTENT-TYPE\" content=\"text/html; charset=US-ASCII\">");
        printWriter.println("<link rel=\"StyleSheet\" href=\"DTDDocStyle.css\" type=\"text/css\" media=\"screen\">");
        printWriter.println("<link rel=\"StyleSheet\" href=\"dtreeStyle.css\" type=\"text/css\" media=\"screen\">");
        ElementTreeBuilder.generateJavascriptSetup(printWriter);
        printWriter.println("<title>" + string + ", " + string2 + "</title>");
        printWriter.println("</head><body>");
        printWriter.println("<h1 class=\"TOCTitle\">" + string + "</h1>");
        printWriter.println("<h2 class=\"TOCTitle\">" + string2 + "</h2>");
        printWriter.println("<a href=\"elementsIndex.html\" target=\"detail\">Elements' index</a><HR/>");
        Object[] objectArray = new ImmutablePair[vector.size()];
        int n = 0;
        for (int i = 0; i < vector.size(); ++i) {
            stringArray = (String[])vector.get(i);
            objectArray[n++] = new ImmutablePair(stringArray.getTitle(), stringArray);
        }
        Arrays.sort(objectArray, 0, n);
        ElementTreeBuilder elementTreeBuilder = new ElementTreeBuilder(printWriter, this, (ImmutablePair[])objectArray);
        elementTreeBuilder.generateTree();
        printWriter.println("</body></html>");
        printWriter.close();
        stringArray = new String[]{"empty.gif", "join.gif", "joinbottom.gif", "line.gif", "minus.gif", "minusbottom.gif", "plus.gif", "plusbottom.gif"};
        File file2 = new File(this.destDir, "img");
        file2.mkdirs();
    }

    private boolean isCodeFragmentSeparator(char c) {
        if (c == this.CODE_SEPARATOR_DEPRECATED) {
            return true;
        }
        return c == this.CODE_SEPARATOR;
    }

    private boolean isPre(String string, int n) {
        if ('<' != string.charAt(n) || n + "<pRE".length() >= string.length()) {
            return false;
        }
        String string2 = string.substring(n, n + "<pRE".length()).toUpperCase();
        return string2.startsWith("<pRE");
    }

    private boolean isPreEnd(String string, int n) {
        if (!string.startsWith("</", n) || n + "</PRE".length() >= string.length()) {
            return false;
        }
        String string2 = string.substring(n, n + "</PRE".length()).toUpperCase();
        return string2.startsWith("</PRE");
    }

    private String guardHtmlCharacter(char c) {
        if (c == '<') {
            return "&lt;";
        }
        if (c == '>') {
            return "&gt;";
        }
        return "" + c;
    }

    private boolean isCharEscaped(String string, int n) {
        if (string.charAt(n) == '\\' && n + 1 < string.length()) {
            return this.isCodeFragmentSeparator(string.charAt(n + 1));
        }
        return false;
    }

    private void forcePrintParagraph(String string, PrintWriter printWriter, String string2) {
        if (!string.startsWith("<p>") && !string.startsWith("<p>")) {
            printWriter.print("<p>");
        }
        if (string2 != null) {
            printWriter.print("<span class=\"inTextTitle\">" + string2 + "</span> ");
        }
        int n = 0;
        boolean bl = false;
        while (n < string.length()) {
            int n2 = 0;
            int n3 = 0;
            while (n < string.length() && Character.isWhitespace(string.charAt(n))) {
                ++n2;
                if (string.charAt(n) == '\n') {
                    ++n3;
                }
                ++n;
            }
            if (n3 >= 2) {
                printWriter.print("</p><p>");
            } else if (n3 == 1) {
                printWriter.println("");
            } else if (n2 > 0) {
                printWriter.print(" ");
            }
            if (n >= string.length()) continue;
            if (this.isPre(string, n)) {
                printWriter.print(string.charAt(n));
                ++n;
                while (n < string.length() && !this.isPreEnd(string, n)) {
                    printWriter.print(string.charAt(n));
                    ++n;
                }
                if (n >= string.length()) continue;
                printWriter.print(string.charAt(n));
                ++n;
                continue;
            }
            if (this.isCharEscaped(string, n)) {
                printWriter.print(string.charAt(n + 1));
                n += 2;
                continue;
            }
            if (this.isCodeFragmentSeparator(string.charAt(n))) {
                printWriter.print("<pRE>");
                ++n;
                while (n < string.length()) {
                    if (this.isCharEscaped(string, n)) {
                        printWriter.print(string.charAt(n + 1));
                        n += 2;
                        continue;
                    }
                    if (this.isCodeFragmentSeparator(string.charAt(n))) break;
                    printWriter.print(this.guardHtmlCharacter(string.charAt(n)));
                    ++n;
                }
                printWriter.print("</PRE>");
                ++n;
                continue;
            }
            printWriter.print(string.charAt(n));
            ++n;
        }
        if (!string.endsWith("</p>") && !string.endsWith("</p>")) {
            printWriter.print("</p>");
        }
    }

    private boolean printBaseCommentTags(PrintWriter printWriter, CommentParser commentParser) {
        String string;
        String string2;
        String string3;
        if (commentParser == null) {
            return false;
        }
        boolean bl = false;
        String string4 = commentParser.getUniqueTagValue("@comment");
        if (string4 != null) {
            this.forcePrintParagraph(string4, printWriter, null);
            bl = true;
        }
        if ((string3 = commentParser.getUniqueTagValue("@hidden")) != null && this.showHiddenTags) {
            this.forcePrintParagraph(string3, printWriter, null);
            bl = true;
        }
        if ((string2 = commentParser.getUniqueTagValue("@fixme")) != null && this.showFixmeTags) {
            this.forcePrintParagraph(string2, printWriter, "To fix :");
            bl = true;
        }
        if ((string = commentParser.getUniqueTagValue("@example")) != null) {
            this.forcePrintParagraph(string, printWriter, "Example :");
            bl = true;
        }
        return bl;
    }

    private void printComment(DTDComment dTDComment, PrintWriter printWriter) {
        CommentParser commentParser;
        if (dTDComment != null && this.printBaseCommentTags(printWriter, commentParser = new CommentParser(dTDComment))) {
            return;
        }
        printWriter.print("<p>Sorry, no documentation.</p>");
    }

    private void makeStyleSheet(File file, File file2) throws FileNotFoundException, IOException {
    }

    private void linkToStyleSheet(ExtendedDTD extendedDTD, PrintWriter printWriter) throws IOException {
        String string = "DTDDocStyle.css";
        String string2 = this.getRelativePath(extendedDTD.getSystemPath());
        for (int i = 0; i < string2.length(); ++i) {
            if (string2.charAt(i) != File.separatorChar) continue;
            string = "../" + string;
        }
        printWriter.println("<link rel=\"StyleSheet\" href=\"" + string + "\" type=\"text/css\" media=\"screen\">");
    }

    private void makeIntroduction(ExtendedDTD extendedDTD, PrintWriter printWriter, String string) throws IOException {
        printWriter.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
        printWriter.println("<html><head>");
        printWriter.println("<meta http-equiv=\"CONTENT-TYPE\" content=\"text/html; charset=" + extendedDTD.getEncoding() + "\">");
        this.linkToStyleSheet(extendedDTD, printWriter);
        if (extendedDTD.getTitle() != null) {
            printWriter.print("<title>");
            printWriter.print(extendedDTD.getTitle());
            printWriter.println("</title>");
        }
        printWriter.println("</head><body>");
        printWriter.print("<p class=\"DTDSource\">");
        if (extendedDTD.getEntities().size() > 0) {
            printWriter.print("<a href=\"" + Tools.pathToURI(extendedDTD.getSystemPath().getName() + ".entities.html") + "\">Entities</a>");
            printWriter.print(" - ");
        }
        printWriter.print("<a href=\"" + Tools.pathToURI(string) + "\">" + extendedDTD.getSystemPath().getName() + "</a>");
        printWriter.print("</p>");
        if (extendedDTD.getTitle() != null) {
            printWriter.print("<h1>");
            printWriter.print(extendedDTD.getTitle());
            printWriter.println("</h1>");
        }
    }

    private void showAttributeUsage(DTDAttribute dTDAttribute, PrintWriter printWriter) {
        String string = null;
        if (this.getAttributeValues(dTDAttribute) != null && !this.attributeValueIsCDATA(dTDAttribute)) {
            string = "<span class=\"inTextTitle\">Possible values</span> : " + this.getAttributeValues(dTDAttribute);
        }
        String string2 = null;
        if (dTDAttribute.decl == DTDDecl.REQUIRED || dTDAttribute.decl == DTDDecl.FIXED) {
            string2 = "<span class=\"inTextTitle\">Required</span>";
        } else if (dTDAttribute.defaultValue != null && dTDAttribute.defaultValue.length() > 0) {
            string2 = "<span class=\"inTextTitle\">Default value</span>: " + dTDAttribute.defaultValue;
        }
        if (string != null || string2 != null) {
            printWriter.print("<p>");
            if (string != null) {
                printWriter.print(string);
            }
            if (string != null && string2 != null) {
                printWriter.print(" - ");
            }
            if (string2 != null) {
                printWriter.print(string2);
            }
            printWriter.print("</p>");
        }
    }

    private void documentAttributesList(ExtendedDTD extendedDTD, DTDAttlist dTDAttlist, PrintWriter printWriter, DTDComment dTDComment) {
        if (dTDAttlist == null || printWriter == null) {
            String string = "documentAttributesList : wrong argument : ";
            if (dTDAttlist == null) {
                string = string + "list ";
            }
            if (printWriter == null) {
                string = string + "out ";
            }
            throw new IllegalArgumentException(string);
        }
        CommentParser commentParser = null;
        Hashtable hashtable = null;
        if (dTDComment != null) {
            commentParser = new CommentParser(dTDComment);
            if (dTDAttlist.getAttribute().length <= 1 || commentParser.getUniqueTagValue("@comment") != null) {
                // empty if block
            }
            hashtable = commentParser.getMultipleTagValue("@attr");
        }
        for (int i = 0; i < dTDAttlist.getAttribute().length; ++i) {
            String string = "Attribute of " + this.makeHREFToElement(extendedDTD, extendedDTD.getElementByName(dTDAttlist.getName()));
            DTDAttribute dTDAttribute = dTDAttlist.getAttribute(i);
            printWriter.println("<a name=\"" + extendedDTD.makeUniqueId(dTDAttlist, dTDAttribute) + "\"></a>");
            this.showAttributeTitle("@" + dTDAttribute.getName(), string, printWriter, dTDAttribute.getName());
            if (hashtable != null) {
                String string2 = (String)hashtable.get(dTDAttribute.getName());
                if (string2 != null) {
                    this.forcePrintParagraph(string2, printWriter, null);
                } else {
                    printWriter.print("<p>Sorry, no documentation.</p>");
                }
            } else if (!this.printBaseCommentTags(printWriter, commentParser)) {
                printWriter.print("<p>Sorry, no documentation.</p>");
            }
            this.showAttributeUsage(dTDAttribute, printWriter);
        }
    }

    void showContainerModel(ExtendedDTD extendedDTD, PrintWriter printWriter, DTDContainer dTDContainer, String string) {
        printWriter.print("(");
        Iterator iterator = dTDContainer.getItemsVec().iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            if (bl) {
                printWriter.print(string);
            } else {
                bl = true;
            }
            this.showElementModel(extendedDTD, printWriter, (DTDItem)iterator.next());
        }
        printWriter.print(")");
    }

    void showElementModel(ExtendedDTD extendedDTD, PrintWriter printWriter, DTDItem dTDItem) {
        if (dTDItem instanceof DTDAny) {
            printWriter.print("ANY");
        } else if (dTDItem instanceof DTDEmpty) {
            printWriter.print("EMPTY");
        } else if (dTDItem instanceof DTDPCData) {
            printWriter.print("#PCDATA");
        } else {
            if (dTDItem instanceof DTDName) {
                printWriter.print(this.makeHREFToElement(extendedDTD, extendedDTD.getElementByName((DTDName)dTDItem)));
            } else if (dTDItem instanceof DTDChoice) {
                this.showContainerModel(extendedDTD, printWriter, (DTDContainer)dTDItem, " | ");
            } else if (dTDItem instanceof DTDSequence) {
                this.showContainerModel(extendedDTD, printWriter, (DTDContainer)dTDItem, ", ");
            } else if (dTDItem instanceof DTDMixed) {
                this.showContainerModel(extendedDTD, printWriter, (DTDContainer)dTDItem, " | ");
            }
            if (dTDItem.getCardinal() == DTDCardinal.OPTIONAL) {
                printWriter.print('?');
            } else if (dTDItem.getCardinal() == DTDCardinal.ZEROMANY) {
                printWriter.print('*');
            } else if (dTDItem.getCardinal() == DTDCardinal.ONEMANY) {
                printWriter.print('+');
            }
        }
    }

    private void makeDocumentation(ExtendedDTD extendedDTD, PrintWriter printWriter, String string) throws Exception {
        this.makeIntroduction(extendedDTD, printWriter, string);
        if (extendedDTD.getEntities().size() > 0) {
            this.makeEntitiesPage(extendedDTD, string);
        }
        DTDComment dTDComment = null;
        Object var5_5 = null;
        boolean bl = false;
        for (int i = 0; i < extendedDTD.getItems().size(); ++i) {
            Object e = extendedDTD.getItems().get(i);
            if (e instanceof DTDComment) {
                dTDComment = (DTDComment)e;
                if (i + 1 < extendedDTD.getItems().size() && extendedDTD.getItems().get(i + 1) instanceof DTDComment && !bl) {
                    this.printComment(dTDComment, printWriter);
                    printWriter.println("<p></p>");
                }
                bl = true;
                continue;
            }
            if (e instanceof DTDAttlist) {
                this.documentAttributesList(extendedDTD, (DTDAttlist)e, printWriter, dTDComment);
                bl = true;
                dTDComment = null;
                continue;
            }
            if (e instanceof DTDElement) {
                boolean bl2;
                bl = true;
                DTDElement dTDElement = (DTDElement)e;
                this.elementsIndex.add(new ImmutablePair(dTDElement.getName(), extendedDTD));
                if (dTDComment == null) {
                    // empty if block
                }
                printWriter.println("<a name=\"" + extendedDTD.makeUniqueId(dTDElement) + "\"></a>");
                String string2 = null;
                string2 = extendedDTD.getParents(dTDElement.getName()) != null ? "Child of " + this.makeHREFToParents(extendedDTD, dTDElement) : "Root element";
                DTDItem dTDItem = dTDElement.getContent();
                String string3 = "&lt;" + dTDElement.getName();
                if (dTDItem instanceof DTDEmpty) {
                    string3 = string3 + "/";
                }
                string3 = string3 + "&gt;";
                if (string2 == null) {
                    this.showElementTitle(string3, null, printWriter, dTDElement.getName());
                } else {
                    this.showElementTitle(string3, string2, printWriter, dTDElement.getName());
                }
                this.printComment(dTDComment, printWriter);
                if (dTDItem instanceof DTDContainer) {
                    boolean bl3;
                    bl2 = dTDElement.attributes != null && dTDElement.attributes.size() > 0;
                    boolean bl4 = bl3 = !(((DTDContainer)dTDItem).getItem(0) instanceof DTDPCData) || ((DTDContainer)dTDItem).getItems().length != 1;
                    if (bl3 || bl2) {
                        printWriter.println("<table summary=\"element info\"><tr>");
                    }
                    if (bl3) {
                        printWriter.print("<td class=\"construct\">");
                        this.showChildren(dTDElement, printWriter, extendedDTD);
                        printWriter.print("</td>");
                    }
                    if (bl2) {
                        printWriter.print("<td class=\"construct\">");
                        this.showAttributes(dTDElement, printWriter, extendedDTD);
                        printWriter.print("</td>");
                    }
                    if (bl3 || bl2) {
                        printWriter.println("</tr></table>");
                    }
                    if (bl3) {
                        printWriter.print("<span class=\"inTextTitle\">Element's model :</span>");
                        printWriter.print("<p class=\"model\">");
                        this.showElementModel(extendedDTD, printWriter, dTDItem);
                        printWriter.print("</p>");
                    }
                } else if (dTDItem instanceof DTDEmpty) {
                    bl = true;
                    boolean bl5 = bl2 = dTDElement.attributes != null && dTDElement.attributes.size() > 0;
                    if (bl2) {
                        this.showAttributes(dTDElement, printWriter, extendedDTD);
                    }
                    printWriter.print("<p class=\"emptyTagNote\">This element is always empty.</p>");
                } else if (dTDItem instanceof DTDAny) {
                    bl = true;
                    boolean bl6 = bl2 = dTDElement.attributes != null && dTDElement.attributes.size() > 0;
                    if (bl2) {
                        this.showAttributes(dTDElement, printWriter, extendedDTD);
                    }
                    printWriter.print("<p class=\"emptyTagNote\">This element accepts any declared element as its children.</p>");
                } else {
                    printWriter.println("type= " + dTDItem.getClass().getName() + " is unsupported !");
                }
                dTDComment = null;
                continue;
            }
            if (!(e instanceof DTDEntity) && !(e instanceof DTDElement) && e instanceof DTDProcessingInstruction) continue;
        }
        printWriter.println("</body></html>");
    }

    private void makeDocumentation(Vector vector) throws Exception {
        if (vector == null) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            ExtendedDTD extendedDTD = (ExtendedDTD)vector.get(i);
            this.makeRelativePath(extendedDTD.getSystemPath());
            String string = new File(this.destDir, this.getRelativePath(extendedDTD.getSystemPath())).getPath();
            FileOutputStream fileOutputStream = new FileOutputStream(string + ".html");
            OutputStreamWriter outputStreamWriter = null;
            outputStreamWriter = extendedDTD.getEncoding() != null ? new OutputStreamWriter((OutputStream)fileOutputStream, extendedDTD.getEncoding()) : new OutputStreamWriter(fileOutputStream);
            PrintWriter printWriter = new PrintWriter(outputStreamWriter);
            this.makeDocumentation(extendedDTD, printWriter, Tools.getFilename(string) + ".org.html");
            printWriter.close();
        }
    }

    private void makeDTDHtml(ExtendedDTD extendedDTD) throws Exception {
        int n;
        File file = new File(this.destDir, this.getRelativePath(extendedDTD.getSystemPath()) + ".org.html");
        Tools.makeFileDir(file);
        FileInputStream fileInputStream = new FileInputStream(extendedDTD.getSystemPath());
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        InputStreamReader inputStreamReader = null;
        OutputStreamWriter outputStreamWriter = null;
        if (extendedDTD.getEncoding() != null) {
            inputStreamReader = new InputStreamReader((InputStream)fileInputStream, extendedDTD.getEncoding());
            outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, extendedDTD.getEncoding());
        } else {
            inputStreamReader = new InputStreamReader(fileInputStream);
            outputStreamWriter = new OutputStreamWriter(fileOutputStream);
        }
        PrintWriter printWriter = new PrintWriter(outputStreamWriter);
        printWriter.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
        printWriter.println("<html> <head>");
        printWriter.println("<meta http-equiv=\"CONTENT-TYPE\" content=\"text/html; charset=" + extendedDTD.getEncoding() + "\">");
        this.linkToStyleSheet(extendedDTD, printWriter);
        printWriter.println("<title>DTD</title>");
        printWriter.println("</head><body><pre>");
        while ((n = inputStreamReader.read()) != -1) {
            char c = (char)n;
            if (c == '<') {
                printWriter.print("&lt;");
                continue;
            }
            printWriter.print(c);
        }
        printWriter.println("</pre></body></html>");
        inputStreamReader.close();
        outputStreamWriter.close();
    }

    private void makeIntroPageHtml(String string) throws Exception {
        File file = new File(this.destDir, "intro.html");
        FileWriter fileWriter = new FileWriter(file);
        PrintWriter printWriter = new PrintWriter(fileWriter);
        printWriter.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
        printWriter.println("<html><head>");
        printWriter.println("<link rel=\"StyleSheet\" href=\"DTDDocStyle.css\" type=\"text/css\" media=\"screen\">");
        printWriter.println("</head><body>");
        printWriter.println("<h1>" + string + "</h1>");
        printWriter.println("<p>This documentation was generated by <a href=\"http://dtddoc.sourceforge.net\">DTDDoc</a> !</p>");
        printWriter.println("<p>Use the left menu to navigate through the DTDs !</p>");
        printWriter.println("</body></html>");
        printWriter.close();
    }

    private void makeIndexHtml() throws Exception {
        File file = new File(this.destDir, "index.html");
        FileWriter fileWriter = new FileWriter(file);
        PrintWriter printWriter = new PrintWriter(fileWriter);
        printWriter.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 frameset//EN\" \"http://www.w3.org/TR/html4/frameset.dtd\">\n<html><head><title>DTD Documentation</title></head>\n<frameset cols=\"20%, 80%\">\n   <frame src=\"toc.html\">\n   <frame src=\"intro.html\" name=\"detail\">\n   <noframes><p>I need frames to work !</p></noframes>\n</frameset></html>");
        printWriter.close();
    }

    private void htmlizeDTD(Vector vector) throws Exception {
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            this.makeDTDHtml((ExtendedDTD)iterator.next());
        }
    }

    private void makeElementsIndex() throws IOException {
        char c;
        String string;
        FileWriter fileWriter = new FileWriter(new File(this.destDir, "elementsIndex.html"));
        PrintWriter printWriter = new PrintWriter(fileWriter);
        printWriter.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
        printWriter.println("<html><head>");
        printWriter.println("<meta http-equiv=\"CONTENT-TYPE\" content=\"text/html; charset=US-ASCII\">");
        printWriter.println("<link rel=\"StyleSheet\" href=\"DTDDocStyle.css\" type=\"text/css\" media=\"screen\">");
        printWriter.println("</head><body>");
        Collections.sort(this.elementsIndex);
        String string2 = "";
        char c2 = ' ';
        Iterator iterator = this.elementsIndex.iterator();
        while (iterator.hasNext()) {
            string = (String)((Object)((ImmutablePair)iterator.next()).getKey());
            c = Character.toUpperCase(string.charAt(0));
            if (c == c2) continue;
            c2 = c;
            string2 = string2 + "<a href=\"#" + c2 + "\">" + c2 + "</a> ";
        }
        printWriter.println(string2);
        printWriter.println("<p></p>");
        c2 = ' ';
        string = null;
        c = '\u0000';
        for (ImmutablePair immutablePair : this.elementsIndex) {
            ExtendedDTD extendedDTD = (ExtendedDTD)immutablePair.getValue();
            String string3 = (String)((Object)immutablePair.getKey());
            char c3 = Character.toUpperCase(string3.charAt(0));
            if (c3 != c2) {
                c2 = c3;
                printWriter.println("<a name=\"" + c2 + "\"></a>");
                printWriter.println("<h2>" + c2 + "</h2>");
                c = '\u0000';
            }
            String string4 = this.makeExternalHREF(extendedDTD, (String)((Object)immutablePair.getKey()), Tools.escapeHTMLUnicode(extendedDTD.getTitle(), false));
            if (!string3.equals(string)) {
                string = string3;
                if (c != '\u0000') {
                    printWriter.println("<p></p>");
                } else {
                    c = '\u0001';
                }
                printWriter.print(immutablePair.getKey() + " - " + string4);
                continue;
            }
            printWriter.print(", " + string4);
        }
        printWriter.println("</body></html>");
        printWriter.close();
    }

    public void createDocumentation(ExtendedDTD extendedDTD, PrintWriter printWriter, boolean bl) throws IOException {
        Object var9_11;
        Iterator iterator;
        printWriter.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
        printWriter.println("<html>");
        if (this.header != null) {
            printWriter.println(this.header);
        }
        printWriter.println("<body>");
        printWriter.println("<a href=\"#entities\">Entities</a> | <a href=\"#elements\">Elements</a>");
        boolean bl2 = false;
        String string = "";
        if (bl) {
            string = " for " + extendedDTD.getTitle();
        }
        if ((iterator = extendedDTD.getEntities().values().iterator()).hasNext()) {
            bl2 = true;
            printWriter.println("<a name=\"entities\"></a><h2>Entities " + string + "</h2>");
            printWriter.println("<table summary=\"Entities\" border=\"1\">");
            printWriter.println("<thead><th>Name</th><th>Value</th></thead>");
            printWriter.println("<tbody>");
            printWriter.println("<tr><th colspan=\"2\" height=\"1\" class=\"ruler\"></th></tr>");
        }
        while (iterator.hasNext()) {
            printWriter.println("<tr>");
            DTDEntity dTDEntity = (DTDEntity)iterator.next();
            printWriter.println("<td>" + dTDEntity.name + "</td>");
            printWriter.println("<td>");
            if (dTDEntity.value != null) {
                printWriter.println(dTDEntity.value);
            }
            if (dTDEntity.ndata != null) {
                printWriter.println(dTDEntity.ndata);
            }
            if (dTDEntity.externalID != null) {
                printWriter.println(dTDEntity.externalID.system + " <i>(system)</i>");
            }
            printWriter.println("</td>");
            printWriter.println("</tr>");
        }
        if (bl2) {
            printWriter.println("</tbody>");
            printWriter.println("</table>");
        }
        printWriter.println("<a name=\"elements\"></a><h2>Elements " + string + "</h2>");
        boolean bl3 = false;
        for (int i = 0; i < extendedDTD.getItems().size(); ++i) {
            var9_11 = extendedDTD.getItems().get(i);
            if (!(var9_11 instanceof DTDElement)) continue;
            DTDElement dTDElement = var9_11;
            if (bl3) {
                printWriter.write(" | ");
            }
            printWriter.write("<a href=\"#" + extendedDTD.makeUniqueId(dTDElement) + "\">" + dTDElement.getName() + "</a>");
            bl3 = true;
        }
        DTDComment dTDComment = null;
        var9_11 = null;
        boolean bl4 = false;
        for (int i = 0; i < extendedDTD.getItems().size(); ++i) {
            Object e = extendedDTD.getItems().get(i);
            if (e instanceof DTDComment) {
                dTDComment = (DTDComment)e;
                if (i + 1 < extendedDTD.getItems().size() && extendedDTD.getItems().get(i + 1) instanceof DTDComment && !bl4) {
                    printWriter.println("<font color=\"green\">");
                    this.printComment(dTDComment, printWriter);
                    printWriter.println("</font><p></p>");
                }
                bl4 = true;
                continue;
            }
            if (e instanceof DTDAttlist) {
                this.documentAttributesList(extendedDTD, (DTDAttlist)e, printWriter, dTDComment);
                bl4 = true;
                dTDComment = null;
                continue;
            }
            if (e instanceof DTDElement) {
                boolean bl5;
                printWriter.println("<hr>");
                bl4 = true;
                DTDElement dTDElement = (DTDElement)e;
                this.elementsIndex.add(new ImmutablePair(dTDElement.getName(), extendedDTD));
                printWriter.println("<a name=\"" + extendedDTD.makeUniqueId(dTDElement) + "\"></a>");
                String string2 = null;
                string2 = extendedDTD.getParents(dTDElement.getName()) != null ? "Child of " + this.makeHREFToParents(extendedDTD, dTDElement) : "Root element";
                DTDItem dTDItem = dTDElement.getContent();
                String string3 = "&lt;" + dTDElement.getName();
                if (dTDItem instanceof DTDEmpty) {
                    string3 = string3 + "/";
                }
                string3 = string3 + "&gt;";
                if (string2 == null) {
                    this.showElementTitle(string3, null, printWriter, dTDElement.getName());
                } else {
                    this.showElementTitle(string3, string2, printWriter, dTDElement.getName());
                }
                this.printComment(dTDComment, printWriter);
                if (dTDItem instanceof DTDContainer) {
                    boolean bl6;
                    bl5 = dTDElement.attributes != null && dTDElement.attributes.size() > 0;
                    boolean bl7 = bl6 = !(((DTDContainer)dTDItem).getItem(0) instanceof DTDPCData) || ((DTDContainer)dTDItem).getItems().length != 1;
                    if (bl6 || bl5) {
                        // empty if block
                    }
                    if (bl6) {
                        this.showChildren(dTDElement, printWriter, extendedDTD);
                    }
                    if (bl5) {
                        this.showAttributes(dTDElement, printWriter, extendedDTD);
                    }
                    if (bl6 || bl5) {
                        // empty if block
                    }
                    if (bl6) {
                        printWriter.print("<span class=\"inTextTitle\">Element's model :</span>");
                        printWriter.print("<p class=\"model\">");
                        this.showElementModel(extendedDTD, printWriter, dTDItem);
                        printWriter.print("</p>");
                    }
                } else if (dTDItem instanceof DTDEmpty) {
                    bl4 = true;
                    boolean bl8 = bl5 = dTDElement.attributes != null && dTDElement.attributes.size() > 0;
                    if (bl5) {
                        this.showAttributes(dTDElement, printWriter, extendedDTD);
                    }
                    printWriter.print("<p class=\"emptyTagNote\">This element is always empty.</p>");
                } else if (dTDItem instanceof DTDAny) {
                    bl4 = true;
                    boolean bl9 = bl5 = dTDElement.attributes != null && dTDElement.attributes.size() > 0;
                    if (bl5) {
                        this.showAttributes(dTDElement, printWriter, extendedDTD);
                    }
                    printWriter.print("<p class=\"emptyTagNote\">This element accepts any declared element as its children.</p>");
                } else {
                    printWriter.println("type= " + dTDItem.getClass().getName() + " is unsupported !");
                }
                dTDComment = null;
                continue;
            }
            if (!(e instanceof DTDEntity) && !(e instanceof DTDElement) && e instanceof DTDProcessingInstruction) continue;
        }
        if (this.footer != null) {
            printWriter.println(this.footer);
        }
        printWriter.println("</body></html>");
        printWriter.close();
    }

    private void makeEntitiesPage(ExtendedDTD extendedDTD, String string) throws IOException {
        File file = new File(this.destDir, this.getRelativePath(extendedDTD.getSystemPath()) + ".entities.html");
        Tools.makeFileDir(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        PrintWriter printWriter = new PrintWriter(fileOutputStream);
        printWriter.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
        printWriter.println("<html><head>");
        printWriter.println("<meta http-equiv=\"CONTENT-TYPE\" content=\"text/html; charset=US-ASCII\">");
        this.linkToStyleSheet(extendedDTD, printWriter);
        printWriter.println("</head><body>");
        printWriter.print("<p class=\"DTDSource\">");
        printWriter.print("<a href=\"" + Tools.pathToURI(extendedDTD.getSystemPath().getName() + ".html") + "\">Elements</a>");
        printWriter.print(" - ");
        printWriter.print("<a href=\"" + Tools.pathToURI(string) + "\">" + extendedDTD.getSystemPath().getName() + "</a>");
        printWriter.print("</p>");
        printWriter.println("<h1>Entities for " + extendedDTD.getTitle() + "</h1>");
        printWriter.println("<table summary=\"Entities\">");
        printWriter.println("<thead><th>Name</th><th>Value</th></thead>");
        printWriter.println("<tbody>");
        printWriter.println("<tr><th colspan=\"2\" height=\"1\" class=\"ruler\"></th></tr>");
        Iterator iterator = extendedDTD.getEntities().values().iterator();
        while (iterator.hasNext()) {
            printWriter.println("<tr>");
            DTDEntity dTDEntity = (DTDEntity)iterator.next();
            printWriter.println("<td>" + dTDEntity.name + "</td>");
            printWriter.println("<td>");
            if (dTDEntity.value != null) {
                printWriter.println(dTDEntity.value);
            }
            if (dTDEntity.ndata != null) {
                printWriter.println(dTDEntity.ndata);
            }
            if (dTDEntity.externalID != null) {
                printWriter.println(dTDEntity.externalID.system + " <i>(system)</i>");
            }
            printWriter.println("</td>");
            printWriter.println("</tr>");
        }
        printWriter.println("</tbody>");
        printWriter.println("</table>");
        printWriter.println("</body></html>");
        printWriter.close();
    }

    public void commentDTDs(HashSet hashSet, File file, File file2, boolean bl, boolean bl2, String string, File file3) throws IOException, Exception {
        this.sourceDir = file;
        this.destDir = file2;
        this.showHiddenTags = bl;
        this.showFixmeTags = bl2;
        if (hashSet != null) {
            file2.mkdir();
            Vector vector = this.parseDTDFiles(hashSet);
            this.makeDocumentation(vector);
            this.htmlizeDTD(vector);
            this.makeTOC(vector, string);
            this.makeIndexHtml();
            this.makeIntroPageHtml(string);
            this.makeStyleSheet(file2, file3);
            this.makeElementsIndex();
        }
    }

    class NameInfo
    implements Comparable {
        public DTDName name;
        public Set contexts;

        public NameInfo(DTDName dTDName, String string) {
            this.name = dTDName;
            this.contexts = new HashSet();
            this.contexts.add(string);
        }

        public String getName() {
            return this.name.getValue();
        }

        public String getCardinality() {
            String string = "1?+*|,";
            String[] stringArray = new String[]{"1?+*?1", "??**??", "+*+**+", "******", "??**||", "1?+*|,"};
            int n = -1;
            for (String string2 : this.contexts) {
                int n2 = string2.length() - 1;
                int n3 = string.indexOf(string2.charAt(n2));
                while (n2 > 0) {
                    int n4 = string.indexOf(string2.charAt(--n2));
                    n3 = string.indexOf(stringArray[n4].charAt(n3));
                }
                if (n == -1) {
                    n = n3;
                    continue;
                }
                if (n == n3) continue;
                return "See model";
            }
            switch (n) {
                case 0: {
                    return "Only one";
                }
                case 1: {
                    return "One or none";
                }
                case 2: {
                    return "At least one";
                }
                case 3: {
                    return "Any number";
                }
            }
            return null;
        }

        public int compareTo(Object object) {
            Collator collator = Collator.getInstance();
            String string = ((NameInfo)object).getName();
            return collator.compare(this.getName(), string);
        }
    }
}

