/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFReference;
import org.apache.fop.pdf.PDFText;
import org.apache.fop.pdf.PDFWritable;

public abstract class PDFObject
implements PDFWritable {
    protected static Log log = LogFactory.getLog((String)(class$org$apache$fop$pdf$PDFObject == null ? (class$org$apache$fop$pdf$PDFObject = PDFObject.class$("org.apache.fop.pdf.PDFObject")) : class$org$apache$fop$pdf$PDFObject).getName());
    private int objnum;
    private int generation = 0;
    private PDFDocument document;
    protected static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("'D:'yyyyMMddHHmmss");
    static /* synthetic */ Class class$org$apache$fop$pdf$PDFObject;

    public int getObjectNumber() {
        if (this.objnum == 0) {
            throw new IllegalStateException("Object has no number assigned: " + this.toString());
        }
        return this.objnum;
    }

    public boolean hasObjectNumber() {
        return this.objnum > 0;
    }

    public void setObjectNumber(int objnum) {
        this.objnum = objnum;
        log.trace((Object)("Assigning " + this + " object number " + objnum));
    }

    public int getGeneration() {
        return this.generation;
    }

    public final PDFDocument getDocument() {
        return this.document;
    }

    public final PDFDocument getDocumentSafely() {
        PDFDocument doc = this.getDocument();
        if (doc == null) {
            throw new IllegalStateException("Parent PDFDocument is unavailable");
        }
        return doc;
    }

    public void setDocument(PDFDocument doc) {
        this.document = doc;
    }

    public String getObjectID() {
        return this.getObjectNumber() + " " + this.getGeneration() + " obj\n";
    }

    public String referencePDF() {
        if (!this.hasObjectNumber()) {
            throw new IllegalArgumentException("Cannot reference this object. It doesn't have an object number");
        }
        String ref = this.getObjectNumber() + " " + this.getGeneration() + " R";
        return ref;
    }

    public PDFReference makeReference() {
        return new PDFReference(this);
    }

    protected int output(OutputStream stream) throws IOException {
        byte[] pdf = this.toPDF();
        stream.write(pdf);
        return pdf.length;
    }

    protected byte[] toPDF() {
        return PDFObject.encode(this.toPDFString());
    }

    protected String toPDFString() {
        throw new UnsupportedOperationException("Not implemented. Use output(OutputStream) instead.");
    }

    public String toInlinePDFString() {
        if (this.hasObjectNumber()) {
            return this.referencePDF();
        }
        return this.toPDFString();
    }

    public static final byte[] encode(String text) {
        return PDFDocument.encode(text);
    }

    protected byte[] encodeText(String text) {
        if (this.getDocumentSafely().isEncryptionActive()) {
            byte[] buf = PDFText.toUTF16(text);
            return PDFText.escapeByteArray(this.getDocument().getEncryption().encrypt(buf, this));
        }
        return PDFObject.encode(PDFText.escapeText(text, false));
    }

    protected byte[] encodeString(String string) {
        return this.encodeText(string);
    }

    protected void formatObject(Object obj, StringBuffer sb) {
        if (obj instanceof PDFWritable) {
            sb.append(((PDFWritable)obj).toInlinePDFString());
        } else if (obj instanceof Number) {
            sb.append(obj);
        } else {
            sb.append("(").append(obj).append(")");
        }
    }

    protected String formatDateTime(Date time) {
        StringBuffer sb = new StringBuffer();
        sb.append(DATE_FORMAT.format(time));
        TimeZone tz = TimeZone.getDefault();
        Calendar cal = Calendar.getInstance();
        cal.setTime(time);
        int era = cal.get(0);
        int year = cal.get(1);
        int month = cal.get(2);
        int day = cal.get(5);
        int dayOfWeek = cal.get(7);
        int milliseconds = cal.get(11) * 1000 * 60 * 60;
        milliseconds += cal.get(12) * 1000 * 60;
        milliseconds += cal.get(13) * 1000;
        int offset = tz.getOffset(era, year, month, day, dayOfWeek, milliseconds += cal.get(14));
        if (offset == 0) {
            sb.append('Z');
        } else {
            if (offset > 0) {
                sb.append('+');
            } else {
                sb.append('-');
            }
            int HOUR = 3600000;
            int offsetHour = Math.abs(offset / 3600000);
            int offsetMinutes = (offset - offsetHour * 3600000) / 60000;
            if (offsetHour < 10) {
                sb.append('0');
            }
            sb.append(Integer.toString(offsetHour));
            sb.append('\'');
            if (offsetMinutes < 10) {
                sb.append('0');
            }
            sb.append(Integer.toString(offsetMinutes));
            sb.append('\'');
        }
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

