/*
 * Decompiled with CFR 0.152.
 */
package org.textmining.extraction.word.model;

import java.io.UnsupportedEncodingException;
import org.textmining.extraction.word.model.PieceDescriptor;
import org.textmining.extraction.word.model.PropertyNode;

public class TextPiece
extends PropertyNode
implements Comparable {
    public static String UNICODE_ENC = "UTF-16LE";
    public static String ASCII_ENC = "Cp1252";

    public TextPiece(int n, int n2, PieceDescriptor pieceDescriptor) throws UnsupportedEncodingException {
        super(n, n2, pieceDescriptor);
    }

    public boolean usesUnicode() {
        return this.getPieceDescriptor().isUnicode();
    }

    public PieceDescriptor getPieceDescriptor() {
        return (PieceDescriptor)this._buf;
    }

    public boolean unicode() {
        return this.getPieceDescriptor().isUnicode();
    }

    public int getFcStart() {
        return this.getPieceDescriptor().getFilePosition();
    }

    public int getFcEnd() {
        return this.getFcStart() + (super.getEnd() - super.getStart()) * (this.getPieceDescriptor().isUnicode() ? 2 : 1);
    }

    public String getText(byte[] byArray) {
        try {
            return new String(byArray, this.getFcStart(), this.getFcEnd() - this.getFcStart(), this.unicode() ? UNICODE_ENC : ASCII_ENC);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException.getMessage());
        }
    }
}

