/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xupdate;

import java.util.Map;
import org.exist.EXistException;
import org.exist.dom.DocumentImpl;
import org.exist.dom.DocumentSet;
import org.exist.dom.StoredNode;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.DBBroker;
import org.exist.storage.NotificationService;
import org.exist.storage.txn.Txn;
import org.exist.util.LockException;
import org.exist.xquery.XPathException;
import org.exist.xupdate.Modification;
import org.w3c.dom.NodeList;

public class Append
extends Modification {
    private int child;

    public Append(DBBroker broker, DocumentSet docs, String selectStmt, String childAttr, Map namespaces, Map variables) {
        super(broker, docs, selectStmt, namespaces, variables);
        this.child = childAttr == null || childAttr.equals("last()") ? -1 : Integer.parseInt(childAttr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long process(Txn transaction) throws PermissionDeniedException, LockException, EXistException, XPathException {
        NodeList children = this.content;
        if (children.getLength() == 0) {
            return 0L;
        }
        try {
            StoredNode[] ql = this.selectAndLock(transaction);
            Modification.IndexListener listener = new Modification.IndexListener(ql);
            NotificationService notifier = this.broker.getBrokerPool().getNotificationService();
            for (int i = 0; i < ql.length; ++i) {
                StoredNode node = ql[i];
                DocumentImpl doc = (DocumentImpl)node.getOwnerDocument();
                doc.getMetadata().setIndexListener(listener);
                if (!doc.getPermissions().validate(this.broker.getUser(), 1)) {
                    throw new PermissionDeniedException("permission to update document denied");
                }
                node.appendChildren(transaction, children, this.child);
                doc.getMetadata().clearIndexListener();
                doc.getMetadata().setLastModified(System.currentTimeMillis());
                this.modifiedDocuments.add(doc);
                this.broker.storeXMLResource(transaction, doc);
                notifier.notifyUpdate(doc, 1);
            }
            this.checkFragmentation(transaction, this.modifiedDocuments);
            long l = ql.length;
            return l;
        }
        finally {
            this.unlockDocuments(transaction);
        }
    }

    public String getName() {
        return "append";
    }
}

