/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions;

import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.DateTimeValue;
import org.exist.xquery.value.DateValue;
import org.exist.xquery.value.DayTimeDurationValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.TimeValue;

public class FunDateTime
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("dateTime", "http://www.w3.org/2005/xpath-functions", ""), "Creates an xs:dateTime from an xs:date and an xs:time.", new SequenceType[]{new SequenceType(51, 3), new SequenceType(52, 3)}, new SequenceType(50, 3));

    public FunDateTime(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        Sequence result;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
        }
        if (args[0].isEmpty() || args[1].isEmpty()) {
            result = Sequence.EMPTY_SEQUENCE;
        } else {
            if (args[0].hasMany()) {
                throw new XPathException("XPTY0004: expected at most one xs:date");
            }
            if (args[1].hasMany()) {
                throw new XPathException("XPTY0004: expected at most one xs:time");
            }
            DateValue dv = (DateValue)args[0].itemAt(0);
            TimeValue tv = (TimeValue)args[1].itemAt(0);
            if (!(dv.getTimezone().isEmpty() || tv.getTimezone().isEmpty() || ((DayTimeDurationValue)dv.getTimezone().itemAt(0)).compareTo(null, 4, (DayTimeDurationValue)tv.getTimezone().itemAt(0)))) {
                throw new XPathException("FORG0008: operands have different timezones");
            }
            String dtv = dv.convertTo(50).getStringValue();
            if (dv.getTimezone().isEmpty()) {
                dtv = dtv.substring(0, dtv.length() - 8);
                result = new DateTimeValue(dtv + tv.getStringValue());
            } else if (((DayTimeDurationValue)dv.getTimezone().itemAt(0)).getStringValue().equals("PT0S")) {
                dtv = dtv.substring(0, dtv.length() - 9);
                result = tv.getTimezone().isEmpty() ? new DateTimeValue(dtv + tv.getStringValue() + "Z") : new DateTimeValue(dtv + tv.getStringValue());
            } else if (tv.getTimezone().isEmpty()) {
                String tz = dtv.substring(19);
                dtv = dtv.substring(0, dtv.length() - 14);
                result = new DateTimeValue(dtv + tv.getStringValue() + tz);
            } else {
                dtv = dtv.substring(0, dtv.length() - 14);
                result = new DateTimeValue(dtv + tv.getStringValue());
            }
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

